/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.solder.logging.internal;

import java.text.MessageFormat;
import org.jboss.solder.logging.internal.Logger;
import org.slf4j.spi.LocationAwareLogger;

final class Slf4jLocationAwareLogger
extends Logger {
    private static final long serialVersionUID = 8685757928087758380L;
    private final LocationAwareLogger logger;

    Slf4jLocationAwareLogger(String name, LocationAwareLogger logger) {
        super(name);
        this.logger = logger;
    }

    public boolean isEnabled(Logger.Level level) {
        if (level != null) {
            switch (level) {
                case FATAL: {
                    return this.logger.isErrorEnabled();
                }
                case ERROR: {
                    return this.logger.isErrorEnabled();
                }
                case WARN: {
                    return this.logger.isWarnEnabled();
                }
                case INFO: {
                    return this.logger.isInfoEnabled();
                }
                case DEBUG: {
                    return this.logger.isDebugEnabled();
                }
                case TRACE: {
                    return this.logger.isTraceEnabled();
                }
            }
        }
        return true;
    }

    protected void doLog(Logger.Level level, String loggerClassName, Object message, Object[] parameters, Throwable thrown) {
        if (this.isEnabled(level)) {
            String text = parameters == null || parameters.length == 0 ? String.valueOf(message) : MessageFormat.format(String.valueOf(message), parameters);
            this.logger.log(null, loggerClassName, Slf4jLocationAwareLogger.translate(level), text, thrown);
        }
    }

    protected void doLogf(Logger.Level level, String loggerClassName, String format, Object[] parameters, Throwable thrown) {
        if (this.isEnabled(level)) {
            String text = parameters == null ? String.format(format, new Object[0]) : String.format(format, parameters);
            this.logger.log(null, loggerClassName, Slf4jLocationAwareLogger.translate(level), text, thrown);
        }
    }

    private static int translate(Logger.Level level) {
        if (level != null) {
            switch (level) {
                case FATAL: 
                case ERROR: {
                    return 40;
                }
                case WARN: {
                    return 30;
                }
                case INFO: {
                    return 20;
                }
                case DEBUG: {
                    return 10;
                }
                case TRACE: {
                    return 0;
                }
            }
        }
        return 0;
    }
}

