/*
 * Copyright (c) 2002, 2004, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package org.jboss.com.sun.corba.se.spi.protocol;

import java.nio.ByteBuffer;

import org.jboss.com.sun.corba.se.impl.protocol.giopmsgheaders.LocateReplyMessage;
import org.jboss.com.sun.corba.se.impl.protocol.giopmsgheaders.LocateReplyOrReplyMessage;
import org.jboss.com.sun.corba.se.impl.protocol.giopmsgheaders.Message;
import org.jboss.com.sun.corba.se.impl.protocol.giopmsgheaders.ReplyMessage;
import org.jboss.com.sun.corba.se.impl.protocol.giopmsgheaders.RequestMessage;
import org.jboss.com.sun.corba.se.pept.protocol.MessageMediator;
import org.jboss.com.sun.corba.se.spi.ior.IOR;
import org.jboss.com.sun.corba.se.spi.ior.ObjectKey;
import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
import org.jboss.com.sun.corba.se.spi.servicecontext.ServiceContexts;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.CORBA_2_3.portable.InputStream;

/**
 * @author Harold Carr
 */
public interface CorbaMessageMediator extends MessageMediator, ResponseHandler
{
    public void setReplyHeader(LocateReplyOrReplyMessage header);

    public LocateReplyMessage getLocateReplyHeader();

    public ReplyMessage getReplyHeader();

    public void setReplyExceptionDetailMessage(String message);

    public RequestMessage getRequestHeader();

    public GIOPVersion getGIOPVersion();

    public byte getEncodingVersion();

    public int getRequestId();

    public Integer getRequestIdInteger();

    public boolean isOneWay();

    public short getAddrDisposition();

    public String getOperationName();

    public ServiceContexts getRequestServiceContexts();

    public ServiceContexts getReplyServiceContexts();

    public Message getDispatchHeader();

    public void setDispatchHeader(Message msg);

    public ByteBuffer getDispatchBuffer();

    public void setDispatchBuffer(ByteBuffer byteBuffer);

    public int getThreadPoolToUse();

    public byte getStreamFormatVersion(); // REVIST name ForRequest?

    public byte getStreamFormatVersionForReply();

    // REVISIT - not sure if the final fragment and DII stuff should
    // go here.

    public void sendCancelRequestIfFinalFragmentNotSent();

    public void setDIIInfo(org.omg.CORBA.Request request);

    public boolean isDIIRequest();

    public Exception unmarshalDIIUserException(String repoId, InputStream inputStream);

    public void setDIIException(Exception exception);

    public void handleDIIReply(InputStream inputStream);

    public boolean isSystemExceptionReply();

    public boolean isUserExceptionReply();

    public boolean isLocationForwardReply();

    public boolean isDifferentAddrDispositionRequestedReply();

    public short getAddrDispositionReply();

    public IOR getForwardedIOR();

    public SystemException getSystemExceptionReply();

    // //////////////////////////////////////////////////
    //
    // Server side
    //

    public ObjectKey getObjectKey();

    public void setProtocolHandler(CorbaProtocolHandler protocolHandler);

    public CorbaProtocolHandler getProtocolHandler();

    // //////////////////////////////////////////////////
    //
    // ResponseHandler
    //

    public org.omg.CORBA.portable.OutputStream createReply();

    public org.omg.CORBA.portable.OutputStream createExceptionReply();

    // //////////////////////////////////////////////////
    //
    // from core.ServerRequest
    //

    public boolean executeReturnServantInResponseConstructor();

    public void setExecuteReturnServantInResponseConstructor(boolean b);

    public boolean executeRemoveThreadInfoInResponseConstructor();

    public void setExecuteRemoveThreadInfoInResponseConstructor(boolean b);

    public boolean executePIInResponseConstructor();

    public void setExecutePIInResponseConstructor(boolean b);
}

// End of file.
