/*
 * Copyright (c) 1997, 2003, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
/*
 * Licensed Materials - Property of IBM
 * RMI-IIOP v1.0
 * Copyright IBM Corp. 1998 1999  All Rights Reserved
 *
 */

package org.jboss.com.sun.corba.se.impl.corba;

import org.jboss.com.sun.corba.se.spi.orb.ORB;

/**
 * The AsynchInvoke class allows for the support of asynchronous invocations. Instances of these are created with a
 * request object, and when run, perform an invocation. The instance is also responsible for waking up a client that
 * might be waiting on the 'get_response' method.
 */
public class AsynchInvoke implements Runnable
{

    private RequestImpl _req;

    private ORB _orb;

    private boolean _notifyORB;

    public AsynchInvoke(ORB o, RequestImpl reqToInvokeOn, boolean n)
    {
        _orb = o;
        _req = reqToInvokeOn;
        _notifyORB = n;
    };

    /*
     * The run operation calls the invocation on the request object, updates the RequestImpl state to indicate that the
     * asynchronous invocation is complete, and wakes up any client that might be waiting on a 'get_response' call.
     */
    public void run()
    {
        // do the actual invocation
        _req.doInvocation();

        // for the asynchronous case, note that the response has been
        // received.
        synchronized (_req)
        {
            // update local boolean indicator
            _req.gotResponse = true;

            // notify any client waiting on a 'get_response'
            _req.notify();
        }

        if (_notifyORB == true)
        {
            _orb.notifyORB();
        }
    }

};
