package javax.json.stream;

import javax.json.JsonException;

/**
 * {@code JsonParsingException} is used when an incorrect JSON is
 * being parsed.
 *
 * @author Jitendra Kotamraju
 */
public class JsonParsingException extends JsonException {

    private final JsonLocation location;

    /**
     * Constructs a new runtime exception with the specified detail message.
     * The cause is not initialized, and may subsequently be initialized by a
     * call to {@link #initCause}.
     *
     * @param message the detail message. The detail message is saved for
     *                later retrieval by the {@link #getMessage()} method.
     * @param location the location of the incorrect JSON
     */
    public JsonParsingException(String message, JsonLocation location) {
        super(message);
        this.location = location;
    }

    /**
     * Constructs a new runtime exception with the specified detail message and
     * cause.  <p>Note that the detail message associated with
     * {@code cause} is <i>not</i> automatically incorporated in
     * this runtime exception's detail message.
     *
     * @param message the detail message (which is saved for later retrieval
     *                by the {@link #getMessage()} method).
     * @param cause the cause (which is saved for later retrieval by the
     *              {@link #getCause()} method). (A <tt>null</tt> value is
     *              permitted, and indicates that the cause is nonexistent or
     *              unknown.)
     * @param location the location of the incorrect JSON
     */
    public JsonParsingException(String message, Throwable cause, JsonLocation location) {
        super(message, cause);
        this.location = location;
    }

    /**
     * Return the location of the incorrect JSON.
     *
     * @return the non-null location of the incorrect JSON
     */
    public JsonLocation getLocation() {
        return location;
    }

}

