/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.switchboard.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.logging.Logger;
import org.jboss.switchboard.spi.Resource;
import org.jboss.util.naming.Util;

public class ENCOperator {
    private static Logger logger = Logger.getLogger(ENCOperator.class);
    private Context jndiContext;
    private Map<String, Resource> encBindings = new HashMap<String, Resource>();
    private boolean contextPopulated;

    public ENCOperator(Map<String, Resource> bindings) {
        this.encBindings = bindings;
    }

    public ENCOperator(Context jndiContext, Map<String, Resource> bindings) {
        this(bindings);
        this.jndiContext = jndiContext;
    }

    public void bind() throws NamingException {
        for (Map.Entry<String, Resource> binding : this.encBindings.entrySet()) {
            String jndiName = binding.getKey();
            Object jndiObject = binding.getValue().getTarget();
            Util.bind((Context)this.jndiContext, (String)jndiName, (Object)jndiObject);
            logger.debug((Object)("ENCOperator " + this.jndiContext + " bound ENC resource in java:comp namespace at jndiName " + jndiName));
        }
        this.contextPopulated = true;
    }

    public void unbind() throws NamingException {
        for (Map.Entry<String, Resource> binding : this.encBindings.entrySet()) {
            String jndiName = binding.getKey();
            this.jndiContext.unbind(jndiName);
            logger.debug((Object)("ENCOperator " + this.jndiContext + " unbound ENC resource in java:comp namespace from jndiName " + jndiName));
        }
        this.contextPopulated = false;
    }

    public void setContext(Context ctx) {
        if (this.jndiContext != null) {
            throw new IllegalStateException("JNDI context is already set on ENCOperator: " + this);
        }
        this.jndiContext = ctx;
    }

    public Map<String, Resource> getENCBindings() {
        return Collections.unmodifiableMap(this.encBindings);
    }

    public boolean isENCInitialized() {
        return this.contextPopulated;
    }

    public void addENCBinding(Map<String, Resource> resources) {
        if (resources == null) {
            throw new IllegalArgumentException("Resources cannot be null while adding ENC bindings to barrier: " + this);
        }
        if (this.contextPopulated) {
            throw new IllegalStateException("ENC context for barrier: " + this + " is already populated, cannot add more ENC bindings");
        }
        this.encBindings.putAll(resources);
    }
}

