/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.switchboard.impl;

import java.util.HashMap;
import java.util.Map;
import org.jboss.switchboard.impl.ResourceProviderRegistry;
import org.jboss.switchboard.spi.EnvironmentEntryType;
import org.jboss.switchboard.spi.JndiEnvironment;
import org.jboss.switchboard.spi.Resource;
import org.jboss.switchboard.spi.ResourceProvider;

public class JndiEnvironmentProcessor<C> {
    private ResourceProviderRegistry<C> registry;

    public JndiEnvironmentProcessor(ResourceProviderRegistry<C> registry) {
        this.registry = registry;
    }

    public Map<String, Resource> process(C context, JndiEnvironment environment) {
        HashMap<String, Resource> resources = new HashMap<String, Resource>();
        for (EnvironmentEntryType type : environment.getEntries()) {
            ResourceProvider<C, EnvironmentEntryType> provider = this.registry.getResourceProvider(type.getClass());
            if (provider == null) continue;
            Resource resource = provider.provide(context, type);
            resources.put(type.getName(), resource);
        }
        return resources;
    }
}

