/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.switchboard.javaee.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import org.jboss.switchboard.javaee.environment.InjectionTarget;
import org.jboss.switchboard.javaee.environment.JavaEEResourceType;

public class InjectionTargetUtil {
    public static AccessibleObject findInjectionTarget(ClassLoader loader, InjectionTarget target) {
        Class<?> clazz = null;
        try {
            clazz = loader.loadClass(target.getTargetClass());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("<injection-target> class: " + target.getTargetClass() + " was not found in deployment");
        }
        for (Field field : clazz.getDeclaredFields()) {
            if (!target.getTargetName().equals(field.getName())) continue;
            return field;
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
            if (!((Method)accessibleObject).getName().equals(target.getTargetName())) continue;
            return accessibleObject;
        }
        throw new RuntimeException("<injection-target> could not be found: " + target.getTargetClass() + "." + target.getTargetName());
    }

    public static Class<?> getInjectionTargetPropertyType(ClassLoader cl, InjectionTarget injectionTarget) {
        AccessibleObject accessibleObject = InjectionTargetUtil.findInjectionTarget(cl, injectionTarget);
        if (accessibleObject instanceof Field) {
            return ((Field)accessibleObject).getType();
        }
        if (accessibleObject instanceof Method) {
            return ((Method)accessibleObject).getParameterTypes()[0];
        }
        return null;
    }

    public static Class<?> getInjectionTargetPropertyType(ClassLoader cl, JavaEEResourceType javaeeResource) {
        Collection<InjectionTarget> injectionTargets = javaeeResource.getInjectionTargets();
        if (injectionTargets == null || injectionTargets.isEmpty()) {
            return null;
        }
        InjectionTarget injectionTarget = injectionTargets.iterator().next();
        Class<?> type = InjectionTargetUtil.getInjectionTargetPropertyType(cl, injectionTarget);
        return type;
    }
}

