/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.switchboard.jbmeta.javaee.environment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import org.jboss.metadata.javaee.spec.PortComponentRef;
import org.jboss.metadata.javaee.spec.ServiceReferenceHandlerMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferenceHandlersMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferenceMetaData;
import org.jboss.switchboard.javaee.environment.Handler;
import org.jboss.switchboard.javaee.environment.PortComponent;
import org.jboss.switchboard.javaee.environment.ServiceRefType;
import org.jboss.switchboard.jbmeta.javaee.environment.InjectionTargetConverter;
import org.jboss.switchboard.jbmeta.javaee.environment.JavaEEResource;
import org.jboss.switchboard.jbmeta.javaee.environment.ServiceHandler;
import org.jboss.switchboard.jbmeta.javaee.environment.ServicePortComponent;

public class ServiceReference
extends JavaEEResource
implements ServiceRefType {
    private ServiceReferenceMetaData delegate;
    private List<Handler> handlers;
    private Collection<PortComponent> portComponents;

    public ServiceReference(ServiceReferenceMetaData delegate) {
        super(delegate.getLookupName(), delegate.getMappedName(), InjectionTargetConverter.convert(delegate.getInjectionTargets()));
        this.delegate = delegate;
        this.initHandlers();
        this.initPortComponents();
    }

    public List<Handler> getHandlerChain() {
        return this.handlers;
    }

    public Collection<Handler> getHandlers() {
        return this.handlers;
    }

    public String getMappingFile() {
        return this.delegate.getJaxrpcMappingFile();
    }

    public Collection<PortComponent> getPortComponents() {
        return this.portComponents;
    }

    public QName getQName() {
        return this.delegate.getServiceQname();
    }

    public String getServiceInterface() {
        return this.delegate.getServiceInterface();
    }

    public String getType() {
        return this.delegate.getServiceRefType();
    }

    public String getWsdlFile() {
        return this.delegate.getWsdlFile();
    }

    public String getName() {
        return "env/" + this.delegate.getServiceRefName();
    }

    private void initHandlers() {
        if (this.delegate.getHandlers() == null) {
            return;
        }
        ServiceReferenceHandlersMetaData serviceHandlers = this.delegate.getHandlers();
        this.handlers = new ArrayList<Handler>(serviceHandlers.size());
        for (ServiceReferenceHandlerMetaData serviceHandler : serviceHandlers) {
            this.handlers.add(new ServiceHandler(serviceHandler));
        }
    }

    private void initPortComponents() {
        if (this.delegate.getPortComponentRef() == null) {
            return;
        }
        List portComponentRefs = this.delegate.getPortComponentRef();
        this.portComponents = new ArrayList<PortComponent>(portComponentRefs.size());
        for (PortComponentRef portCompRef : portComponentRefs) {
            this.portComponents.add(new ServicePortComponent(portCompRef));
        }
    }
}

