/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.switchboard.spi;

import javax.naming.Context;

/**
 * A SwitchBoard {@link Barrier} provides a way to add dependencies
 * on component for a fully populated java:comp ENC {@link Context context}.
 * 
 * <p>
 *  A {@link Barrier} is identified by a unique {@link #getId() id} which can used
 *  in a dependency management runtime to setup dependencies between a {@link Barrier} 
 *  and a dependent component. The dependent component typically depend on a fully
 *  populated {@link Context context}. 
 * </p>
 * <p>
 *  A {@link Barrier} depends on multiple {@link Resource#getDependency() resources} provided by 
 *  various {@link ResourceProvider resource providers}. When all those dependencies are resolved
 *  the {@link Barrier barrier} reaches a fully installed state, at which point the java:comp
 *  {@link #getContext() context} is fully populated with environment entries 
 * </p>
 *
 * @author Jaikiran Pai
 * @version $Revision: $
 */
public interface Barrier
{

   /**
    * Returns the id for this {@link Barrier}. 
    * <p>
    *   The {@link Barrier} will be deployed in a dependency management runtime and
    *   will be identified by this unique id. Any component which wants to depend on this
    *   Barrier can add appropriate dependencies (using dependency management runtime provided ways) 
    *   on this {@link Barrier} using this id. 
    * </p>
    * @return
    */
   String getId();
   
   /**
    * Returns the naming context which represents the java:comp of a 
    * Java EE component. 
    * <p>
    *   The returned {@link Context} is fully populated with environment entries
    *   <i>only</i> after the dependencies on this {@link Barrier} have been fully
    *   resolved.
    * </p>
    * @return
    */
   Context getContext();
}
