/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tck.spec.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jboss.tck.spec.audit.Assertion;
import org.jboss.tck.spec.audit.Group;
import org.jboss.tck.spec.audit.Section;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TckAuditSaxParser
extends DefaultHandler {
    List<Section> sections = new ArrayList<Section>();
    List<Group> groups = new ArrayList<Group>();
    private StringBuffer tmpVal;
    private Section tmpSection;
    private Assertion tmpAssertion;
    private Group tmpGroup;
    private String xmlFilePath;
    private boolean groupTextExist;
    private static final Logger log = Logger.getLogger(TckAuditSaxParser.class.getName());

    public TckAuditSaxParser(String xmlFilePath) {
        this.xmlFilePath = xmlFilePath;
    }

    public void parseDocument() {
        log.fine("Starting parsing of audit file.");
        SAXParserFactory spf = SAXParserFactory.newInstance();
        try {
            SAXParser sp = spf.newSAXParser();
            sp.parse(this.xmlFilePath, (DefaultHandler)this);
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (IOException ie) {
            new Exception("Cannot find " + this.xmlFilePath + " :" + ie.getStackTrace().toString());
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.tmpVal = new StringBuffer();
        if (qName.equalsIgnoreCase("section")) {
            this.tmpSection = new Section();
            this.tmpSection.setId(attributes.getValue("id"));
            this.tmpSection.setTitle(attributes.getValue("title"));
            this.tmpSection.setLevel(Integer.valueOf(attributes.getValue("level")));
        } else if (qName.equalsIgnoreCase("group")) {
            this.tmpGroup = new Group();
            this.groupTextExist = true;
        } else if (qName.equals("assertion")) {
            this.tmpAssertion = new Assertion();
            if (attributes.getValue("id") != null) {
                this.tmpAssertion.setId(attributes.getValue("id"));
            }
            if (attributes.getValue("testable") != null) {
                this.tmpAssertion.setTestable(Boolean.valueOf(attributes.getValue("testable")));
            }
            if (this.tmpGroup != null) {
                this.tmpGroup.getAssertions().add(this.tmpAssertion);
                this.tmpAssertion.setGroup(this.tmpGroup);
            } else {
                this.tmpSection.getSectionElements().add(this.tmpAssertion);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.tmpVal.append(new String(ch, start, length));
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("section")) {
            this.sections.add(this.tmpSection);
        } else if (qName.equalsIgnoreCase("text") && !this.groupTextExist) {
            this.tmpAssertion.setText(this.tmpVal.toString().replace("|", "").replace("_", "").replace("~", ""));
        } else if (qName.equalsIgnoreCase("note")) {
            this.tmpAssertion.setNote(this.tmpVal.toString());
        } else if (qName.equalsIgnoreCase("text") && this.groupTextExist) {
            this.tmpGroup.setText(this.tmpVal.toString().replace("|", "").replace("_", "").replace("~", ""));
            this.groupTextExist = false;
        } else if (qName.equalsIgnoreCase("group")) {
            this.tmpSection.getSectionElements().add(this.tmpGroup);
            this.tmpGroup = null;
        }
    }

    public List<Section> getSections() {
        return this.sections;
    }

    public List<Group> getGroups() {
        return this.groups;
    }
}

