/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.infinispan.api;

import com.squareup.protoparser.DataType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import org.infinispan.protostream.descriptors.Type;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.BlobImpl;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.types.TransformationException;
import org.teiid.core.types.basic.ObjectToAnyTransform;
import org.teiid.core.util.ObjectConverterUtil;

public class ProtobufDataManager {
    private static HashMap<DataType.ScalarType, String> protoTypes = new HashMap();
    private static HashMap<String, DataType.ScalarType> teiidTypes = new HashMap();

    public static String teiidType(DataType protoType, boolean array, boolean isEnum) {
        if (isEnum) {
            return "integer";
        }
        String type = protoTypes.get(protoType);
        if (type == null) {
            type = "string";
        }
        if (array) {
            type = type + "[]";
        }
        return type;
    }

    public static Object convertToRuntime(Class expectedType, Object contents) throws IOException {
        if (contents == null || expectedType.isInstance(contents)) {
            return contents;
        }
        if (expectedType.isArray()) {
            expectedType = expectedType.getComponentType();
        }
        if (contents instanceof Long) {
            Long rawContents = (Long)contents;
            if (expectedType.isAssignableFrom(Date.class)) {
                return new Date(rawContents);
            }
            if (expectedType.isAssignableFrom(Timestamp.class)) {
                return new Timestamp(rawContents);
            }
            if (expectedType.isAssignableFrom(Time.class)) {
                return new Time(rawContents);
            }
        } else if (!(contents instanceof String)) {
            if (contents instanceof byte[]) {
                final byte[] rawContents = (byte[])contents;
                if (expectedType.isAssignableFrom(String.class)) {
                    try {
                        return new String(rawContents, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new IOException(e);
                    }
                }
                if (expectedType.isAssignableFrom(BigInteger.class)) {
                    return new BigInteger(rawContents);
                }
                if (expectedType.isAssignableFrom(BigDecimal.class)) {
                    return new BigDecimal(new BigInteger(rawContents));
                }
                if (expectedType.isAssignableFrom(Clob.class)) {
                    return new ClobImpl(new InputStreamFactory(){

                        public InputStream getInputStream() throws IOException {
                            return new ByteArrayInputStream(rawContents);
                        }
                    }, -1L);
                }
                if (expectedType.isAssignableFrom(Blob.class)) {
                    return new BlobImpl(new InputStreamFactory(){

                        public InputStream getInputStream() throws IOException {
                            return new ByteArrayInputStream(rawContents);
                        }
                    });
                }
                if (expectedType.isAssignableFrom(SQLXML.class)) {
                    return new SQLXMLImpl(rawContents);
                }
            } else {
                try {
                    return ObjectToAnyTransform.INSTANCE.transform(contents, expectedType);
                }
                catch (TransformationException e) {
                    throw new IOException(e);
                }
            }
        }
        return contents;
    }

    public static <T> T convertToInfinispan(Class<T> expectedType, Object contents) throws IOException {
        if (contents == null || expectedType.isInstance(contents)) {
            return expectedType.cast(contents);
        }
        if (contents instanceof Date && expectedType.isAssignableFrom(Long.class)) {
            return expectedType.cast(((Date)contents).getTime());
        }
        if (contents instanceof Timestamp && expectedType.isAssignableFrom(Long.class)) {
            return expectedType.cast(((Timestamp)contents).getTime());
        }
        if (contents instanceof Time && expectedType.isAssignableFrom(Long.class)) {
            return expectedType.cast(((Time)contents).getTime());
        }
        if (contents instanceof Date && expectedType.isAssignableFrom(byte[].class)) {
            long l = ((Date)contents).getTime();
            return expectedType.cast(ByteBuffer.allocate(8).putLong(l).array());
        }
        if (contents instanceof Timestamp && expectedType.isAssignableFrom(byte[].class)) {
            long l = ((Timestamp)contents).getTime();
            return expectedType.cast(ByteBuffer.allocate(8).putLong(l).array());
        }
        if (contents instanceof Time && expectedType.isAssignableFrom(byte[].class)) {
            long l = ((Time)contents).getTime();
            return expectedType.cast(ByteBuffer.allocate(8).putLong(l).array());
        }
        if (contents instanceof String && expectedType.isAssignableFrom(byte[].class)) {
            return expectedType.cast(((String)contents).getBytes("UTF-8"));
        }
        if (contents instanceof Clob && expectedType.isAssignableFrom(byte[].class)) {
            try {
                return expectedType.cast(ObjectConverterUtil.convertToByteArray((InputStream)((Clob)contents).getAsciiStream()));
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }
        if (contents instanceof Blob && expectedType.isAssignableFrom(byte[].class)) {
            try {
                return expectedType.cast(ObjectConverterUtil.convertToByteArray((InputStream)((Blob)contents).getBinaryStream(), (int)DataTypeManager.MAX_VARBINARY_BYTES, (boolean)true));
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }
        if (contents instanceof SQLXML && expectedType.isAssignableFrom(byte[].class)) {
            try {
                return expectedType.cast(ObjectConverterUtil.convertToByteArray((InputStream)((SQLXML)contents).getBinaryStream(), (int)DataTypeManager.MAX_VARBINARY_BYTES, (boolean)true));
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }
        if (contents instanceof BigInteger && expectedType.isAssignableFrom(String.class)) {
            return expectedType.cast(((BigInteger)contents).toString());
        }
        if (contents instanceof BigDecimal && expectedType.isAssignableFrom(String.class)) {
            return expectedType.cast(((BigDecimal)contents).toString());
        }
        if (contents instanceof BigInteger && expectedType.isAssignableFrom(byte[].class)) {
            return expectedType.cast(((BigInteger)contents).toByteArray());
        }
        if (contents instanceof BigDecimal && expectedType.isAssignableFrom(byte[].class)) {
            return expectedType.cast(((BigDecimal)contents).toBigInteger().toByteArray());
        }
        throw new IOException("unknown type to write:" + contents.getClass());
    }

    public static Type parseProtobufType(String name) {
        switch (name) {
            case "bool": {
                return Type.BOOL;
            }
            case "bytes": {
                return Type.BYTES;
            }
            case "double": {
                return Type.DOUBLE;
            }
            case "float": {
                return Type.FLOAT;
            }
            case "fixed32": {
                return Type.FIXED32;
            }
            case "fixed64": {
                return Type.FIXED64;
            }
            case "int32": {
                return Type.INT32;
            }
            case "int64": {
                return Type.INT64;
            }
            case "sfixed32": {
                return Type.SFIXED32;
            }
            case "sfixed64": {
                return Type.SFIXED64;
            }
            case "sint32": {
                return Type.SINT32;
            }
            case "sint64": {
                return Type.SINT64;
            }
            case "string": {
                return Type.STRING;
            }
            case "uint32": {
                return Type.UINT32;
            }
            case "uint64": {
                return Type.UINT64;
            }
        }
        throw new TeiidRuntimeException("unrecognised type in metadata :" + name);
    }

    public static Type getCompatibleProtobufType(Class<?> type) {
        if (type.isAssignableFrom(String.class) || type.isAssignableFrom(Character.class)) {
            return Type.STRING;
        }
        if (type.isAssignableFrom(Integer.class) || type.isAssignableFrom(Short.class) || type.isAssignableFrom(Byte.class)) {
            return Type.INT32;
        }
        if (type.isAssignableFrom(Long.class)) {
            return Type.INT64;
        }
        if (type.isAssignableFrom(Boolean.class)) {
            return Type.BOOL;
        }
        if (type.isAssignableFrom(Float.class)) {
            return Type.FLOAT;
        }
        if (type.isAssignableFrom(Double.class)) {
            return Type.DOUBLE;
        }
        return Type.BYTES;
    }

    static {
        protoTypes.put(DataType.ScalarType.STRING, "string");
        protoTypes.put(DataType.ScalarType.BOOL, "boolean");
        protoTypes.put(DataType.ScalarType.FIXED32, "integer");
        protoTypes.put(DataType.ScalarType.SFIXED32, "integer");
        protoTypes.put(DataType.ScalarType.INT32, "integer");
        protoTypes.put(DataType.ScalarType.SINT32, "integer");
        protoTypes.put(DataType.ScalarType.UINT32, "integer");
        protoTypes.put(DataType.ScalarType.FIXED64, "long");
        protoTypes.put(DataType.ScalarType.SFIXED64, "long");
        protoTypes.put(DataType.ScalarType.INT64, "long");
        protoTypes.put(DataType.ScalarType.SINT64, "long");
        protoTypes.put(DataType.ScalarType.UINT64, "long");
        protoTypes.put(DataType.ScalarType.FLOAT, "float");
        protoTypes.put(DataType.ScalarType.DOUBLE, "double");
        protoTypes.put(DataType.ScalarType.BYTES, "varbinary");
        teiidTypes.put("string", DataType.ScalarType.STRING);
        teiidTypes.put("boolean", DataType.ScalarType.BOOL);
        teiidTypes.put("short", DataType.ScalarType.INT32);
        teiidTypes.put("byte", DataType.ScalarType.INT32);
        teiidTypes.put("short", DataType.ScalarType.INT32);
        teiidTypes.put("integer", DataType.ScalarType.INT32);
        teiidTypes.put("long", DataType.ScalarType.INT64);
        teiidTypes.put("float", DataType.ScalarType.FLOAT);
        teiidTypes.put("double", DataType.ScalarType.DOUBLE);
        teiidTypes.put("bigdecimal", DataType.ScalarType.BYTES);
        teiidTypes.put("date", DataType.ScalarType.STRING);
        teiidTypes.put("time", DataType.ScalarType.STRING);
        teiidTypes.put("timestamp", DataType.ScalarType.STRING);
        teiidTypes.put("blob", DataType.ScalarType.BYTES);
        teiidTypes.put("clob", DataType.ScalarType.BYTES);
        teiidTypes.put("xml", DataType.ScalarType.BYTES);
        teiidTypes.put("varbinary", DataType.ScalarType.BYTES);
        teiidTypes.put("object", DataType.ScalarType.BYTES);
        teiidTypes.put("geometry", DataType.ScalarType.BYTES);
    }
}

