/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.infinispan.api;

import java.util.TreeMap;
import org.infinispan.protostream.descriptors.Type;
import org.infinispan.protostream.impl.WireFormat;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.infinispan.api.ProtobufDataManager;
import org.teiid.metadata.Column;

public class TableWireFormat {
    private int readTag;
    private int writeTag;
    private Type type;
    private Column column;
    private TreeMap<Integer, TableWireFormat> nested;
    private String attributeName;

    public String getAttributeName() {
        return this.attributeName;
    }

    public String getColumnName() {
        int idx = this.attributeName.lastIndexOf(47);
        if (idx != -1) {
            return this.attributeName.substring(idx + 1);
        }
        return this.attributeName;
    }

    public int getReadTag() {
        return this.readTag;
    }

    public int getWriteTag() {
        return this.writeTag;
    }

    public Type getProtobufType() {
        return this.type;
    }

    public boolean isArrayType() {
        return this.column.getJavaType().getComponentType() != null;
    }

    public TableWireFormat(String name, int tag, Column column) {
        this.writeTag = tag;
        Class columnType = column.getJavaType();
        Type protobufType = this.buildProbufType(column.getNativeType(), columnType);
        this.readTag = WireFormat.makeTag((int)tag, (int)protobufType.getWireType());
        this.type = protobufType;
        this.column = column;
        this.attributeName = name;
    }

    public TableWireFormat(String name, int parentTag) {
        this.writeTag = parentTag;
        this.readTag = TableWireFormat.buildNestedTag(parentTag);
        this.attributeName = name;
    }

    public static int buildNestedTag(int tag) {
        return WireFormat.makeTag((int)tag, (int)2);
    }

    private Type buildProbufType(String nativeType, Class<?> columnType) {
        Type hotrodType = columnType.isArray() ? this.getProtobufType(nativeType, columnType.getComponentType()) : this.getProtobufType(nativeType, columnType);
        return hotrodType;
    }

    private Type getProtobufType(String nativeType, Class<?> columnType) {
        Type hotrodType;
        if (nativeType != null) {
            try {
                hotrodType = ProtobufDataManager.parseProtobufType(nativeType);
            }
            catch (TeiidRuntimeException e) {
                hotrodType = ProtobufDataManager.getCompatibleProtobufType(columnType);
            }
        } else {
            hotrodType = ProtobufDataManager.getCompatibleProtobufType(columnType);
        }
        return hotrodType;
    }

    public boolean isNested() {
        return this.nested != null && !this.nested.isEmpty();
    }

    public void addNested(TableWireFormat childFormat) {
        if (this.nested == null) {
            this.nested = new TreeMap();
        }
        this.nested.put(childFormat.getReadTag(), childFormat);
    }

    public TreeMap<Integer, TableWireFormat> getNestedWireMap() {
        return this.nested;
    }

    public Class<?> expectedType() {
        return this.column.getJavaType();
    }

    public String toString() {
        return "TableWireFormat [expectedTag=" + this.readTag + ", attributeName=" + this.attributeName + ", nested=" + this.nested + "]";
    }
}

