/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.simpledb.api;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLXML;
import java.util.List;
import org.teiid.core.TeiidException;
import org.teiid.core.types.BlobImpl;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.types.TransformationException;
import org.teiid.core.types.XMLType;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.translator.TranslatorException;

public class SimpleDBDataTypeManager {
    public static Object convertToSimpleDBType(Object value, Class<?> type) throws TranslatorException {
        if (value == null) {
            return null;
        }
        if (type.isArray()) {
            int length = Array.getLength(value);
            String[] arrayValue = new String[length];
            for (int i = 0; i < length; ++i) {
                arrayValue[i] = SimpleDBDataTypeManager.convertToSimpleDBType(Array.get(value, i));
            }
            return arrayValue;
        }
        return SimpleDBDataTypeManager.convertToSimpleDBType(value);
    }

    private static String convertToSimpleDBType(Object value) throws TranslatorException {
        try {
            if (value instanceof Blob) {
                return new String(ObjectConverterUtil.convertToByteArray((Object)value), "UTF-8");
            }
            return (String)DataTypeManager.transformValue((Object)value, String.class);
        }
        catch (TransformationException e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (TeiidException e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (IOException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    public static Object convertFromSimpleDBType(List<String> origialValue, Class<?> expectedType) throws TranslatorException {
        if (origialValue == null) {
            return null;
        }
        if (expectedType.isArray()) {
            if (expectedType.getComponentType().isAssignableFrom(String.class)) {
                return origialValue.toArray(new String[origialValue.size()]);
            }
            Object array = Array.newInstance(expectedType, origialValue.size());
            for (int i = 0; i < origialValue.size(); ++i) {
                Object arrayItem = SimpleDBDataTypeManager.convertFromSimpleDBType(origialValue.get(i), expectedType.getComponentType());
                Array.set(array, i, arrayItem);
            }
            return array;
        }
        String value = origialValue.get(0);
        return SimpleDBDataTypeManager.convertFromSimpleDBType(value, expectedType);
    }

    private static Object convertFromSimpleDBType(final String value, Class<?> expectedType) throws TranslatorException {
        if (expectedType.isAssignableFrom(String.class)) {
            return value;
        }
        if (expectedType.isAssignableFrom(Blob.class)) {
            return new BlobType((Blob)new BlobImpl(new InputStreamFactory(){

                public InputStream getInputStream() throws IOException {
                    return new ByteArrayInputStream(value.getBytes());
                }
            }));
        }
        if (expectedType.isAssignableFrom(Clob.class)) {
            return new ClobType((Clob)new ClobImpl(value));
        }
        if (expectedType.isAssignableFrom(SQLXML.class)) {
            return new XMLType((SQLXML)new SQLXMLImpl(value.getBytes()));
        }
        if (DataTypeManager.isTransformable(String.class, expectedType)) {
            try {
                return DataTypeManager.transformValue((Object)value, expectedType);
            }
            catch (TransformationException e) {
                throw new TranslatorException((Throwable)e);
            }
        }
        throw new TranslatorException("Failed to convert " + value + " to target type of " + expectedType);
    }
}

