/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss.rest;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jboss.resteasy.spi.InternalServerErrorException;
import org.jboss.resteasy.spi.NotFoundException;
import org.jboss.resteasy.spi.UnauthorizedException;

@Provider
public class TeiidRSExceptionHandler
implements ExceptionMapper<Exception> {
    @Context
    protected HttpHeaders httpHeaders;

    public Response toResponse(Exception e) {
        ResponseError error = new ResponseError();
        String code = "ERROR";
        if (e instanceof UnauthorizedException) {
            code = "401";
        } else if (e instanceof NotFoundException) {
            code = "404";
        } else if (e instanceof InternalServerErrorException) {
            code = "500";
        }
        error.setCode(code);
        error.setMessage(e.getMessage());
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        error.setDetails(sw.toString());
        String type = "application/xml";
        List acceptTypes = this.httpHeaders.getAcceptableMediaTypes();
        if (acceptTypes != null) {
            for (MediaType acceptType : acceptTypes) {
                if (!this.isApplicationJsonWithParametersIgnored(acceptType)) continue;
                type = "application/json";
                break;
            }
        }
        return Response.serverError().entity((Object)error).type(type).build();
    }

    private boolean isApplicationJsonWithParametersIgnored(MediaType acceptType) {
        return acceptType.getType().equals(MediaType.APPLICATION_JSON_TYPE.getType()) && acceptType.getSubtype().equals(MediaType.APPLICATION_JSON_TYPE.getSubtype());
    }

    @XmlRootElement(name="error")
    @XmlType(propOrder={"code", "message", "details"})
    public static class ResponseError {
        private String code;
        private String message;
        private String details;

        @XmlElement(name="code")
        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        @XmlElement(name="message")
        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @XmlElement(name="details")
        public String getDetails() {
            return this.details;
        }

        public void setDetails(String details) {
            this.details = details;
        }
    }
}

