/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.adminapi;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestAddress;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.teiid.adminapi.Admin;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.AdminPlugin;
import org.teiid.adminapi.AdminProcessingException;
import org.teiid.adminapi.CacheStatistics;
import org.teiid.adminapi.DomainAware;
import org.teiid.adminapi.PropertyDefinition;
import org.teiid.adminapi.Request;
import org.teiid.adminapi.Session;
import org.teiid.adminapi.Transaction;
import org.teiid.adminapi.Translator;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.WorkerPoolStatistics;
import org.teiid.adminapi.impl.AdminObjectImpl;
import org.teiid.adminapi.impl.MetadataMapper;
import org.teiid.adminapi.impl.PropertyDefinitionMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBMetadataMapper;
import org.teiid.adminapi.impl.VDBTranslatorMetaData;
import org.teiid.core.BundleUtil;
import org.teiid.core.util.ObjectConverterUtil;

public class AdminFactory {
    private static final Logger LOGGER = Logger.getLogger(AdminFactory.class.getName());
    private static AdminFactory INSTANCE = new AdminFactory();

    public static AdminFactory getInstance() {
        return INSTANCE;
    }

    public Admin createAdmin(String host, int port, String userName, char[] password) throws AdminException {
        if (host == null) {
            host = "localhost";
        }
        if (port < 0) {
            port = 9999;
        }
        try {
            AuthenticationCallbackHandler cbh = new AuthenticationCallbackHandler(userName, password);
            ModelControllerClient newClient = ModelControllerClient.Factory.create((String)host, (int)port, (CallbackHandler)cbh);
            List nodeTypes = Util.getNodeTypes((ModelControllerClient)newClient, (OperationRequestAddress)new DefaultOperationRequestAddress());
            if (!nodeTypes.isEmpty()) {
                boolean domainMode = nodeTypes.contains("server-group");
                LOGGER.info("Connected to " + (domainMode ? "domain controller at " : "standalone controller at ") + host + ":" + port);
                return new AdminImpl(newClient);
            }
            LOGGER.info(AdminPlugin.Util.gs((BundleUtil.Event)AdminPlugin.Event.TEIID70051, new Object[]{host, port}));
        }
        catch (UnknownHostException e) {
            throw new AdminProcessingException((BundleUtil.Event)AdminPlugin.Event.TEIID70000, AdminPlugin.Util.gs((BundleUtil.Event)AdminPlugin.Event.TEIID70000, new Object[]{host, e.getLocalizedMessage()}));
        }
        return null;
    }

    private class AdminImpl
    implements Admin {
        private static final String CLASS_NAME = "class-name";
        private static final String JAVA_CONTEXT = "java:/";
        private ModelControllerClient connection;
        private boolean domainMode = false;

        public AdminImpl(ModelControllerClient connection) {
            this.connection = connection;
            List nodeTypes = Util.getNodeTypes((ModelControllerClient)connection, (OperationRequestAddress)new DefaultOperationRequestAddress());
            if (!nodeTypes.isEmpty()) {
                this.domainMode = nodeTypes.contains("server-group");
            }
        }

        @Override
        public void clearCache(String cacheType) throws AdminException {
            ModelNode request = this.buildRequest("teiid", "clear-cache", "cache-type", cacheType);
            this.execute(request);
        }

        @Override
        public void clearCache(String cacheType, String vdbName, int vdbVersion) throws AdminException {
            ModelNode request = this.buildRequest("teiid", "clear-cache", "cache-type", cacheType, "vdb-name", vdbName, "vdb-version", String.valueOf(vdbVersion));
            this.execute(request);
        }

        @Override
        public void close() {
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.connection = null;
                this.domainMode = false;
            }
        }

        private void createConnectionFactory(String deploymentName, String rarName, Properties properties) throws AdminException {
            ModelNode request;
            this.addResourceAdapter(deploymentName, rarName);
            DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
            try {
                builder.addNode("subsystem", "resource-adapters");
                builder.addNode("resource-adapter", deploymentName);
                builder.addNode("connection-definitions", deploymentName);
                builder.setOperationName("add");
                builder.addProperty("jndi-name", this.addJavaContext(deploymentName));
                builder.addProperty("enabled", "true");
                if (properties.getProperty(CLASS_NAME) != null) {
                    builder.addProperty(CLASS_NAME, properties.getProperty(CLASS_NAME));
                }
                request = builder.buildRequest();
            }
            catch (OperationFormatException e) {
                throw new IllegalStateException("Failed to build operation", e);
            }
            this.execute(request);
            Enumeration<?> keys = properties.propertyNames();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if (key.equals(CLASS_NAME)) continue;
                this.addConfigProperty(deploymentName, key, properties.getProperty(key));
            }
            this.activateConnectionFactory(deploymentName);
        }

        private void addConfigProperty(String deploymentName, String key, String value) throws AdminProcessingException {
            ModelNode request;
            DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
            try {
                builder.addNode("subsystem", "resource-adapters");
                builder.addNode("resource-adapter", deploymentName);
                builder.addNode("connection-definitions", deploymentName);
                builder.addNode("config-properties", key);
                builder.setOperationName("add");
                builder.addProperty("value", value);
                request = builder.buildRequest();
            }
            catch (OperationFormatException e) {
                throw new IllegalStateException("Failed to build operation", e);
            }
            this.execute(request);
        }

        private void activateConnectionFactory(String deploymentName) throws AdminProcessingException {
            ModelNode request;
            DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
            try {
                builder.addNode("subsystem", "resource-adapters");
                builder.addNode("resource-adapter", deploymentName);
                builder.setOperationName("activate");
                request = builder.buildRequest();
            }
            catch (OperationFormatException e) {
                throw new IllegalStateException("Failed to build operation", e);
            }
            this.execute(request);
        }

        private void addResourceAdapter(String deploymentName, String rarName) throws AdminProcessingException {
            ModelNode request;
            DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
            try {
                builder.addNode("subsystem", "resource-adapters");
                builder.addNode("resource-adapter", deploymentName);
                builder.setOperationName("add");
                request = builder.buildRequest();
                request.get("archive").set(rarName);
                request.get("transaction-support").set("NoTransaction");
            }
            catch (OperationFormatException e) {
                throw new IllegalStateException("Failed to build operation", e);
            }
            this.execute(request);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Set<String> getInstalledJDBCDrivers() throws AdminProcessingException {
            HashSet<String> driverList = new HashSet<String>();
            driverList.addAll(this.getChildNodeNames("datasources", "jdbc-driver"));
            if (!this.domainMode) {
                ModelNode request = this.buildRequest("datasources", "installed-drivers-list", new String[0]);
                try {
                    ModelNode outcome = this.connection.execute(request);
                    if (!Util.isSuccess((ModelNode)outcome)) return driverList;
                    List<String> drivers = this.getList(outcome, new AbstractMetadatMapper(){

                        @Override
                        public String unwrap(ModelNode node) {
                            if (node.hasDefined("driver-name")) {
                                return node.get("driver-name").asString();
                            }
                            return null;
                        }
                    });
                    driverList.addAll(drivers);
                    return driverList;
                }
                catch (Exception e) {
                    throw new AdminProcessingException(e.getMessage(), (Throwable)e);
                }
            } else {
                List<String> deployments = this.getChildNodeNames(null, "deployment");
                for (String deployment : deployments) {
                    if (deployment.contains("translator") || !deployment.endsWith(".jar")) continue;
                    driverList.add(deployment);
                }
            }
            return driverList;
        }

        public String getProfileName() throws AdminProcessingException {
            if (!this.domainMode) {
                return null;
            }
            return this.getChildNodeNames(null, "profile").get(0);
        }

        @Override
        public void createDataSource(String deploymentName, String templateName, Properties properties) throws AdminException {
            ModelNode request;
            deploymentName = this.removeJavaContext(deploymentName);
            Collection<String> dsNames = this.getDataSourceNames();
            if (dsNames.contains(deploymentName)) {
                throw new AdminProcessingException((BundleUtil.Event)AdminPlugin.Event.TEIID70003, AdminPlugin.Util.gs((BundleUtil.Event)AdminPlugin.Event.TEIID70003, new Object[]{deploymentName}));
            }
            Set<String> resourceAdapters = this.getAvailableResourceAdapterNames();
            if (resourceAdapters.contains(templateName)) {
                this.createConnectionFactory(deploymentName, templateName, properties);
                return;
            }
            Set<String> drivers = this.getInstalledJDBCDrivers();
            if (!drivers.contains(templateName)) {
                throw new AdminProcessingException((BundleUtil.Event)AdminPlugin.Event.TEIID70004, AdminPlugin.Util.gs((BundleUtil.Event)AdminPlugin.Event.TEIID70004, new Object[]{templateName}));
            }
            DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
            try {
                String profile;
                if (this.domainMode && (profile = this.getProfileName()) != null) {
                    builder.addNode("profile", profile);
                }
                builder.addNode("subsystem", "datasources");
                builder.addNode("data-source", deploymentName);
                builder.setOperationName("add");
                builder.addProperty("jndi-name", this.addJavaContext(deploymentName));
                builder.addProperty("driver-name", templateName);
                builder.addProperty("pool-name", deploymentName);
                builder.addProperty("pool-prefill", "false");
                builder.addProperty("max-pool-size", "20");
                builder.addProperty("min-pool-size", "10");
                if (properties != null) {
                    builder.addProperty("connection-url", properties.getProperty("connection-url"));
                    if (properties.getProperty("user-name") != null) {
                        builder.addProperty("user-name", properties.getProperty("user-name"));
                    }
                    if (properties.getProperty("password") != null) {
                        builder.addProperty("password", properties.getProperty("password"));
                    }
                    if (properties.getProperty("check-valid-connection-sql") != null) {
                        builder.addProperty("check-valid-connection-sql", properties.getProperty("check-valid-connection-sql"));
                    }
                } else {
                    throw new AdminProcessingException((BundleUtil.Event)AdminPlugin.Event.TEIID70005, AdminPlugin.Util.gs((BundleUtil.Event)AdminPlugin.Event.TEIID70005, new Object[0]));
                }
                request = builder.buildRequest();
            }
            catch (OperationFormatException e) {
                throw new IllegalStateException("Failed to build operation", e);
            }
            this.execute(request);
            builder = new DefaultOperationRequestBuilder();
            try {
                builder.addNode("subsystem", "datasources");
                builder.addNode("data-source", deploymentName);
                builder.setOperationName("enable");
                request = builder.buildRequest();
            }
            catch (OperationFormatException e) {
                throw new IllegalStateException("Failed to build operation", e);
            }
            this.execute(request);
        }

        private void execute(ModelNode request) throws AdminProcessingException {
            try {
                ModelNode outcome = this.connection.execute(request);
                if (!Util.isSuccess((ModelNode)outcome)) {
                    throw new AdminProcessingException((BundleUtil.Event)AdminPlugin.Event.TEIID70006, Util.getFailureDescription((ModelNode)outcome));
                }
            }
            catch (IOException e) {
                throw new AdminProcessingException(AdminPlugin.Event.TEIID70007, e, e.getMessage());
            }
        }

        @Override
        public void deleteDataSource(String deployedName) throws AdminException {
            Map<String, String> raDSMap;
            String rarName;
            deployedName = this.removeJavaContext(deployedName);
            Collection<String> dsNames = this.getDataSourceNames();
            if (!dsNames.contains(deployedName)) {
                throw new AdminProcessingException((BundleUtil.Event)AdminPlugin.Event.TEIID70008, AdminPlugin.Util.gs((BundleUtil.Event)AdminPlugin.Event.TEIID70008, new Object[]{deployedName}));
            }
            boolean deleted = this.deleteDS(deployedName, false, "datasources", "data-source");
            if (!deleted) {
                deleted = this.deleteDS(deployedName, false, "datasources", "xa-data-source");
            }
            if (!deleted && (rarName = (raDSMap = this.getResourceAdapterDataSources()).get(deployedName)) != null) {
                deleted = this.deleteDS(rarName, true, "resource-adapters", "resource-adapter", deployedName);
            }
        }

        private String removeJavaContext(String deployedName) {
            if (deployedName.startsWith(JAVA_CONTEXT)) {
                deployedName = deployedName.substring(6);
            }
            return deployedName;
        }

        private String addJavaContext(String deployedName) {
            if (!deployedName.startsWith(JAVA_CONTEXT)) {
                deployedName = JAVA_CONTEXT + deployedName;
            }
            return deployedName;
        }

        private boolean deleteDS(String deployedName, boolean connFactory, String ... subsystem) throws AdminProcessingException {
            ModelNode request;
            DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
            try {
                String profile;
                if (this.domainMode && (profile = this.getProfileName()) != null) {
                    builder.addNode("profile", profile);
                }
                builder.addNode("subsystem", subsystem[0]);
                builder.addNode(subsystem[1], deployedName);
                if (connFactory) {
                    builder.addNode("connection-definitions", subsystem[2]);
                }
                builder.setOperationName("remove");
                request = builder.buildRequest();
            }
            catch (OperationFormatException e) {
                throw new IllegalStateException("Failed to build operation", e);
            }
            try {
                ModelNode outcome = this.connection.execute(request);
                return Util.isSuccess((ModelNode)outcome);
            }
            catch (IOException e) {
                throw new AdminProcessingException(AdminPlugin.Event.TEIID70009, e, e.getMessage());
            }
        }

        @Override
        public void undeploy(String deployedName) throws AdminException {
            ModelNode request;
            try {
                request = this.buildUndeployRequest(deployedName);
            }
            catch (OperationFormatException e) {
                throw new AdminProcessingException(AdminPlugin.Event.TEIID70010, e, e.getMessage());
            }
            this.execute(request);
        }

        public ModelNode buildUndeployRequest(String name) throws OperationFormatException {
            DefaultOperationRequestBuilder builder;
            ModelNode composite = new ModelNode();
            composite.get("operation").set("composite");
            composite.get("address").setEmptyList();
            ModelNode steps = composite.get("steps");
            if (this.domainMode) {
                ModelNode groupStep;
                List serverGroups = Util.getServerGroups((ModelControllerClient)this.connection);
                for (String group : serverGroups) {
                    groupStep = Util.configureDeploymentOperation((String)"undeploy", (String)name, (String)group);
                    steps.add(groupStep);
                }
                for (String group : serverGroups) {
                    groupStep = Util.configureDeploymentOperation((String)"remove", (String)name, (String)group);
                    steps.add(groupStep);
                }
            } else if (Util.isDeployedAndEnabledInStandalone((String)name, (ModelControllerClient)this.connection)) {
                builder = new DefaultOperationRequestBuilder();
                builder.setOperationName("undeploy");
                builder.addNode("deployment", name);
                steps.add(builder.buildRequest());
            }
            builder = new DefaultOperationRequestBuilder();
            builder.setOperationName("remove");
            builder.addNode("deployment", name);
            steps.add(builder.buildRequest());
            return composite;
        }

        @Override
        public void deploy(String deployName, InputStream vdb) throws AdminException {
            ModelNode request = this.buildDeployVDBRequest(deployName, vdb);
            this.execute(request);
        }

        private ModelNode buildDeployVDBRequest(String fileName, InputStream vdb) throws AdminProcessingException {
            try {
                if (Util.isDeploymentInRepository((String)fileName, (ModelControllerClient)this.connection)) {
                    DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
                    builder = new DefaultOperationRequestBuilder();
                    builder.setOperationName("full-replace-deployment");
                    builder.addProperty("name", fileName);
                    byte[] bytes = ObjectConverterUtil.convertToByteArray((InputStream)vdb);
                    builder.getModelNode().get("content").get(0).get("bytes").set(bytes);
                    return builder.buildRequest();
                }
                ModelNode composite = new ModelNode();
                composite.get("operation").set("composite");
                composite.get("address").setEmptyList();
                ModelNode steps = composite.get("steps");
                DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
                builder.setOperationName("add");
                builder.addNode("deployment", fileName);
                byte[] bytes = ObjectConverterUtil.convertToByteArray((InputStream)vdb);
                builder.getModelNode().get("content").get(0).get("bytes").set(bytes);
                steps.add(builder.buildRequest());
                if (this.domainMode) {
                    List serverGroups = Util.getServerGroups((ModelControllerClient)this.connection);
                    for (String serverGroup : serverGroups) {
                        steps.add(Util.configureDeploymentOperation((String)"add", (String)fileName, (String)serverGroup));
                    }
                    for (String serverGroup : serverGroups) {
                        steps.add(Util.configureDeploymentOperation((String)"deploy", (String)fileName, (String)serverGroup));
                    }
                } else {
                    builder = new DefaultOperationRequestBuilder();
                    builder.setOperationName("deploy");
                    builder.addNode("deployment", fileName);
                    steps.add(builder.buildRequest());
                }
                return composite;
            }
            catch (OperationFormatException e) {
                throw new AdminProcessingException(AdminPlugin.Event.TEIID70011, e, e.getMessage());
            }
            catch (IOException e) {
                throw new AdminProcessingException(AdminPlugin.Event.TEIID70011, e, e.getMessage());
            }
        }

        @Override
        public Collection<? extends CacheStatistics> getCacheStats(String cacheType) throws AdminException {
            ModelNode request = this.buildRequest("teiid", "cache-statistics", "cache-type", cacheType);
            try {
                ModelNode outcome = this.connection.execute(request);
                if (Util.isSuccess((ModelNode)outcome)) {
                    return this.getDomainAwareList(outcome, VDBMetadataMapper.CacheStatisticsMetadataMapper.INSTANCE);
                }
            }
            catch (Exception e) {
                throw new AdminProcessingException(AdminPlugin.Event.TEIID70013, e, e.getMessage());
            }
            return null;
        }

        @Override
        public Collection<String> getCacheTypes() throws AdminException {
            ModelNode request = this.buildRequest("teiid", "cache-types", new String[0]);
            return new HashSet<String>(this.executeList(request));
        }

        private Collection<String> executeList(ModelNode request) throws AdminProcessingException {
            try {
                ModelNode outcome = this.connection.execute(request);
                if (Util.isSuccess((ModelNode)outcome)) {
                    return Util.getList((ModelNode)outcome);
                }
            }
            catch (Exception e) {
                throw new AdminProcessingException(AdminPlugin.Event.TEIID70014, e, e.getMessage());
            }
            return Collections.emptyList();
        }

        private List<String> getChildNodeNames(String subsystem, String childNode) throws AdminProcessingException {
            ModelNode request = this.buildRequest(subsystem, "read-children-names", "child-type", childNode);
            try {
                ModelNode outcome = this.connection.execute(request);
                if (Util.isSuccess((ModelNode)outcome)) {
                    return Util.getList((ModelNode)outcome);
                }
            }
            catch (IOException e) {
                throw new AdminProcessingException(AdminPlugin.Event.TEIID70015, e, e.getMessage());
            }
            return Collections.emptyList();
        }

        @Override
        public Collection<String> getDataSourceNames() throws AdminException {
            HashSet<String> datasourceNames = new HashSet<String>();
            datasourceNames.addAll(this.getChildNodeNames("datasources", "data-source"));
            datasourceNames.addAll(this.getChildNodeNames("datasources", "xa-data-source"));
            datasourceNames.addAll(this.getResourceAdapterDataSources().keySet());
            HashSet<String> dsNames = new HashSet<String>();
            for (String s : datasourceNames) {
                if (s.startsWith(JAVA_CONTEXT)) {
                    dsNames.add(s.substring(6));
                    continue;
                }
                dsNames.add(s);
            }
            return dsNames;
        }

        private Map<String, String> getResourceAdapterDataSources() throws AdminException {
            HashMap<String, String> datasourceNames = new HashMap<String, String>();
            Set<String> resourceAdapters = this.getDeployedResourceAdapterNames();
            for (String resource : resourceAdapters) {
                DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
                try {
                    ModelNode result;
                    builder.addNode("subsystem", "resource-adapters");
                    builder.addNode("resource-adapter", resource);
                    builder.setOperationName("read-resource");
                    ModelNode request = builder.buildRequest();
                    ModelNode outcome = this.connection.execute(request);
                    if (!Util.isSuccess((ModelNode)outcome) || !outcome.hasDefined("result") || !(result = outcome.get("result")).hasDefined("connection-definitions")) continue;
                    List connDefs = result.get("connection-definitions").asList();
                    for (ModelNode conn : connDefs) {
                        Iterator it = conn.keys().iterator();
                        if (!it.hasNext()) continue;
                        datasourceNames.put((String)it.next(), resource);
                    }
                }
                catch (OperationFormatException e) {
                    throw new AdminProcessingException(AdminPlugin.Event.TEIID70016, e, AdminPlugin.Util.gs((BundleUtil.Event)AdminPlugin.Event.TEIID70016, new Object[0]));
                }
                catch (IOException e) {
                    throw new AdminProcessingException(AdminPlugin.Event.TEIID70017, e, AdminPlugin.Util.gs((BundleUtil.Event)AdminPlugin.Event.TEIID70017, new Object[0]));
                }
            }
            return datasourceNames;
        }

        private Set<String> getDeployedResourceAdapterNames() throws AdminException {
            HashSet<String> templates = new HashSet<String>();
            templates.addAll(this.getChildNodeNames("resource-adapters", "resource-adapter"));
            return templates;
        }

        private Set<String> getAvailableResourceAdapterNames() throws AdminException {
            List<String> deployments = this.getChildNodeNames(null, "deployment");
            HashSet<String> templates = new HashSet<String>();
            for (String deployment : deployments) {
                if (!deployment.endsWith(".rar")) continue;
                templates.add(deployment);
            }
            return templates;
        }

        @Override
        public Set<String> getDataSourceTemplateNames() throws AdminException {
            HashSet<String> templates = new HashSet<String>();
            templates.addAll(this.getInstalledJDBCDrivers());
            templates.addAll(this.getAvailableResourceAdapterNames());
            return templates;
        }

        @Override
        public Collection<? extends WorkerPoolStatistics> getWorkerPoolStats() throws AdminException {
            ModelNode request = this.buildRequest("teiid", "workerpool-statistics", new String[0]);
            if (request != null) {
                try {
                    ModelNode outcome = this.connection.execute(request);
                    if (Util.isSuccess((ModelNode)outcome)) {
                        return this.getDomainAwareList(outcome, VDBMetadataMapper.WorkerPoolStatisticsMetadataMapper.INSTANCE);
                    }
                }
                catch (Exception e) {
                    throw new AdminProcessingException(AdminPlugin.Event.TEIID70020, e, e.getMessage());
                }
            }
            return null;
        }

        @Override
        public void cancelRequest(String sessionId, long executionId) throws AdminException {
            ModelNode request = this.buildRequest("teiid", "terminate-session", "session", sessionId, "execution-id", String.valueOf(executionId));
            if (request == null) {
                return;
            }
            try {
                ModelNode outcome = this.connection.execute(request);
                if (!Util.isSuccess((ModelNode)outcome)) {
                    throw new AdminProcessingException((BundleUtil.Event)AdminPlugin.Event.TEIID70021, Util.getFailureDescription((ModelNode)outcome));
                }
            }
            catch (Exception e) {
                throw new AdminProcessingException(AdminPlugin.Event.TEIID70022, e, e.getMessage());
            }
        }

        @Override
        public Collection<? extends Request> getRequests() throws AdminException {
            ModelNode request = this.buildRequest("teiid", "list-requests", new String[0]);
            if (request != null) {
                try {
                    ModelNode outcome = this.connection.execute(request);
                    if (Util.isSuccess((ModelNode)outcome)) {
                        return this.getDomainAwareList(outcome, VDBMetadataMapper.RequestMetadataMapper.INSTANCE);
                    }
                }
                catch (Exception e) {
                    throw new AdminProcessingException(AdminPlugin.Event.TEIID70023, e, e.getMessage());
                }
            }
            return Collections.emptyList();
        }

        @Override
        public Collection<? extends Request> getRequestsForSession(String sessionId) throws AdminException {
            ModelNode request = this.buildRequest("teiid", "list-requests-per-session", "session", sessionId);
            if (request != null) {
                try {
                    ModelNode outcome = this.connection.execute(request);
                    if (Util.isSuccess((ModelNode)outcome)) {
                        return this.getDomainAwareList(outcome, VDBMetadataMapper.RequestMetadataMapper.INSTANCE);
                    }
                }
                catch (Exception e) {
                    throw new AdminProcessingException(AdminPlugin.Event.TEIID70024, e, e.getMessage());
                }
            }
            return Collections.emptyList();
        }

        @Override
        public Collection<? extends Session> getSessions() throws AdminException {
            ModelNode request = this.buildRequest("teiid", "list-sessions", new String[0]);
            if (request != null) {
                try {
                    ModelNode outcome = this.connection.execute(request);
                    if (Util.isSuccess((ModelNode)outcome)) {
                        return this.getDomainAwareList(outcome, VDBMetadataMapper.SessionMetadataMapper.INSTANCE);
                    }
                }
                catch (Exception e) {
                    throw new AdminProcessingException(AdminPlugin.Event.TEIID70025, e, e.getMessage());
                }
            }
            return Collections.emptyList();
        }

        public Collection<PropertyDefinition> getTemplatePropertyDefinitions(String templateName) throws AdminException {
            ModelNode result;
            block7: {
                ModelNode request = null;
                result = null;
                try {
                    Set<String> resourceAdapters = this.getAvailableResourceAdapterNames();
                    if (resourceAdapters.contains(templateName)) {
                        String profile;
                        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
                        if (this.domainMode && (profile = this.getProfileName()) != null) {
                            builder.addNode("profile", profile);
                        }
                        builder.addNode("subsystem", "teiid");
                        builder.setOperationName("read-rar-description");
                        builder.addProperty("rar-name", templateName);
                        request = builder.buildRequest();
                        try {
                            ModelNode outcome = this.connection.execute(request);
                            if (!Util.isSuccess((ModelNode)outcome)) {
                                throw new AdminProcessingException((BundleUtil.Event)AdminPlugin.Event.TEIID70026, Util.getFailureDescription((ModelNode)outcome));
                            }
                            result = outcome.get("result");
                            break block7;
                        }
                        catch (IOException e) {
                            throw new AdminProcessingException(AdminPlugin.Event.TEIID70027, e, e.getMessage());
                        }
                    }
                    result = new ModelNode();
                    result.add(this.buildProperty("connection-url", "Connection URL", ModelType.STRING, "connection url to database", true));
                    result.add(this.buildProperty("user-name", "User Name", ModelType.STRING, "user name", false));
                    result.add(this.buildProperty("password", "Password", ModelType.STRING, "password", false));
                    result.add(this.buildProperty("check-valid-connection-sql", "Connection Validate SQL", ModelType.STRING, "SQL to be used to validate the connection", false));
                }
                catch (OperationFormatException e) {
                    throw new IllegalStateException("Failed to build operation", e);
                }
            }
            return this.buildPropertyDefinitions(result.asList());
        }

        private ModelNode buildProperty(String name, String displayName, ModelType modelType, String description, boolean required) {
            ModelNode node = new ModelNode();
            node.get(new String[]{name, "type"}).set(modelType);
            node.get(new String[]{name, "description"}).set(description);
            node.get(new String[]{name, "required"}).set(required);
            node.get(new String[]{name, "display"}).set(displayName);
            return node;
        }

        private ArrayList<PropertyDefinition> buildPropertyDefinitions(List<ModelNode> propsNodes) {
            ArrayList<PropertyDefinition> propDefinitions = new ArrayList<PropertyDefinition>();
            for (ModelNode node : propsNodes) {
                String access;
                PropertyDefinitionMetadata def = new PropertyDefinitionMetadata();
                Set keys = node.keys();
                String name = (String)keys.iterator().next();
                def.setName(name);
                node = node.get(name);
                if (node.hasDefined("display")) {
                    def.setDisplayName(node.get("display").asString());
                }
                if (node.hasDefined("description")) {
                    def.setDescription(node.get("description").asString());
                }
                if (node.hasDefined("allowed")) {
                    List allowed = node.get("allowed").asList();
                    ArrayList<String> list = new ArrayList<String>();
                    for (ModelNode m : allowed) {
                        list.add(m.asString());
                    }
                    def.setAllowedValues(list);
                }
                if (node.hasDefined("required")) {
                    def.setRequired(node.get("required").asBoolean());
                }
                if (node.hasDefined("read-only")) {
                    access = node.get("read-only").asString();
                    def.setModifiable(Boolean.parseBoolean(access));
                }
                if (node.hasDefined("advanced")) {
                    access = node.get("advanced").asString();
                    def.setAdvanced(Boolean.parseBoolean(access));
                }
                if (node.hasDefined("masked")) {
                    access = node.get("masked").asString();
                    def.setAdvanced(Boolean.parseBoolean(access));
                }
                if (node.hasDefined("restart-required")) {
                    def.setRequiresRestart(PropertyDefinition.RestartType.NONE);
                }
                String type = node.get("type").asString();
                if (ModelType.STRING.name().equals(type)) {
                    def.setPropertyTypeClassName(String.class.getName());
                } else if (ModelType.INT.name().equals(type)) {
                    def.setPropertyTypeClassName(Integer.class.getName());
                } else if (ModelType.LONG.name().equals(type)) {
                    def.setPropertyTypeClassName(Long.class.getName());
                } else if (ModelType.BOOLEAN.name().equals(type)) {
                    def.setPropertyTypeClassName(Boolean.class.getName());
                } else if (ModelType.BIG_INTEGER.name().equals(type)) {
                    def.setPropertyTypeClassName(BigInteger.class.getName());
                } else if (ModelType.BIG_DECIMAL.name().equals(type)) {
                    def.setPropertyTypeClassName(BigDecimal.class.getName());
                }
                if (node.hasDefined("default")) {
                    if (ModelType.STRING.name().equals(type)) {
                        def.setDefaultValue((Serializable)((Object)node.get("default").asString()));
                    } else if (ModelType.INT.name().equals(type)) {
                        def.setDefaultValue(Integer.valueOf(node.get("default").asInt()));
                    } else if (ModelType.LONG.name().equals(type)) {
                        def.setDefaultValue(Long.valueOf(node.get("default").asLong()));
                    } else if (ModelType.BOOLEAN.name().equals(type)) {
                        def.setDefaultValue(Boolean.valueOf(node.get("default").asBoolean()));
                    } else if (ModelType.BIG_INTEGER.name().equals(type)) {
                        def.setDefaultValue(node.get("default").asBigInteger());
                    } else if (ModelType.BIG_DECIMAL.name().equals(type)) {
                        def.setDefaultValue(node.get("default").asBigDecimal());
                    }
                }
                propDefinitions.add(def);
            }
            return propDefinitions;
        }

        @Override
        public Collection<? extends Transaction> getTransactions() throws AdminException {
            ModelNode request = this.buildRequest("teiid", "list-transactions", new String[0]);
            if (request != null) {
                try {
                    ModelNode outcome = this.connection.execute(request);
                    if (Util.isSuccess((ModelNode)outcome)) {
                        return this.getDomainAwareList(outcome, VDBMetadataMapper.TransactionMetadataMapper.INSTANCE);
                    }
                }
                catch (Exception e) {
                    throw new AdminProcessingException(AdminPlugin.Event.TEIID70028, e, e.getMessage());
                }
            }
            return Collections.emptyList();
        }

        @Override
        public void terminateSession(String sessionId) throws AdminException {
            ModelNode request = this.buildRequest("teiid", "terminate-session", "session", sessionId);
            if (request == null) {
                return;
            }
            try {
                ModelNode outcome = this.connection.execute(request);
                if (!Util.isSuccess((ModelNode)outcome)) {
                    throw new AdminProcessingException((BundleUtil.Event)AdminPlugin.Event.TEIID70029, Util.getFailureDescription((ModelNode)outcome));
                }
            }
            catch (Exception e) {
                throw new AdminProcessingException(AdminPlugin.Event.TEIID70030, e, e.getMessage());
            }
        }

        @Override
        public void terminateTransaction(String transactionId) throws AdminException {
            ModelNode request = this.buildRequest("teiid", "terminate-transaction", "xid", transactionId);
            if (request == null) {
                return;
            }
            try {
                ModelNode outcome = this.connection.execute(request);
                if (!Util.isSuccess((ModelNode)outcome)) {
                    throw new AdminProcessingException((BundleUtil.Event)AdminPlugin.Event.TEIID70031, Util.getFailureDescription((ModelNode)outcome));
                }
            }
            catch (Exception e) {
                throw new AdminProcessingException(AdminPlugin.Event.TEIID70032, e, e.getMessage());
            }
        }

        @Override
        public Translator getTranslator(String deployedName) throws AdminException {
            block5: {
                ModelNode request = this.buildRequest("teiid", "get-translator", "translator-name", deployedName);
                if (request == null) {
                    return null;
                }
                try {
                    ModelNode outcome = this.connection.execute(request);
                    if (!Util.isSuccess((ModelNode)outcome) || !outcome.hasDefined("result")) break block5;
                    if (this.domainMode) {
                        List<VDBTranslatorMetaData> list = this.getDomainAwareList(outcome, VDBMetadataMapper.VDBTranslatorMetaDataMapper.INSTANCE);
                        if (list != null && !list.isEmpty()) {
                            return list.get(0);
                        }
                        break block5;
                    }
                    ModelNode result = outcome.get("result");
                    return VDBMetadataMapper.VDBTranslatorMetaDataMapper.INSTANCE.unwrap(result);
                }
                catch (Exception e) {
                    throw new AdminProcessingException(AdminPlugin.Event.TEIID70033, e, e.getMessage());
                }
            }
            return null;
        }

        @Override
        public Collection<? extends Translator> getTranslators() throws AdminException {
            ModelNode request = this.buildRequest("teiid", "list-translators", new String[0]);
            try {
                ModelNode outcome = this.connection.execute(request);
                if (Util.isSuccess((ModelNode)outcome)) {
                    return this.getDomainAwareList(outcome, VDBMetadataMapper.VDBTranslatorMetaDataMapper.INSTANCE);
                }
            }
            catch (Exception e) {
                throw new AdminProcessingException(AdminPlugin.Event.TEIID70034, e, e.getMessage());
            }
            return Collections.emptyList();
        }

        private ModelNode buildRequest(String subsystem, String operationName, String ... params) throws AdminProcessingException {
            ModelNode request;
            DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
            try {
                if (subsystem != null) {
                    String profile;
                    if (this.domainMode && (profile = this.getProfileName()) != null) {
                        builder.addNode("profile", profile);
                    }
                    builder.addNode("subsystem", subsystem);
                }
                builder.setOperationName(operationName);
                request = builder.buildRequest();
                if (params != null && params.length % 2 == 0) {
                    for (int i = 0; i < params.length; i += 2) {
                        builder.addProperty(params[i], params[i + 1]);
                    }
                }
            }
            catch (OperationFormatException e) {
                throw new IllegalStateException("Failed to build operation", e);
            }
            return request;
        }

        private <T> List<T> getDomainAwareList(ModelNode operationResult, MetadataMapper<T> mapper) {
            if (this.domainMode) {
                ArrayList<T> returnList = new ArrayList<T>();
                ModelNode serverGroups = operationResult.get("server-groups");
                Set serverGroupNames = serverGroups.keys();
                for (String serverGroupName : serverGroupNames) {
                    ModelNode serverGroup = serverGroups.get(serverGroupName);
                    Set serverNames = serverGroup.keys();
                    for (String serverName : serverNames) {
                        ModelNode result;
                        ModelNode server = serverGroup.get(serverName);
                        String hostName = server.get("host").asString();
                        if (!server.get(new String[]{"response", "outcome"}).asString().equals("success") || !(result = server.get(new String[]{"response", "result"})).isDefined()) continue;
                        List nodeList = result.asList();
                        for (ModelNode node : nodeList) {
                            T anObj = mapper.unwrap(node);
                            if (anObj instanceof DomainAware) {
                                ((AdminObjectImpl)anObj).setServerGroup(serverGroupName);
                                ((AdminObjectImpl)anObj).setServerName(serverName);
                                ((AdminObjectImpl)anObj).setHostName(hostName);
                            }
                            returnList.add(anObj);
                        }
                    }
                }
                return returnList;
            }
            return this.getList(operationResult, mapper);
        }

        private <T> List<T> getList(ModelNode operationResult, MetadataMapper<T> mapper) {
            if (!operationResult.hasDefined("result")) {
                return Collections.emptyList();
            }
            List nodeList = operationResult.get("result").asList();
            if (nodeList.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<T> list = new ArrayList<T>(nodeList.size());
            for (ModelNode node : nodeList) {
                list.add(mapper.unwrap(node));
            }
            return list;
        }

        @Override
        public VDB getVDB(String vdbName, int vdbVersion) throws AdminException {
            ModelNode request = this.buildRequest("teiid", "get-vdb", "vdb-name", vdbName, "vdb-version", String.valueOf(vdbVersion));
            if (request == null) {
                return null;
            }
            try {
                ModelNode outcome = this.connection.execute(request);
                if (Util.isSuccess((ModelNode)outcome)) {
                    if (this.domainMode) {
                        List<VDBMetaData> list = this.getDomainAwareList(outcome, VDBMetadataMapper.INSTANCE);
                        if (list != null && !list.isEmpty()) {
                            return list.get(0);
                        }
                    } else if (outcome.hasDefined("result")) {
                        ModelNode result = outcome.get("result");
                        return VDBMetadataMapper.INSTANCE.unwrap(result);
                    }
                }
            }
            catch (Exception e) {
                throw new AdminProcessingException(AdminPlugin.Event.TEIID70035, e, e.getMessage());
            }
            return null;
        }

        public List<? extends VDB> getVDBs() throws AdminException {
            ModelNode request = this.buildRequest("teiid", "list-vdbs", new String[0]);
            try {
                ModelNode outcome = this.connection.execute(request);
                if (Util.isSuccess((ModelNode)outcome)) {
                    return this.getDomainAwareList(outcome, VDBMetadataMapper.INSTANCE);
                }
            }
            catch (Exception e) {
                throw new AdminProcessingException(AdminPlugin.Event.TEIID70036, e, e.getMessage());
            }
            return Collections.emptyList();
        }

        @Override
        public void mergeVDBs(String sourceVDBName, int sourceVDBVersion, String targetVDBName, int targetVDBVersion) throws AdminException {
            ModelNode request = this.buildRequest("teiid", "merge-vdbs", "source-vdb-name", sourceVDBName, "source-vdb-name", String.valueOf(sourceVDBVersion), "target-vdb-name", targetVDBName, "target-vdb-version", String.valueOf(targetVDBVersion));
            try {
                ModelNode outcome = this.connection.execute(request);
                if (!Util.isSuccess((ModelNode)outcome)) {
                    throw new AdminProcessingException((BundleUtil.Event)AdminPlugin.Event.TEIID70037, Util.getFailureDescription((ModelNode)outcome));
                }
            }
            catch (Exception e) {
                throw new AdminProcessingException(AdminPlugin.Event.TEIID70038, e, e.getMessage());
            }
        }

        @Override
        public void addDataRoleMapping(String vdbName, int vdbVersion, String dataRole, String mappedRoleName) throws AdminException {
            ModelNode request = this.buildRequest("teiid", "add-data-role", "vdb-name", vdbName, "vdb-version", String.valueOf(vdbVersion), "data-role", dataRole, "mapped-role", mappedRoleName);
            try {
                ModelNode outcome = this.connection.execute(request);
                if (!Util.isSuccess((ModelNode)outcome)) {
                    throw new AdminProcessingException((BundleUtil.Event)AdminPlugin.Event.TEIID70039, Util.getFailureDescription((ModelNode)outcome));
                }
            }
            catch (Exception e) {
                throw new AdminProcessingException(AdminPlugin.Event.TEIID70040, e, e.getMessage());
            }
        }

        @Override
        public void removeDataRoleMapping(String vdbName, int vdbVersion, String dataRole, String mappedRoleName) throws AdminException {
            ModelNode request = this.buildRequest("teiid", "remove-data-role", "vdb-name", vdbName, "vdb-version", String.valueOf(vdbVersion), "data-role", dataRole, "mapped-role", mappedRoleName);
            try {
                ModelNode outcome = this.connection.execute(request);
                if (!Util.isSuccess((ModelNode)outcome)) {
                    throw new AdminProcessingException((BundleUtil.Event)AdminPlugin.Event.TEIID70041, Util.getFailureDescription((ModelNode)outcome));
                }
            }
            catch (Exception e) {
                throw new AdminProcessingException(AdminPlugin.Event.TEIID70042, e, e.getMessage());
            }
        }

        @Override
        public void setAnyAuthenticatedForDataRole(String vdbName, int vdbVersion, String dataRole, boolean anyAuthenticated) throws AdminException {
            ModelNode request = this.buildRequest("teiid", "add-anyauthenticated-role", "vdb-name", vdbName, "vdb-version", String.valueOf(vdbVersion), "data-role", dataRole);
            if (!anyAuthenticated) {
                request = this.buildRequest("teiid", "remove-anyauthenticated-role", "vdb-name", vdbName, "vdb-version", String.valueOf(vdbVersion), "data-role", dataRole);
            }
            try {
                ModelNode outcome = this.connection.execute(request);
                if (!Util.isSuccess((ModelNode)outcome)) {
                    throw new AdminProcessingException((BundleUtil.Event)AdminPlugin.Event.TEIID70043, Util.getFailureDescription((ModelNode)outcome));
                }
            }
            catch (Exception e) {
                throw new AdminProcessingException(AdminPlugin.Event.TEIID70044, e, e.getMessage());
            }
        }

        @Override
        public void changeVDBConnectionType(String vdbName, int vdbVersion, VDB.ConnectionType type) throws AdminException {
            ModelNode request = this.buildRequest("teiid", "change-vdb-connection-type", "vdb-name", vdbName, "vdb-version", String.valueOf(vdbVersion), "connection-type", type.name());
            try {
                ModelNode outcome = this.connection.execute(request);
                if (!Util.isSuccess((ModelNode)outcome)) {
                    throw new AdminProcessingException((BundleUtil.Event)AdminPlugin.Event.TEIID70045, Util.getFailureDescription((ModelNode)outcome));
                }
            }
            catch (Exception e) {
                throw new AdminProcessingException(AdminPlugin.Event.TEIID70046, e, e.getMessage());
            }
        }

        @Override
        public void assignToModel(String vdbName, int vdbVersion, String modelName, String sourceName, String translatorName, String dsName) throws AdminException {
            ModelNode request = this.buildRequest("teiid", "assign-datasource", "vdb-name", vdbName, "vdb-version", String.valueOf(vdbVersion), "model-name", modelName, "source-name", sourceName, "translator-name", translatorName, "ds-name", dsName);
            try {
                ModelNode outcome = this.connection.execute(request);
                if (!Util.isSuccess((ModelNode)outcome)) {
                    throw new AdminProcessingException((BundleUtil.Event)AdminPlugin.Event.TEIID70047, Util.getFailureDescription((ModelNode)outcome));
                }
            }
            catch (Exception e) {
                throw new AdminProcessingException(AdminPlugin.Event.TEIID70048, e, e.getMessage());
            }
        }

        @Override
        public void markDataSourceAvailable(String jndiName) throws AdminException {
            ModelNode request = this.buildRequest("teiid", "mark-datasource-available", "ds-name", jndiName);
            try {
                ModelNode outcome = this.connection.execute(request);
                if (!Util.isSuccess((ModelNode)outcome)) {
                    throw new AdminProcessingException((BundleUtil.Event)AdminPlugin.Event.TEIID70049, Util.getFailureDescription((ModelNode)outcome));
                }
            }
            catch (Exception e) {
                throw new AdminProcessingException(AdminPlugin.Event.TEIID70050, e, e.getMessage());
            }
        }

        class AbstractMetadatMapper
        implements MetadataMapper<String> {
            AbstractMetadatMapper() {
            }

            @Override
            public ModelNode wrap(String obj, ModelNode node) {
                return null;
            }

            @Override
            public String unwrap(ModelNode node) {
                return null;
            }

            @Override
            public ModelNode describe(ModelNode node) {
                return null;
            }
        }
    }

    private class AuthenticationCallbackHandler
    implements CallbackHandler {
        private boolean realmShown = false;
        private String userName = null;
        private char[] password = null;

        public AuthenticationCallbackHandler(String user, char[] password) {
            this.userName = user;
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            if (callbacks.length == 1 && callbacks[0] instanceof NameCallback) {
                ((NameCallback)callbacks[0]).setName("anonymous CLI user");
                return;
            }
            for (Callback current : callbacks) {
                if (current instanceof RealmCallback) {
                    RealmCallback rcb = (RealmCallback)current;
                    String defaultText = rcb.getDefaultText();
                    rcb.setText(defaultText);
                    if (this.realmShown) continue;
                    this.realmShown = true;
                    continue;
                }
                if (current instanceof RealmChoiceCallback) {
                    throw new UnsupportedCallbackException(current, "Realm choice not currently supported.");
                }
                if (current instanceof NameCallback) {
                    NameCallback ncb = (NameCallback)current;
                    ncb.setName(this.userName);
                    continue;
                }
                if (current instanceof PasswordCallback) {
                    PasswordCallback pcb = (PasswordCallback)current;
                    pcb.setPassword(this.password);
                    continue;
                }
                throw new UnsupportedCallbackException(current);
            }
        }
    }
}

