/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.adminapi.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.teiid.adminapi.DataPolicy;
import org.teiid.adminapi.impl.KeyBuilder;
import org.teiid.adminapi.impl.PermissionMap;

public class DataPolicyMetadata
implements DataPolicy,
Serializable {
    private static final long serialVersionUID = -4119646357275977190L;
    protected String name;
    protected String description;
    protected boolean anyAuthenticated;
    protected Boolean allowCreateTemporaryTables;
    protected PermissionMap permissions = new PermissionMap(new KeyBuilder<PermissionMetaData>(){
        private static final long serialVersionUID = -6992984146431492449L;

        @Override
        public String getKey(PermissionMetaData entry) {
            return entry.getResourceName().toLowerCase();
        }
    });
    protected List<String> mappedRoleNames = new ArrayList<String>();

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    @Override
    public List<DataPolicy.DataPermission> getPermissions() {
        return new ArrayList<DataPolicy.DataPermission>(this.permissions.getMap().values());
    }

    public void setPermissions(List<DataPolicy.DataPermission> permissions) {
        this.permissions.getMap().clear();
        for (DataPolicy.DataPermission permission : permissions) {
            this.permissions.add((PermissionMetaData)permission);
        }
    }

    public void addPermission(PermissionMetaData ... permissions) {
        for (PermissionMetaData permission : permissions) {
            this.permissions.add(permission);
        }
    }

    @Override
    public List<String> getMappedRoleNames() {
        return this.mappedRoleNames;
    }

    public void setMappedRoleNames(List<String> names) {
        this.mappedRoleNames.clear();
        this.mappedRoleNames.addAll(names);
    }

    public void addMappedRoleName(String name) {
        this.mappedRoleNames.add(name);
    }

    public void removeMappedRoleName(String name) {
        this.mappedRoleNames.remove(name);
    }

    public boolean allows(String resourceName, DataPolicy.PermissionType type) {
        resourceName = resourceName.toLowerCase();
        while (resourceName.length() > 0) {
            Boolean allowed;
            PermissionMetaData p = (PermissionMetaData)this.permissions.getMap().get(resourceName);
            if (p != null && (allowed = p.allows(type)) != null) {
                return allowed;
            }
            resourceName = resourceName.substring(0, Math.max(0, resourceName.lastIndexOf(46)));
        }
        return false;
    }

    @Override
    public Boolean isAllowCreateTemporaryTables() {
        return this.allowCreateTemporaryTables;
    }

    public void setAllowCreateTemporaryTables(Boolean allowCreateTemporaryTables) {
        this.allowCreateTemporaryTables = allowCreateTemporaryTables;
    }

    @Override
    public boolean isAnyAuthenticated() {
        return this.anyAuthenticated;
    }

    public void setAnyAuthenticated(boolean anyAuthenticated) {
        this.anyAuthenticated = anyAuthenticated;
    }

    public static class PermissionMetaData
    implements DataPolicy.DataPermission,
    Serializable {
        private static final long serialVersionUID = 7034744531663164277L;
        private String resourceName;
        protected Boolean allowCreate;
        protected Boolean allowRead;
        protected Boolean allowUpdate;
        protected Boolean allowDelete;
        protected Boolean allowExecute;
        protected Boolean allowAlter;

        @Override
        public String getResourceName() {
            return this.resourceName;
        }

        public void setResourceName(String value) {
            this.resourceName = value;
        }

        @Override
        public Boolean getAllowCreate() {
            return this.allowCreate;
        }

        public void setAllowCreate(Boolean value) {
            this.allowCreate = value;
        }

        @Override
        public Boolean getAllowRead() {
            return this.allowRead;
        }

        public void setAllowRead(Boolean value) {
            this.allowRead = value;
        }

        @Override
        public Boolean getAllowUpdate() {
            return this.allowUpdate;
        }

        public void setAllowUpdate(Boolean value) {
            this.allowUpdate = value;
        }

        @Override
        public Boolean getAllowDelete() {
            return this.allowDelete;
        }

        public void setAllowDelete(Boolean value) {
            this.allowDelete = value;
        }

        public String getType() {
            StringBuilder sb = new StringBuilder();
            if (Boolean.TRUE.equals(this.getAllowCreate())) {
                sb.append("C");
            }
            if (Boolean.TRUE.equals(this.getAllowRead())) {
                sb.append("R");
            }
            if (Boolean.TRUE.equals(this.getAllowUpdate())) {
                sb.append("U");
            }
            if (Boolean.TRUE.equals(this.getAllowDelete())) {
                sb.append("D");
            }
            if (Boolean.TRUE.equals(this.getAllowExecute())) {
                sb.append("E");
            }
            if (Boolean.TRUE.equals(this.getAllowAlter())) {
                sb.append("A");
            }
            return sb.toString();
        }

        public Boolean allows(DataPolicy.PermissionType type) {
            switch (type) {
                case ALTER: {
                    return this.getAllowAlter();
                }
                case CREATE: {
                    return this.getAllowCreate();
                }
                case EXECUTE: {
                    if (this.getAllowExecute() != null) {
                        return this.getAllowExecute();
                    }
                }
                case READ: {
                    return this.getAllowRead();
                }
                case UPDATE: {
                    return this.getAllowUpdate();
                }
                case DELETE: {
                    return this.getAllowDelete();
                }
            }
            throw new AssertionError();
        }

        @Override
        public Boolean getAllowAlter() {
            return this.allowAlter;
        }

        @Override
        public Boolean getAllowExecute() {
            return this.allowExecute;
        }

        public void setAllowAlter(Boolean allowAlter) {
            this.allowAlter = allowAlter;
        }

        public void setAllowExecute(Boolean allowExecute) {
            this.allowExecute = allowExecute;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getResourceName());
            sb.append("[");
            sb.append(this.getType());
            sb.append("]");
            return sb.toString();
        }
    }
}

