/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.adminapi.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.impl.AdminObjectImpl;
import org.teiid.adminapi.impl.KeyBuilder;
import org.teiid.adminapi.impl.ListOverMap;
import org.teiid.adminapi.impl.PropertyMetadata;
import org.teiid.adminapi.impl.SourceMappingMetadata;

public class ModelMetaData
extends AdminObjectImpl
implements Model {
    private static final int DEFAULT_ERROR_HISTORY = 10;
    private static final String SUPPORTS_MULTI_SOURCE_BINDINGS_KEY = "supports-multi-source-bindings";
    private static final long serialVersionUID = 3714234763056162230L;
    protected ListOverMap<SourceMappingMetadata> sources = new ListOverMap<SourceMappingMetadata>(new KeyBuilder<SourceMappingMetadata>(){
        private static final long serialVersionUID = 2273673984691112369L;

        @Override
        public String getKey(SourceMappingMetadata entry) {
            return entry.getName();
        }
    });
    protected String modelType = Model.Type.PHYSICAL.name();
    protected String description;
    protected String path;
    protected Boolean visible = true;
    protected List<ValidationError> errors;
    protected String schemaSourceType;
    protected String schemaText;

    @Override
    public String getName() {
        return super.getName();
    }

    @Override
    public void setName(String name) {
        super.setName(name);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean isSource() {
        return this.getModelType() == Model.Type.PHYSICAL;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public Model.Type getModelType() {
        try {
            return Model.Type.valueOf(this.modelType);
        }
        catch (IllegalArgumentException e) {
            return Model.Type.OTHER;
        }
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public boolean isSupportsMultiSourceBindings() {
        String supports = this.getPropertyValue(SUPPORTS_MULTI_SOURCE_BINDINGS_KEY);
        return Boolean.parseBoolean(supports);
    }

    @Override
    public List<PropertyMetadata> getJAXBProperties() {
        return super.getJAXBProperties();
    }

    public void setSupportsMultiSourceBindings(boolean supports) {
        this.addProperty(SUPPORTS_MULTI_SOURCE_BINDINGS_KEY, Boolean.toString(supports));
    }

    public void setModelType(Model.Type modelType) {
        this.modelType = modelType.name();
    }

    public void setModelType(String modelType) {
        this.modelType = modelType != null ? modelType.toUpperCase() : null;
    }

    public String toString() {
        return this.getName() + this.sources;
    }

    public void setVisible(Boolean value) {
        this.visible = value;
    }

    public List<SourceMappingMetadata> getSourceMappings() {
        return new ArrayList<SourceMappingMetadata>(this.sources.getMap().values());
    }

    public SourceMappingMetadata getSourceMapping(String sourceName) {
        return this.sources.getMap().get(sourceName);
    }

    public void setSourceMappings(List<SourceMappingMetadata> sources) {
        for (SourceMappingMetadata source : sources) {
            this.addSourceMapping(source.getName(), source.getTranslatorName(), source.getConnectionJndiName());
        }
    }

    @Override
    public List<String> getSourceNames() {
        return new ArrayList<String>(this.sources.getMap().keySet());
    }

    @Override
    public String getSourceConnectionJndiName(String sourceName) {
        SourceMappingMetadata s = this.sources.getMap().get(sourceName);
        if (s == null) {
            return null;
        }
        return s.getConnectionJndiName();
    }

    @Override
    public String getSourceTranslatorName(String sourceName) {
        SourceMappingMetadata s = this.sources.getMap().get(sourceName);
        if (s == null) {
            return null;
        }
        return s.getTranslatorName();
    }

    public void addSourceMapping(String name, String translatorName, String connJndiName) {
        this.sources.getMap().put(name, new SourceMappingMetadata(name, translatorName, connJndiName));
    }

    public void addSourceMapping(SourceMappingMetadata source) {
        this.sources.getMap().put(source.getName(), new SourceMappingMetadata(source.getName(), source.getTranslatorName(), source.getConnectionJndiName()));
    }

    public List<ValidationError> getErrors() {
        return this.getValidationErrors(ValidationError.Severity.ERROR);
    }

    public void setErrors(List<ValidationError> errors) {
        this.errors = errors;
    }

    public synchronized List<ValidationError> getValidationErrors(ValidationError.Severity severity) {
        if (this.errors == null) {
            return Collections.emptyList();
        }
        ArrayList<ValidationError> list = new ArrayList<ValidationError>();
        for (ValidationError ve : this.errors) {
            if (ValidationError.Severity.valueOf(ve.severity) != severity) continue;
            list.add(ve);
        }
        return list;
    }

    public synchronized ValidationError addError(String severity, String message) {
        if (this.errors == null) {
            this.errors = new LinkedList<ValidationError>();
        }
        ValidationError ve = new ValidationError(severity, message);
        this.errors.add(ve);
        if (this.errors.size() > 10) {
            this.errors.remove(0);
        }
        return ve;
    }

    public synchronized ValidationError addError(ValidationError ve) {
        if (this.errors == null) {
            this.errors = new LinkedList<ValidationError>();
        }
        this.errors.add(ve);
        if (this.errors.size() > 10) {
            this.errors.remove(0);
        }
        return ve;
    }

    public synchronized boolean removeError(ValidationError remove) {
        if (this.errors == null) {
            return false;
        }
        return this.errors.remove(remove);
    }

    public synchronized void clearErrors() {
        this.errors.clear();
    }

    public String getSchemaSourceType() {
        return this.schemaSourceType;
    }

    public void setSchemaSourceType(String schemaSourceType) {
        this.schemaSourceType = schemaSourceType;
    }

    public String getSchemaText() {
        return this.schemaText;
    }

    public void setSchemaText(String schemaText) {
        this.schemaText = schemaText;
    }

    public static class ValidationError
    implements Serializable {
        private static final long serialVersionUID = 2044197069467559527L;
        protected String value;
        protected String severity;
        protected String path;

        public ValidationError() {
        }

        public ValidationError(String severity, String msg) {
            this.severity = severity;
            this.value = msg;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getSeverity() {
            return this.severity;
        }

        public void setSeverity(String severity) {
            this.severity = severity;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ValidationError other = (ValidationError)obj;
            if (this.severity == null ? other.severity != null : !this.severity.equals(other.severity)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        public static enum Severity {
            ERROR,
            WARNING;

        }
    }
}

