/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.adminapi.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teiid.adminapi.DataPolicy;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.Translator;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.AdminObjectImpl;
import org.teiid.adminapi.impl.DataPolicyMetadata;
import org.teiid.adminapi.impl.KeyBuilder;
import org.teiid.adminapi.impl.ListOverMap;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.PropertyMetadata;
import org.teiid.adminapi.impl.VDBTranslatorMetaData;
import org.teiid.core.util.StringUtil;

public class VDBMetaData
extends AdminObjectImpl
implements VDB {
    private static final String VERSION_DELIM = ".";
    private static final long serialVersionUID = -4723595252013356436L;
    protected ListOverMap<ModelMetaData> models = new ListOverMap<ModelMetaData>(new KeyBuilder<ModelMetaData>(){
        private static final long serialVersionUID = 846247100420118961L;

        @Override
        public String getKey(ModelMetaData entry) {
            return entry.getName();
        }
    });
    protected ListOverMap<VDBTranslatorMetaData> translators = new ListOverMap<VDBTranslatorMetaData>(new KeyBuilder<VDBTranslatorMetaData>(){
        private static final long serialVersionUID = 3890502172003653563L;

        @Override
        public String getKey(VDBTranslatorMetaData entry) {
            return entry.getName();
        }
    });
    protected ListOverMap<DataPolicyMetadata> dataPolicies = new ListOverMap<DataPolicyMetadata>(new KeyBuilder<DataPolicyMetadata>(){
        private static final long serialVersionUID = 4954591545242715254L;

        @Override
        public String getKey(DataPolicyMetadata entry) {
            return entry.getName();
        }
    });
    private int version = 1;
    protected String description;
    private String fileUrl = null;
    private boolean dynamic = false;
    private VDB.Status status = VDB.Status.INACTIVE;
    private VDB.ConnectionType connectionType = VDB.ConnectionType.BY_VERSION;
    private boolean removed;
    private long queryTimeout = Long.MIN_VALUE;

    @Override
    public String getName() {
        return super.getName();
    }

    public String getFullName() {
        return this.getName() + VERSION_DELIM + this.getVersion();
    }

    @Override
    public void setName(String name) {
        super.setName(name);
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void setRemoved(boolean removed) {
        this.removed = removed;
    }

    @Override
    public VDB.ConnectionType getConnectionType() {
        return this.connectionType;
    }

    public void setConnectionType(VDB.ConnectionType allowConnections) {
        this.connectionType = allowConnections;
    }

    public void setConnectionType(String allowConnections) {
        this.connectionType = VDB.ConnectionType.valueOf(allowConnections);
    }

    @Override
    public VDB.Status getStatus() {
        return this.status;
    }

    public void setStatus(VDB.Status s) {
        this.status = s;
    }

    public void setStatus(String s) {
        this.status = VDB.Status.valueOf(s);
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    public String getUrl() {
        return this.fileUrl;
    }

    public void setUrl(String url) {
        this.fileUrl = url;
    }

    public void setUrl(URL url) {
        String fileName;
        String[] parts;
        this.setUrl(url.toExternalForm());
        String path = url.getPath();
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((parts = (fileName = StringUtil.getLastToken((String)path, (String)"/")).split("\\."))[0].equalsIgnoreCase(this.getName()) && parts.length >= 3) {
            try {
                int fileVersion = Integer.parseInt(parts[parts.length - 2]);
                this.setVersion(fileVersion);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }

    @Override
    public List<Model> getModels() {
        return new ArrayList<Model>(this.models.getMap().values());
    }

    public Map<String, ModelMetaData> getModelMetaDatas() {
        return this.models.getMap();
    }

    public void setModels(List<Model> models) {
        for (Model obj : models) {
            ModelMetaData model = (ModelMetaData)obj;
            this.addModel(model);
        }
    }

    public void addModel(ModelMetaData m) {
        this.models.getMap().put(m.getName(), m);
    }

    @Override
    public List<Translator> getOverrideTranslators() {
        return new ArrayList<Translator>(this.translators.getMap().values());
    }

    public void setOverrideTranslators(List<Translator> translators) {
        for (Translator t : translators) {
            this.translators.getMap().put(t.getName(), (VDBTranslatorMetaData)t);
        }
    }

    public void addOverideTranslator(VDBTranslatorMetaData t) {
        this.translators.getMap().put(t.getName(), t);
    }

    public boolean isOverideTranslator(String name) {
        return this.translators.getMap().containsKey(name);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    @Override
    public List<String> getValidityErrors() {
        ArrayList<String> allErrors = new ArrayList<String>();
        for (ModelMetaData model : this.models.getMap().values()) {
            List<ModelMetaData.ValidationError> errors = model.getErrors();
            if (errors == null || errors.isEmpty()) continue;
            for (ModelMetaData.ValidationError m : errors) {
                if (!ModelMetaData.ValidationError.Severity.valueOf(m.getSeverity()).equals((Object)ModelMetaData.ValidationError.Severity.ERROR)) continue;
                allErrors.add(m.getValue());
            }
        }
        return allErrors;
    }

    @Override
    public boolean isValid() {
        if (!this.getValidityErrors().isEmpty()) {
            return false;
        }
        if (this.getModels().isEmpty()) {
            return false;
        }
        for (ModelMetaData m : this.models.getMap().values()) {
            if (!m.isSource()) continue;
            List<String> resourceNames = m.getSourceNames();
            if (resourceNames.isEmpty()) {
                return false;
            }
            for (String sourceName : resourceNames) {
                if (m.getSourceConnectionJndiName(sourceName) != null) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return this.getName() + VERSION_DELIM + this.getVersion() + this.models.getMap().values();
    }

    public boolean isVisible(String modelName) {
        ModelMetaData model = this.getModel(modelName);
        return model == null || model.isVisible();
    }

    public ModelMetaData getModel(String modelName) {
        return this.models.getMap().get(modelName);
    }

    public Set<String> getMultiSourceModelNames() {
        HashSet<String> list = new HashSet<String>();
        for (ModelMetaData m : this.models.getMap().values()) {
            if (!m.isSupportsMultiSourceBindings()) continue;
            list.add(m.getName());
        }
        return list;
    }

    @Override
    public List<PropertyMetadata> getJAXBProperties() {
        return super.getJAXBProperties();
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    @Override
    public List<DataPolicy> getDataPolicies() {
        return new ArrayList<DataPolicy>(this.dataPolicies.getMap().values());
    }

    public void setDataPolicies(List<DataPolicy> policies) {
        this.dataPolicies.getMap().clear();
        for (DataPolicy policy : policies) {
            this.dataPolicies.getMap().put(policy.getName(), (DataPolicyMetadata)policy);
        }
    }

    public void addDataPolicy(DataPolicyMetadata policy) {
        this.dataPolicies.getMap().put(policy.getName(), policy);
    }

    public DataPolicyMetadata getDataPolicy(String policyName) {
        return this.dataPolicies.getMap().get(policyName);
    }

    public VDBTranslatorMetaData getTranslator(String name) {
        return this.translators.getMap().get(name);
    }

    public boolean isPreview() {
        return Boolean.valueOf(this.getPropertyValue("preview"));
    }

    public long getQueryTimeout() {
        if (this.queryTimeout == Long.MIN_VALUE) {
            String timeout = this.getPropertyValue("query-timeout");
            this.queryTimeout = timeout != null ? Math.max(0L, Long.parseLong(timeout)) : 0L;
        }
        return this.queryTimeout;
    }
}

