/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.adminapi.impl;

import java.util.List;
import java.util.Map;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.teiid.adminapi.AdminPlugin;
import org.teiid.adminapi.DataPolicy;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.Request;
import org.teiid.adminapi.Translator;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.AdminObjectImpl;
import org.teiid.adminapi.impl.CacheStatisticsMetadata;
import org.teiid.adminapi.impl.DataPolicyMetadata;
import org.teiid.adminapi.impl.MetadataMapper;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.PropertyMetadata;
import org.teiid.adminapi.impl.RequestMetadata;
import org.teiid.adminapi.impl.SessionMetadata;
import org.teiid.adminapi.impl.SourceMappingMetadata;
import org.teiid.adminapi.impl.TransactionMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBTranslatorMetaData;
import org.teiid.adminapi.impl.WorkerPoolStatisticsMetadata;

public class VDBMetadataMapper
implements MetadataMapper<VDBMetaData> {
    private static final String VDBNAME = "vdb-name";
    private static final String CONNECTIONTYPE = "connection-type";
    private static final String STATUS = "status";
    private static final String VERSION = "vdb-version";
    private static final String URL = "url";
    private static final String MODELS = "models";
    private static final String OVERRIDE_TRANSLATORS = "override-translators";
    private static final String VDB_DESCRIPTION = "vdb-description";
    private static final String PROPERTIES = "properties";
    private static final String DYNAMIC = "dynamic";
    private static final String DATA_POLICIES = "data-policies";
    private static final String DESCRIPTION = "description";
    public static VDBMetadataMapper INSTANCE = new VDBMetadataMapper();
    private static final String SERVER_GROUP = "server-group";
    private static final String HOST_NAME = "host-name";
    private static final String SERVER_NAME = "server-name";
    private static final String DOT_DESC = ".describe";
    private static final String TYPE = "type";
    private static final String REQUIRED = "required";
    private static final String ALLOWED = "allowed";
    private static final String VALUE_TYPE = "value-type";

    @Override
    public ModelNode wrap(VDBMetaData vdb, ModelNode node) {
        List<DataPolicy> policies;
        List<Translator> translators;
        Map<String, ModelMetaData> models;
        if (vdb == null) {
            return null;
        }
        node.get(TYPE).set(ModelType.OBJECT);
        node.get(VDBNAME).set(vdb.getName());
        node.get(CONNECTIONTYPE).set(vdb.getConnectionType().toString());
        node.get(STATUS).set(vdb.getStatus().toString());
        node.get(VERSION).set(vdb.getVersion());
        if (vdb.getUrl() != null) {
            // empty if block
        }
        if (vdb.getDescription() != null) {
            node.get(VDB_DESCRIPTION).set(vdb.getDescription());
        }
        node.get(DYNAMIC).set(vdb.isDynamic());
        List<PropertyMetadata> properties = vdb.getJAXBProperties();
        if (properties != null && !properties.isEmpty()) {
            ModelNode propsNode = node.get(PROPERTIES);
            for (PropertyMetadata prop : properties) {
                propsNode.add(PropertyMetaDataMapper.INSTANCE.wrap(prop, new ModelNode()));
            }
        }
        if ((models = vdb.getModelMetaDatas()) != null && !models.isEmpty()) {
            ModelNode modelNodes = node.get(MODELS);
            for (ModelMetaData model : models.values()) {
                modelNodes.add(ModelMetadataMapper.INSTANCE.wrap(model, new ModelNode()));
            }
        }
        if ((translators = vdb.getOverrideTranslators()) != null && !translators.isEmpty()) {
            ModelNode translatorNodes = node.get(OVERRIDE_TRANSLATORS);
            for (Translator translator : translators) {
                translatorNodes.add(VDBTranslatorMetaDataMapper.INSTANCE.wrap((VDBTranslatorMetaData)translator, new ModelNode()));
            }
        }
        if ((policies = vdb.getDataPolicies()) != null && !policies.isEmpty()) {
            ModelNode dataPoliciesNodes = node.get(DATA_POLICIES);
            for (DataPolicy policy : policies) {
                dataPoliciesNodes.add(DataPolicyMetadataMapper.INSTANCE.wrap((DataPolicyMetadata)policy, new ModelNode()));
            }
        }
        VDBMetadataMapper.wrapDomain(vdb, node);
        return node;
    }

    @Override
    public VDBMetaData unwrap(ModelNode node) {
        if (node == null) {
            return null;
        }
        VDBMetaData vdb = new VDBMetaData();
        if (node.has(VDBNAME)) {
            vdb.setName(node.get(VDBNAME).asString());
        }
        if (node.has(CONNECTIONTYPE)) {
            vdb.setConnectionType(node.get(CONNECTIONTYPE).asString());
        }
        if (node.has(STATUS)) {
            vdb.setStatus(node.get(STATUS).asString());
        }
        if (node.has(VERSION)) {
            vdb.setVersion(node.get(VERSION).asInt());
        }
        if (node.has(URL)) {
            vdb.setUrl(node.get(URL).asString());
        }
        if (node.has(VDB_DESCRIPTION)) {
            vdb.setDescription(node.get(VDB_DESCRIPTION).asString());
        }
        if (node.has(DYNAMIC)) {
            vdb.setDynamic(node.get(DYNAMIC).asBoolean());
        }
        if (node.get(PROPERTIES).isDefined()) {
            List propNodes = node.get(PROPERTIES).asList();
            for (ModelNode propNode : propNodes) {
                PropertyMetadata prop = PropertyMetaDataMapper.INSTANCE.unwrap(propNode);
                if (prop == null) continue;
                vdb.addProperty(prop.getName(), prop.getValue());
            }
        }
        if (node.get(MODELS).isDefined()) {
            List modelNodes = node.get(MODELS).asList();
            for (ModelNode modelNode : modelNodes) {
                ModelMetaData model = ModelMetadataMapper.INSTANCE.unwrap(modelNode);
                if (model == null) continue;
                vdb.addModel(model);
            }
        }
        if (node.get(OVERRIDE_TRANSLATORS).isDefined()) {
            List translatorNodes = node.get(OVERRIDE_TRANSLATORS).asList();
            for (ModelNode translatorNode : translatorNodes) {
                VDBTranslatorMetaData translator = VDBTranslatorMetaDataMapper.INSTANCE.unwrap(translatorNode);
                if (translator == null) continue;
                vdb.addOverideTranslator(translator);
            }
        }
        if (node.get(DATA_POLICIES).isDefined()) {
            List policiesNodes = node.get(DATA_POLICIES).asList();
            for (ModelNode policyNode : policiesNodes) {
                DataPolicyMetadata policy = DataPolicyMetadataMapper.INSTANCE.unwrap(policyNode);
                if (policy == null) continue;
                vdb.addDataPolicy(policy);
            }
        }
        VDBMetadataMapper.unwrapDomain(vdb, node);
        return vdb;
    }

    @Override
    public ModelNode describe(ModelNode node) {
        VDBMetadataMapper.addAttribute(node, VDBNAME, ModelType.STRING, true);
        ModelNode connectionsAllowed = new ModelNode();
        connectionsAllowed.add(VDB.ConnectionType.NONE.toString());
        connectionsAllowed.add(VDB.ConnectionType.ANY.toString());
        connectionsAllowed.add(VDB.ConnectionType.BY_VERSION.toString());
        VDBMetadataMapper.addAttribute(node, CONNECTIONTYPE, ModelType.STRING, false);
        node.get(CONNECTIONTYPE).get(ALLOWED).set(connectionsAllowed);
        ModelNode statusAllowed = new ModelNode();
        statusAllowed.add(VDB.Status.ACTIVE.toString());
        statusAllowed.add(VDB.Status.INACTIVE.toString());
        VDBMetadataMapper.addAttribute(node, STATUS, ModelType.STRING, true);
        node.get(STATUS).get(ALLOWED).set(statusAllowed);
        VDBMetadataMapper.addAttribute(node, VERSION, ModelType.INT, true);
        VDBMetadataMapper.addAttribute(node, URL, ModelType.STRING, false);
        VDBMetadataMapper.addAttribute(node, VDB_DESCRIPTION, ModelType.STRING, false);
        VDBMetadataMapper.addAttribute(node, DYNAMIC, ModelType.BOOLEAN, false);
        ModelNode props = node.get(PROPERTIES);
        props.get(TYPE).set(ModelType.LIST);
        props.get(DESCRIPTION).set(AdminPlugin.Util.getString("properties.describe"));
        PropertyMetaDataMapper.INSTANCE.describe(props.get(VALUE_TYPE));
        ModelNode models = node.get(MODELS);
        models.get(TYPE).set(ModelType.LIST);
        ModelMetadataMapper.INSTANCE.describe(models.get(VALUE_TYPE));
        models.get(DESCRIPTION).set(AdminPlugin.Util.getString("models.describe"));
        ModelNode translators = node.get(OVERRIDE_TRANSLATORS);
        translators.get(TYPE).set(ModelType.LIST);
        translators.get(DESCRIPTION).set(AdminPlugin.Util.getString("override-translators.describe"));
        VDBTranslatorMetaDataMapper.INSTANCE.describe(translators.get(VALUE_TYPE));
        ModelNode dataPolicies = node.get(DATA_POLICIES);
        dataPolicies.get(TYPE).set(ModelType.LIST);
        dataPolicies.get(DESCRIPTION).set(AdminPlugin.Util.getString("data-policies.describe"));
        DataPolicyMetadataMapper.INSTANCE.describe(dataPolicies.get(VALUE_TYPE));
        return node;
    }

    public static void wrapDomain(AdminObjectImpl anObj, ModelNode node) {
        if (anObj.getServerGroup() != null) {
            node.get(SERVER_GROUP).set(anObj.getServerGroup());
        }
        if (anObj.getHostName() != null) {
            node.get(HOST_NAME).set(anObj.getHostName());
        }
        if (anObj.getServerName() != null) {
            node.get(SERVER_NAME).set(anObj.getServerName());
        }
    }

    public static void unwrapDomain(AdminObjectImpl anObj, ModelNode node) {
        if (node.get(SERVER_GROUP).isDefined()) {
            anObj.setServerGroup(node.get(SERVER_GROUP).asString());
        }
        if (node.get(HOST_NAME).isDefined()) {
            anObj.setHostName(node.get(HOST_NAME).asString());
        }
        if (node.get(SERVER_NAME).isDefined()) {
            anObj.setServerName(node.get(SERVER_NAME).asString());
        }
    }

    static ModelNode addAttribute(ModelNode node, String name, ModelType dataType, boolean required) {
        node.get(new String[]{name, TYPE}).set(dataType);
        node.get(new String[]{name, DESCRIPTION}).set(AdminPlugin.Util.getString(name + DOT_DESC));
        node.get(new String[]{name, REQUIRED}).set(required);
        return node;
    }

    public static class WorkerPoolStatisticsMetadataMapper
    implements MetadataMapper<WorkerPoolStatisticsMetadata> {
        private static final String MAX_THREADS = "max-threads";
        private static final String HIGHEST_QUEUED = "highest-queued";
        private static final String QUEUED = "queued";
        private static final String QUEUE_NAME = "queue-name";
        private static final String TOTAL_SUBMITTED = "total-submitted";
        private static final String TOTAL_COMPLETED = "total-completed";
        private static final String HIGHEST_ACTIVE_THREADS = "highest-active-threads";
        private static final String ACTIVE_THREADS = "active-threads";
        public static WorkerPoolStatisticsMetadataMapper INSTANCE = new WorkerPoolStatisticsMetadataMapper();

        @Override
        public ModelNode wrap(WorkerPoolStatisticsMetadata stats, ModelNode node) {
            if (stats == null) {
                return null;
            }
            node.get(VDBMetadataMapper.TYPE).set(ModelType.OBJECT);
            node.get(ACTIVE_THREADS).set(stats.getActiveThreads());
            node.get(HIGHEST_ACTIVE_THREADS).set(stats.getHighestActiveThreads());
            node.get(TOTAL_COMPLETED).set(stats.getTotalCompleted());
            node.get(TOTAL_SUBMITTED).set(stats.getTotalSubmitted());
            node.get(QUEUE_NAME).set(stats.getQueueName());
            node.get(QUEUED).set(stats.getQueued());
            node.get(HIGHEST_QUEUED).set(stats.getHighestQueued());
            node.get(MAX_THREADS).set(stats.getMaxThreads());
            VDBMetadataMapper.wrapDomain(stats, node);
            return node;
        }

        @Override
        public WorkerPoolStatisticsMetadata unwrap(ModelNode node) {
            if (node == null) {
                return null;
            }
            WorkerPoolStatisticsMetadata stats = new WorkerPoolStatisticsMetadata();
            stats.setActiveThreads(node.get(ACTIVE_THREADS).asInt());
            stats.setHighestActiveThreads(node.get(HIGHEST_ACTIVE_THREADS).asInt());
            stats.setTotalCompleted(node.get(TOTAL_COMPLETED).asLong());
            stats.setTotalSubmitted(node.get(TOTAL_SUBMITTED).asLong());
            stats.setQueueName(node.get(QUEUE_NAME).asString());
            stats.setQueued(node.get(QUEUED).asInt());
            stats.setHighestQueued(node.get(HIGHEST_QUEUED).asInt());
            stats.setMaxThreads(node.get(MAX_THREADS).asInt());
            VDBMetadataMapper.unwrapDomain(stats, node);
            return stats;
        }

        @Override
        public ModelNode describe(ModelNode node) {
            VDBMetadataMapper.addAttribute(node, ACTIVE_THREADS, ModelType.INT, true);
            VDBMetadataMapper.addAttribute(node, HIGHEST_ACTIVE_THREADS, ModelType.INT, true);
            VDBMetadataMapper.addAttribute(node, TOTAL_COMPLETED, ModelType.LONG, true);
            VDBMetadataMapper.addAttribute(node, TOTAL_SUBMITTED, ModelType.LONG, true);
            VDBMetadataMapper.addAttribute(node, QUEUE_NAME, ModelType.STRING, true);
            VDBMetadataMapper.addAttribute(node, QUEUED, ModelType.INT, true);
            VDBMetadataMapper.addAttribute(node, HIGHEST_QUEUED, ModelType.INT, true);
            VDBMetadataMapper.addAttribute(node, MAX_THREADS, ModelType.INT, true);
            return node;
        }
    }

    public static class TransactionMetadataMapper
    implements MetadataMapper<TransactionMetadata> {
        private static final String ID = "txn-id";
        private static final String SCOPE = "txn-scope";
        private static final String CREATED_TIME = "txn-created-time";
        private static final String ASSOCIATED_SESSION = "session-id";
        public static TransactionMetadataMapper INSTANCE = new TransactionMetadataMapper();

        @Override
        public ModelNode wrap(TransactionMetadata object, ModelNode transaction) {
            if (object == null) {
                return null;
            }
            transaction.get(ASSOCIATED_SESSION).set(object.getAssociatedSession());
            transaction.get(CREATED_TIME).set(object.getCreatedTime());
            transaction.get(SCOPE).set(object.getScope());
            transaction.get(ID).set(object.getId());
            VDBMetadataMapper.wrapDomain(object, transaction);
            return transaction;
        }

        @Override
        public TransactionMetadata unwrap(ModelNode node) {
            if (node == null) {
                return null;
            }
            TransactionMetadata transaction = new TransactionMetadata();
            transaction.setAssociatedSession(node.get(ASSOCIATED_SESSION).asString());
            transaction.setCreatedTime(node.get(CREATED_TIME).asLong());
            transaction.setScope(node.get(SCOPE).asString());
            transaction.setId(node.get(ID).asString());
            VDBMetadataMapper.unwrapDomain(transaction, node);
            return transaction;
        }

        @Override
        public ModelNode describe(ModelNode node) {
            VDBMetadataMapper.addAttribute(node, ASSOCIATED_SESSION, ModelType.STRING, true);
            VDBMetadataMapper.addAttribute(node, CREATED_TIME, ModelType.LONG, true);
            VDBMetadataMapper.addAttribute(node, SCOPE, ModelType.LONG, true);
            VDBMetadataMapper.addAttribute(node, ID, ModelType.STRING, true);
            return node;
        }
    }

    public static class SessionMetadataMapper
    implements MetadataMapper<SessionMetadata> {
        private static final String SECURITY_DOMAIN = "security-domain";
        private static final String VDB_VERSION = "vdb-version";
        private static final String VDB_NAME = "vdb-name";
        private static final String USER_NAME = "user-name";
        private static final String SESSION_ID = "session-id";
        private static final String LAST_PING_TIME = "last-ping-time";
        private static final String IP_ADDRESS = "ip-address";
        private static final String CLIENT_HOST_NAME = "client-host-address";
        private static final String CREATED_TIME = "created-time";
        private static final String APPLICATION_NAME = "application-name";
        private static final String CLIENT_HARDWARE_ADRESS = "client-hardware-address";
        public static SessionMetadataMapper INSTANCE = new SessionMetadataMapper();

        @Override
        public ModelNode wrap(SessionMetadata session, ModelNode node) {
            if (session == null) {
                return null;
            }
            if (session.getApplicationName() != null) {
                node.get(APPLICATION_NAME).set(session.getApplicationName());
            }
            node.get(CREATED_TIME).set(session.getCreatedTime());
            node.get(CLIENT_HOST_NAME).set(session.getClientHostName());
            node.get(IP_ADDRESS).set(session.getIPAddress());
            node.get(LAST_PING_TIME).set(session.getLastPingTime());
            node.get(SESSION_ID).set(session.getSessionId());
            node.get(USER_NAME).set(session.getUserName());
            node.get("vdb-name").set(session.getVDBName());
            node.get("vdb-version").set(session.getVDBVersion());
            if (session.getSecurityDomain() != null) {
                node.get(SECURITY_DOMAIN).set(session.getSecurityDomain());
            }
            if (session.getClientHardwareAddress() != null) {
                node.get(CLIENT_HARDWARE_ADRESS).set(session.getClientHardwareAddress());
            }
            VDBMetadataMapper.wrapDomain(session, node);
            return node;
        }

        @Override
        public SessionMetadata unwrap(ModelNode node) {
            if (node == null) {
                return null;
            }
            SessionMetadata session = new SessionMetadata();
            if (node.has(APPLICATION_NAME)) {
                session.setApplicationName(node.get(APPLICATION_NAME).asString());
            }
            session.setCreatedTime(node.get(CREATED_TIME).asLong());
            session.setClientHostName(node.get(CLIENT_HOST_NAME).asString());
            session.setIPAddress(node.get(IP_ADDRESS).asString());
            session.setLastPingTime(node.get(LAST_PING_TIME).asLong());
            session.setSessionId(node.get(SESSION_ID).asString());
            session.setUserName(node.get(USER_NAME).asString());
            session.setVDBName(node.get("vdb-name").asString());
            session.setVDBVersion(node.get("vdb-version").asInt());
            if (node.has(SECURITY_DOMAIN)) {
                session.setSecurityDomain(node.get(SECURITY_DOMAIN).asString());
            }
            if (node.has(CLIENT_HARDWARE_ADRESS)) {
                session.setClientHardwareAddress(node.get(CLIENT_HARDWARE_ADRESS).asString());
            }
            VDBMetadataMapper.unwrapDomain(session, node);
            return session;
        }

        @Override
        public ModelNode describe(ModelNode node) {
            VDBMetadataMapper.addAttribute(node, APPLICATION_NAME, ModelType.STRING, false);
            VDBMetadataMapper.addAttribute(node, CREATED_TIME, ModelType.LONG, true);
            VDBMetadataMapper.addAttribute(node, CLIENT_HOST_NAME, ModelType.LONG, true);
            VDBMetadataMapper.addAttribute(node, IP_ADDRESS, ModelType.STRING, true);
            VDBMetadataMapper.addAttribute(node, LAST_PING_TIME, ModelType.LONG, true);
            VDBMetadataMapper.addAttribute(node, SESSION_ID, ModelType.STRING, true);
            VDBMetadataMapper.addAttribute(node, USER_NAME, ModelType.STRING, true);
            VDBMetadataMapper.addAttribute(node, "vdb-name", ModelType.STRING, true);
            VDBMetadataMapper.addAttribute(node, "vdb-version", ModelType.INT, true);
            VDBMetadataMapper.addAttribute(node, SECURITY_DOMAIN, ModelType.STRING, false);
            return node;
        }
    }

    public static class RequestMetadataMapper
    implements MetadataMapper<RequestMetadata> {
        private static final String TRANSACTION_ID = "transaction-id";
        private static final String NODE_ID = "node-id";
        private static final String SOURCE_REQUEST = "source-request";
        private static final String COMMAND = "command";
        private static final String START_TIME = "start-time";
        private static final String SESSION_ID = "session-id";
        private static final String EXECUTION_ID = "execution-id";
        private static final String STATE = "processing-state";
        private static final String THREAD_STATE = "thread-state";
        public static RequestMetadataMapper INSTANCE = new RequestMetadataMapper();

        @Override
        public ModelNode wrap(RequestMetadata request, ModelNode node) {
            if (request == null) {
                return null;
            }
            node.get(EXECUTION_ID).set(request.getExecutionId());
            node.get(SESSION_ID).set(request.getSessionId());
            node.get(START_TIME).set(request.getStartTime());
            node.get(COMMAND).set(request.getCommand());
            node.get(SOURCE_REQUEST).set(request.sourceRequest());
            if (request.getNodeId() != null) {
                node.get(NODE_ID).set(request.getNodeId().intValue());
            }
            if (request.getTransactionId() != null) {
                node.get(TRANSACTION_ID).set(request.getTransactionId());
            }
            node.get(STATE).set(request.getState().name());
            node.get(THREAD_STATE).set(request.getThreadState().name());
            VDBMetadataMapper.wrapDomain(request, node);
            return node;
        }

        @Override
        public RequestMetadata unwrap(ModelNode node) {
            if (node == null) {
                return null;
            }
            RequestMetadata request = new RequestMetadata();
            request.setExecutionId(node.get(EXECUTION_ID).asLong());
            request.setSessionId(node.get(SESSION_ID).asString());
            request.setStartTime(node.get(START_TIME).asLong());
            request.setCommand(node.get(COMMAND).asString());
            request.setSourceRequest(node.get(SOURCE_REQUEST).asBoolean());
            if (node.has(NODE_ID)) {
                request.setNodeId(node.get(NODE_ID).asInt());
            }
            if (node.has(TRANSACTION_ID)) {
                request.setTransactionId(node.get(TRANSACTION_ID).asString());
            }
            request.setState(Request.ProcessingState.valueOf(node.get(STATE).asString()));
            request.setThreadState(Request.ThreadState.valueOf(node.get(THREAD_STATE).asString()));
            VDBMetadataMapper.unwrapDomain(request, node);
            return request;
        }

        @Override
        public ModelNode describe(ModelNode node) {
            VDBMetadataMapper.addAttribute(node, EXECUTION_ID, ModelType.LONG, true);
            VDBMetadataMapper.addAttribute(node, SESSION_ID, ModelType.STRING, true);
            VDBMetadataMapper.addAttribute(node, START_TIME, ModelType.LONG, true);
            VDBMetadataMapper.addAttribute(node, COMMAND, ModelType.STRING, true);
            VDBMetadataMapper.addAttribute(node, SOURCE_REQUEST, ModelType.BOOLEAN, true);
            VDBMetadataMapper.addAttribute(node, NODE_ID, ModelType.INT, false);
            VDBMetadataMapper.addAttribute(node, TRANSACTION_ID, ModelType.STRING, false);
            VDBMetadataMapper.addAttribute(node, STATE, ModelType.STRING, true);
            VDBMetadataMapper.addAttribute(node, THREAD_STATE, ModelType.STRING, true);
            return node;
        }
    }

    public static class CacheStatisticsMetadataMapper
    implements MetadataMapper<CacheStatisticsMetadata> {
        private static final String HITRATIO = "hit-ratio";
        private static final String TOTAL_ENTRIES = "total-entries";
        private static final String REQUEST_COUNT = "request-count";
        public static CacheStatisticsMetadataMapper INSTANCE = new CacheStatisticsMetadataMapper();

        @Override
        public ModelNode wrap(CacheStatisticsMetadata object, ModelNode node) {
            if (object == null) {
                return null;
            }
            node.get(TOTAL_ENTRIES).set(object.getTotalEntries());
            node.get(HITRATIO).set(object.getHitRatio());
            node.get(REQUEST_COUNT).set(object.getRequestCount());
            VDBMetadataMapper.wrapDomain(object, node);
            return node;
        }

        @Override
        public CacheStatisticsMetadata unwrap(ModelNode node) {
            if (node == null) {
                return null;
            }
            CacheStatisticsMetadata cache = new CacheStatisticsMetadata();
            cache.setTotalEntries(node.get(TOTAL_ENTRIES).asInt());
            cache.setHitRatio(node.get(HITRATIO).asDouble());
            cache.setRequestCount(node.get(REQUEST_COUNT).asInt());
            VDBMetadataMapper.unwrapDomain(cache, node);
            return cache;
        }

        @Override
        public ModelNode describe(ModelNode node) {
            VDBMetadataMapper.addAttribute(node, TOTAL_ENTRIES, ModelType.STRING, true);
            VDBMetadataMapper.addAttribute(node, HITRATIO, ModelType.STRING, true);
            VDBMetadataMapper.addAttribute(node, REQUEST_COUNT, ModelType.STRING, true);
            return node;
        }
    }

    public static class PermissionMetaDataMapper
    implements MetadataMapper<DataPolicyMetadata.PermissionMetaData> {
        private static final String RESOURCE_NAME = "resource-name";
        private static final String ALLOW_CREATE = "allow-create";
        private static final String ALLOW_DELETE = "allow-delete";
        private static final String ALLOW_UPADTE = "allow-update";
        private static final String ALLOW_READ = "allow-read";
        private static final String ALLOW_EXECUTE = "allow-execute";
        private static final String ALLOW_ALTER = "allow-alter";
        public static PermissionMetaDataMapper INSTANCE = new PermissionMetaDataMapper();

        @Override
        public ModelNode wrap(DataPolicyMetadata.PermissionMetaData permission, ModelNode node) {
            if (permission == null) {
                return null;
            }
            node.get(RESOURCE_NAME).set(permission.getResourceName());
            if (permission.getAllowCreate() != null) {
                node.get(ALLOW_CREATE).set(permission.getAllowCreate().booleanValue());
            }
            if (permission.getAllowDelete() != null) {
                node.get(ALLOW_DELETE).set(permission.getAllowDelete().booleanValue());
            }
            if (permission.getAllowUpdate() != null) {
                node.get(ALLOW_UPADTE).set(permission.getAllowUpdate().booleanValue());
            }
            if (permission.getAllowRead() != null) {
                node.get(ALLOW_READ).set(permission.getAllowRead().booleanValue());
            }
            if (permission.getAllowExecute() != null) {
                node.get(ALLOW_EXECUTE).set(permission.getAllowExecute().booleanValue());
            }
            if (permission.getAllowAlter() != null) {
                node.get(ALLOW_ALTER).set(permission.getAllowAlter().booleanValue());
            }
            return node;
        }

        @Override
        public DataPolicyMetadata.PermissionMetaData unwrap(ModelNode node) {
            if (node == null) {
                return null;
            }
            DataPolicyMetadata.PermissionMetaData permission = new DataPolicyMetadata.PermissionMetaData();
            if (node.get(RESOURCE_NAME) != null) {
                permission.setResourceName(node.get(RESOURCE_NAME).asString());
            }
            if (node.has(ALLOW_CREATE)) {
                permission.setAllowCreate(node.get(ALLOW_CREATE).asBoolean());
            }
            if (node.has(ALLOW_DELETE)) {
                permission.setAllowDelete(node.get(ALLOW_DELETE).asBoolean());
            }
            if (node.has(ALLOW_UPADTE)) {
                permission.setAllowUpdate(node.get(ALLOW_UPADTE).asBoolean());
            }
            if (node.has(ALLOW_READ)) {
                permission.setAllowRead(node.get(ALLOW_READ).asBoolean());
            }
            if (node.has(ALLOW_EXECUTE)) {
                permission.setAllowExecute(node.get(ALLOW_EXECUTE).asBoolean());
            }
            if (node.has(ALLOW_ALTER)) {
                permission.setAllowAlter(node.get(ALLOW_ALTER).asBoolean());
            }
            return permission;
        }

        @Override
        public ModelNode describe(ModelNode node) {
            VDBMetadataMapper.addAttribute(node, RESOURCE_NAME, ModelType.STRING, true);
            VDBMetadataMapper.addAttribute(node, ALLOW_CREATE, ModelType.BOOLEAN, false);
            VDBMetadataMapper.addAttribute(node, ALLOW_DELETE, ModelType.BOOLEAN, false);
            VDBMetadataMapper.addAttribute(node, ALLOW_UPADTE, ModelType.BOOLEAN, false);
            VDBMetadataMapper.addAttribute(node, ALLOW_READ, ModelType.BOOLEAN, false);
            VDBMetadataMapper.addAttribute(node, ALLOW_EXECUTE, ModelType.BOOLEAN, false);
            VDBMetadataMapper.addAttribute(node, ALLOW_ALTER, ModelType.BOOLEAN, false);
            return node;
        }
    }

    public static class DataPolicyMetadataMapper
    implements MetadataMapper<DataPolicyMetadata> {
        private static final String POLICY_NAME = "policy-name";
        private static final String DATA_PERMISSIONS = "data-permissions";
        private static final String MAPPED_ROLE_NAMES = "mapped-role-names";
        private static final String ALLOW_CREATE_TEMP_TABLES = "allow-create-temp-tables";
        private static final String ANY_AUTHENTICATED = "any-authenticated";
        private static final String ALLOW_CREATE = "allow-create";
        private static final String ALLOW_READ = "allow-read";
        private static final String ALLOW_UPDATE = "allow-update";
        private static final String ALLOW_DELETE = "allow-delete";
        private static final String ALLOW_EXECUTE = "allow-execute";
        private static final String ALLOW_ALTER = "allow-alter";
        private static final String POLICY_DESCRIPTION = "policy-description";
        public static DataPolicyMetadataMapper INSTANCE = new DataPolicyMetadataMapper();

        @Override
        public ModelNode wrap(DataPolicyMetadata policy, ModelNode node) {
            if (policy == null) {
                return null;
            }
            node.get(POLICY_NAME).set(policy.getName());
            if (policy.getDescription() != null) {
                node.get(POLICY_DESCRIPTION).set(policy.getDescription());
            }
            if (policy.isAllowCreateTemporaryTables() != null) {
                node.get(ALLOW_CREATE_TEMP_TABLES).set(policy.isAllowCreateTemporaryTables().booleanValue());
            }
            node.get(ANY_AUTHENTICATED).set(policy.isAnyAuthenticated());
            List<DataPolicy.DataPermission> permissions = policy.getPermissions();
            if (permissions != null && !permissions.isEmpty()) {
                ModelNode permissionNodes = node.get(DATA_PERMISSIONS);
                for (DataPolicy.DataPermission dataPermission : permissions) {
                    permissionNodes.add(PermissionMetaDataMapper.INSTANCE.wrap((DataPolicyMetadata.PermissionMetaData)dataPermission, new ModelNode()));
                }
            }
            if (policy.getMappedRoleNames() != null && !policy.getMappedRoleNames().isEmpty()) {
                ModelNode mappedRoleNodes = node.get(MAPPED_ROLE_NAMES);
                for (String role : policy.getMappedRoleNames()) {
                    mappedRoleNodes.add(role);
                }
            }
            return node;
        }

        @Override
        public DataPolicyMetadata unwrap(ModelNode node) {
            if (node == null) {
                return null;
            }
            DataPolicyMetadata policy = new DataPolicyMetadata();
            if (node.has(POLICY_NAME)) {
                policy.setName(node.get(POLICY_NAME).asString());
            }
            if (node.has(POLICY_DESCRIPTION)) {
                policy.setDescription(node.get(POLICY_DESCRIPTION).asString());
            }
            if (node.has(ALLOW_CREATE_TEMP_TABLES)) {
                policy.setAllowCreateTemporaryTables(node.get(ALLOW_CREATE_TEMP_TABLES).asBoolean());
            }
            if (node.has(ANY_AUTHENTICATED)) {
                policy.setAnyAuthenticated(node.get(ANY_AUTHENTICATED).asBoolean());
            }
            if (node.get(DATA_PERMISSIONS).isDefined()) {
                List permissionNodes = node.get(DATA_PERMISSIONS).asList();
                for (ModelNode permissionNode : permissionNodes) {
                    DataPolicyMetadata.PermissionMetaData permission = PermissionMetaDataMapper.INSTANCE.unwrap(permissionNode);
                    if (permission == null) continue;
                    policy.addPermission(permission);
                }
            }
            if (node.get(MAPPED_ROLE_NAMES).isDefined()) {
                List roleNameNodes = node.get(MAPPED_ROLE_NAMES).asList();
                for (ModelNode roleNameNode : roleNameNodes) {
                    policy.addMappedRoleName(roleNameNode.asString());
                }
            }
            return policy;
        }

        @Override
        public ModelNode describe(ModelNode node) {
            VDBMetadataMapper.addAttribute(node, POLICY_NAME, ModelType.STRING, true);
            VDBMetadataMapper.addAttribute(node, POLICY_DESCRIPTION, ModelType.STRING, false);
            VDBMetadataMapper.addAttribute(node, ALLOW_CREATE_TEMP_TABLES, ModelType.BOOLEAN, false);
            VDBMetadataMapper.addAttribute(node, ANY_AUTHENTICATED, ModelType.BOOLEAN, false);
            ModelNode permissions = node.get(DATA_PERMISSIONS);
            permissions.get(VDBMetadataMapper.TYPE).set(ModelType.LIST);
            permissions.get(VDBMetadataMapper.DESCRIPTION).set(AdminPlugin.Util.getString("data-permissions.describe"));
            ModelNode create = permissions.get(new String[]{VDBMetadataMapper.VALUE_TYPE, ALLOW_CREATE});
            create.get(VDBMetadataMapper.DESCRIPTION).set(AdminPlugin.Util.getString("allow-create.describe"));
            create.get(VDBMetadataMapper.TYPE).set(ModelType.STRING);
            ModelNode read = permissions.get(new String[]{VDBMetadataMapper.VALUE_TYPE, ALLOW_READ});
            read.get(VDBMetadataMapper.DESCRIPTION).set(AdminPlugin.Util.getString("allow-read.describe"));
            read.get(VDBMetadataMapper.TYPE).set(ModelType.STRING);
            ModelNode update = permissions.get(new String[]{VDBMetadataMapper.VALUE_TYPE, ALLOW_UPDATE});
            update.get(VDBMetadataMapper.DESCRIPTION).set(AdminPlugin.Util.getString("allow-update.describe"));
            update.get(VDBMetadataMapper.TYPE).set(ModelType.STRING);
            ModelNode delete = permissions.get(new String[]{VDBMetadataMapper.VALUE_TYPE, ALLOW_DELETE});
            delete.get(VDBMetadataMapper.DESCRIPTION).set(AdminPlugin.Util.getString("allow-delete.describe"));
            delete.get(VDBMetadataMapper.TYPE).set(ModelType.STRING);
            ModelNode execute = permissions.get(new String[]{VDBMetadataMapper.VALUE_TYPE, ALLOW_EXECUTE});
            execute.get(VDBMetadataMapper.DESCRIPTION).set(AdminPlugin.Util.getString("allow-execute.describe"));
            execute.get(VDBMetadataMapper.TYPE).set(ModelType.STRING);
            ModelNode alter = permissions.get(new String[]{VDBMetadataMapper.VALUE_TYPE, ALLOW_ALTER});
            alter.get(VDBMetadataMapper.DESCRIPTION).set(AdminPlugin.Util.getString("allow-alter.describe"));
            alter.get(VDBMetadataMapper.TYPE).set(ModelType.STRING);
            ModelNode roleNames = node.get(MAPPED_ROLE_NAMES);
            roleNames.get(VDBMetadataMapper.TYPE).set(ModelType.LIST);
            roleNames.get(VDBMetadataMapper.DESCRIPTION).set(AdminPlugin.Util.getString("mapped-role-names.describe"));
            roleNames.get(VDBMetadataMapper.VALUE_TYPE).set(ModelType.STRING);
            return node;
        }
    }

    public static class PropertyMetaDataMapper
    implements MetadataMapper<PropertyMetadata> {
        private static final String PROPERTY_NAME = "property-name";
        private static final String PROPERTY_VALUE = "property-value";
        public static PropertyMetaDataMapper INSTANCE = new PropertyMetaDataMapper();

        @Override
        public ModelNode wrap(PropertyMetadata property, ModelNode node) {
            if (property == null) {
                return null;
            }
            node.get(PROPERTY_NAME).set(property.getName());
            node.get(PROPERTY_VALUE).set(property.getValue());
            return node;
        }

        @Override
        public PropertyMetadata unwrap(ModelNode node) {
            if (node == null) {
                return null;
            }
            PropertyMetadata property = new PropertyMetadata();
            if (node.has(PROPERTY_NAME)) {
                property.setName(node.get(PROPERTY_NAME).asString());
            }
            if (node.has(PROPERTY_VALUE)) {
                property.setValue(node.get(PROPERTY_VALUE).asString());
            }
            return property;
        }

        @Override
        public ModelNode describe(ModelNode node) {
            VDBMetadataMapper.addAttribute(node, PROPERTY_NAME, ModelType.STRING, true);
            VDBMetadataMapper.addAttribute(node, PROPERTY_VALUE, ModelType.STRING, true);
            return node;
        }
    }

    public static class VDBTranslatorMetaDataMapper
    implements MetadataMapper<VDBTranslatorMetaData> {
        private static final String TRANSLATOR_NAME = "translator-name";
        private static final String BASETYPE = "base-type";
        private static final String TRANSLATOR_DESCRIPTION = "translator-description";
        private static final String PROPERTIES = "properties";
        private static final String MODULE_NAME = "module-name";
        public static VDBTranslatorMetaDataMapper INSTANCE = new VDBTranslatorMetaDataMapper();

        @Override
        public ModelNode wrap(VDBTranslatorMetaData translator, ModelNode node) {
            List<PropertyMetadata> properties;
            if (translator == null) {
                return null;
            }
            node.get(TRANSLATOR_NAME).set(translator.getName());
            if (translator.getType() != null) {
                node.get(BASETYPE).set(translator.getType());
            }
            if (translator.getDescription() != null) {
                node.get(TRANSLATOR_DESCRIPTION).set(translator.getDescription());
            }
            if (translator.getModuleName() != null) {
                node.get(MODULE_NAME).set(translator.getModuleName());
            }
            if ((properties = translator.getJAXBProperties()) != null && !properties.isEmpty()) {
                ModelNode propsNode = node.get("properties");
                for (PropertyMetadata prop : properties) {
                    propsNode.add(PropertyMetaDataMapper.INSTANCE.wrap(prop, new ModelNode()));
                }
            }
            VDBMetadataMapper.wrapDomain(translator, node);
            return node;
        }

        @Override
        public VDBTranslatorMetaData unwrap(ModelNode node) {
            if (node == null) {
                return null;
            }
            VDBTranslatorMetaData translator = new VDBTranslatorMetaData();
            if (node.has(TRANSLATOR_NAME)) {
                translator.setName(node.get(TRANSLATOR_NAME).asString());
            }
            if (node.has(BASETYPE)) {
                translator.setType(node.get(BASETYPE).asString());
            }
            if (node.has(TRANSLATOR_DESCRIPTION)) {
                translator.setDescription(node.get(TRANSLATOR_DESCRIPTION).asString());
            }
            if (node.has(MODULE_NAME)) {
                translator.setModuleName(node.get(MODULE_NAME).asString());
            }
            if (node.get("properties").isDefined()) {
                List propNodes = node.get("properties").asList();
                for (ModelNode propNode : propNodes) {
                    PropertyMetadata prop = PropertyMetaDataMapper.INSTANCE.unwrap(propNode);
                    if (prop == null) continue;
                    translator.addProperty(prop.getName(), prop.getValue());
                }
            }
            VDBMetadataMapper.unwrapDomain(translator, node);
            return translator;
        }

        @Override
        public ModelNode describe(ModelNode node) {
            VDBMetadataMapper.addAttribute(node, TRANSLATOR_NAME, ModelType.STRING, true);
            VDBMetadataMapper.addAttribute(node, BASETYPE, ModelType.STRING, true);
            VDBMetadataMapper.addAttribute(node, TRANSLATOR_DESCRIPTION, ModelType.STRING, false);
            VDBMetadataMapper.addAttribute(node, MODULE_NAME, ModelType.STRING, false);
            ModelNode props = node.get("properties");
            props.get(VDBMetadataMapper.TYPE).set(ModelType.LIST);
            props.get(VDBMetadataMapper.DESCRIPTION).set(AdminPlugin.Util.getString("properties.describe"));
            PropertyMetaDataMapper.INSTANCE.describe(props.get(VDBMetadataMapper.VALUE_TYPE));
            return node;
        }
    }

    public static class SourceMappingMetadataMapper
    implements MetadataMapper<SourceMappingMetadata> {
        private static final String SOURCE_NAME = "source-name";
        private static final String JNDI_NAME = "jndi-name";
        private static final String TRANSLATOR_NAME = "translator-name";
        public static SourceMappingMetadataMapper INSTANCE = new SourceMappingMetadataMapper();

        @Override
        public ModelNode wrap(SourceMappingMetadata source, ModelNode node) {
            if (source == null) {
                return null;
            }
            node.get(SOURCE_NAME).set(source.getName());
            node.get(JNDI_NAME).set(source.getConnectionJndiName());
            node.get(TRANSLATOR_NAME).set(source.getTranslatorName());
            return node;
        }

        @Override
        public SourceMappingMetadata unwrap(ModelNode node) {
            if (node == null) {
                return null;
            }
            SourceMappingMetadata source = new SourceMappingMetadata();
            if (node.has(SOURCE_NAME)) {
                source.setName(node.get(SOURCE_NAME).asString());
            }
            if (node.has(JNDI_NAME)) {
                source.setConnectionJndiName(node.get(JNDI_NAME).asString());
            }
            if (node.has(TRANSLATOR_NAME)) {
                source.setTranslatorName(node.get(TRANSLATOR_NAME).asString());
            }
            return source;
        }

        @Override
        public ModelNode describe(ModelNode node) {
            VDBMetadataMapper.addAttribute(node, SOURCE_NAME, ModelType.STRING, true);
            VDBMetadataMapper.addAttribute(node, JNDI_NAME, ModelType.STRING, true);
            VDBMetadataMapper.addAttribute(node, TRANSLATOR_NAME, ModelType.STRING, true);
            return node;
        }
    }

    public static class ValidationErrorMapper
    implements MetadataMapper<ModelMetaData.ValidationError> {
        private static final String ERROR_PATH = "error-path";
        private static final String SEVERITY = "severity";
        private static final String MESSAGE = "message";
        public static ValidationErrorMapper INSTANCE = new ValidationErrorMapper();

        @Override
        public ModelNode wrap(ModelMetaData.ValidationError error, ModelNode node) {
            if (error == null) {
                return null;
            }
            if (error.getPath() != null) {
                node.get(ERROR_PATH).set(error.getPath());
            }
            node.get(SEVERITY).set(error.getSeverity());
            node.get(MESSAGE).set(error.getValue());
            return node;
        }

        @Override
        public ModelMetaData.ValidationError unwrap(ModelNode node) {
            if (node == null) {
                return null;
            }
            ModelMetaData.ValidationError error = new ModelMetaData.ValidationError();
            if (node.has(ERROR_PATH)) {
                error.setPath(node.get(ERROR_PATH).asString());
            }
            if (node.has(SEVERITY)) {
                error.setSeverity(node.get(SEVERITY).asString());
            }
            if (node.has(MESSAGE)) {
                error.setValue(node.get(MESSAGE).asString());
            }
            return error;
        }

        @Override
        public ModelNode describe(ModelNode node) {
            VDBMetadataMapper.addAttribute(node, ERROR_PATH, ModelType.STRING, false);
            VDBMetadataMapper.addAttribute(node, SEVERITY, ModelType.STRING, true);
            VDBMetadataMapper.addAttribute(node, MESSAGE, ModelType.STRING, true);
            return node;
        }
    }

    public static class ModelMetadataMapper
    implements MetadataMapper<ModelMetaData> {
        private static final String MODEL_NAME = "model-name";
        private static final String DESCRIPTION = "description";
        private static final String VISIBLE = "visible";
        private static final String MODEL_TYPE = "model-type";
        private static final String MODELPATH = "model-path";
        private static final String PROPERTIES = "properties";
        private static final String SOURCE_MAPPINGS = "source-mappings";
        private static final String VALIDITY_ERRORS = "validity-errors";
        private static final String METADATA = "metadata";
        private static final String METADATA_TYPE = "metadata-type";
        public static ModelMetadataMapper INSTANCE = new ModelMetadataMapper();

        @Override
        public ModelNode wrap(ModelMetaData model, ModelNode node) {
            List<ModelMetaData.ValidationError> errors;
            List<SourceMappingMetadata> sources;
            List<PropertyMetadata> properties;
            if (model == null) {
                return null;
            }
            node.get(MODEL_NAME).set(model.getName());
            if (model.getDescription() != null) {
                node.get("description").set(model.getDescription());
            }
            node.get(VISIBLE).set(model.isVisible());
            node.get(MODEL_TYPE).set(model.getModelType().toString());
            if (model.getPath() != null) {
                node.get(MODELPATH).set(model.getPath());
            }
            if ((properties = model.getJAXBProperties()) != null && !properties.isEmpty()) {
                ModelNode propsNode = node.get("properties");
                for (PropertyMetadata prop : properties) {
                    propsNode.add(PropertyMetaDataMapper.INSTANCE.wrap(prop, new ModelNode()));
                }
            }
            if ((sources = model.getSourceMappings()) != null && !sources.isEmpty()) {
                ModelNode sourceMappingNode = node.get(SOURCE_MAPPINGS);
                for (SourceMappingMetadata source : sources) {
                    sourceMappingNode.add(SourceMappingMetadataMapper.INSTANCE.wrap(source, new ModelNode()));
                }
            }
            if ((errors = model.getErrors()) != null && !errors.isEmpty()) {
                ModelNode errorsNode = node.get(VALIDITY_ERRORS);
                for (ModelMetaData.ValidationError error : errors) {
                    errorsNode.add(ValidationErrorMapper.INSTANCE.wrap(error, new ModelNode()));
                }
            }
            if (model.getSchemaText() != null) {
                node.get(METADATA).set(model.getSchemaText());
            }
            if (model.getSchemaSourceType() != null) {
                node.get(METADATA_TYPE).set(model.getSchemaSourceType());
            }
            return node;
        }

        @Override
        public ModelMetaData unwrap(ModelNode node) {
            if (node == null) {
                return null;
            }
            ModelMetaData model = new ModelMetaData();
            if (node.has(MODEL_NAME)) {
                model.setName(node.get(MODEL_NAME).asString());
            }
            if (node.has("description")) {
                model.setDescription(node.get("description").asString());
            }
            if (node.has(VISIBLE)) {
                model.setVisible(node.get(VISIBLE).asBoolean());
            }
            if (node.has(MODEL_TYPE)) {
                model.setModelType(node.get(MODEL_TYPE).asString());
            }
            if (node.has(MODELPATH)) {
                model.setPath(node.get(MODELPATH).asString());
            }
            if (node.get("properties").isDefined()) {
                List propNodes = node.get("properties").asList();
                for (ModelNode propNode : propNodes) {
                    PropertyMetadata prop = PropertyMetaDataMapper.INSTANCE.unwrap(propNode);
                    if (prop == null) continue;
                    model.addProperty(prop.getName(), prop.getValue());
                }
            }
            if (node.get(SOURCE_MAPPINGS).isDefined()) {
                List sourceMappingNodes = node.get(SOURCE_MAPPINGS).asList();
                for (ModelNode sourceMapping : sourceMappingNodes) {
                    SourceMappingMetadata source = SourceMappingMetadataMapper.INSTANCE.unwrap(sourceMapping);
                    if (source == null) continue;
                    model.addSourceMapping(source);
                }
            }
            if (node.get(VALIDITY_ERRORS).isDefined()) {
                List errorNodes = node.get(VALIDITY_ERRORS).asList();
                for (ModelNode errorNode : errorNodes) {
                    ModelMetaData.ValidationError error = ValidationErrorMapper.INSTANCE.unwrap(errorNode);
                    if (error == null) continue;
                    model.addError(error);
                }
            }
            if (node.get(METADATA).isDefined()) {
                model.setSchemaText(node.get(METADATA).asString());
            }
            if (node.get(METADATA_TYPE).isDefined()) {
                model.setSchemaSourceType(node.get(METADATA_TYPE).asString());
            }
            return model;
        }

        @Override
        public ModelNode describe(ModelNode node) {
            ModelNode modelTypes = new ModelNode();
            modelTypes.add(Model.Type.PHYSICAL.toString());
            modelTypes.add(Model.Type.VIRTUAL.toString());
            modelTypes.add(Model.Type.FUNCTION.toString());
            modelTypes.add(Model.Type.OTHER.toString());
            VDBMetadataMapper.addAttribute(node, MODEL_NAME, ModelType.STRING, true);
            node.get(MODEL_NAME).get(VDBMetadataMapper.ALLOWED).set(modelTypes);
            VDBMetadataMapper.addAttribute(node, "description", ModelType.STRING, false);
            VDBMetadataMapper.addAttribute(node, VISIBLE, ModelType.BOOLEAN, false);
            VDBMetadataMapper.addAttribute(node, MODEL_TYPE, ModelType.STRING, true);
            VDBMetadataMapper.addAttribute(node, MODELPATH, ModelType.STRING, false);
            ModelNode props = node.get("properties");
            props.get(VDBMetadataMapper.TYPE).set(ModelType.LIST);
            props.get("description").set(AdminPlugin.Util.getString("properties.describe"));
            PropertyMetaDataMapper.INSTANCE.describe(props.get(VDBMetadataMapper.VALUE_TYPE));
            ModelNode source = node.get(SOURCE_MAPPINGS);
            source.get(VDBMetadataMapper.TYPE).set(ModelType.LIST);
            source.get("description").set(AdminPlugin.Util.getString("source-mappings.describe"));
            SourceMappingMetadataMapper.INSTANCE.describe(source.get(VDBMetadataMapper.VALUE_TYPE));
            ModelNode errors = node.get(VALIDITY_ERRORS);
            errors.get(VDBMetadataMapper.TYPE).set(ModelType.LIST);
            errors.get("description").set(AdminPlugin.Util.getString("validity-errors.describe"));
            ValidationErrorMapper.INSTANCE.describe(errors.get(VDBMetadataMapper.VALUE_TYPE));
            return node;
        }
    }
}

