/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.adminapi.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.teiid.adminapi.AdminPlugin;
import org.teiid.adminapi.DataPolicy;
import org.teiid.adminapi.Translator;
import org.teiid.adminapi.impl.AdminObjectImpl;
import org.teiid.adminapi.impl.DataPolicyMetadata;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.SourceMappingMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBTranslatorMetaData;
import org.teiid.core.types.XMLType;

public class VDBMetadataParser {
    public static VDBMetaData unmarshell(InputStream content) throws XMLStreamException {
        XMLInputFactory inputFactory = XMLType.getXmlInputFactory();
        XMLStreamReader reader = inputFactory.createXMLStreamReader(content);
        if (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case VDB: {
                    VDBMetaData vdb = new VDBMetaData();
                    Properties props = VDBMetadataParser.getAttributes(reader);
                    vdb.setName(props.getProperty(Element.NAME.getLocalName()));
                    vdb.setVersion(Integer.parseInt(props.getProperty(Element.VERSION.getLocalName())));
                    VDBMetadataParser.parseVDB(reader, vdb);
                    return vdb;
                }
            }
            throw new XMLStreamException(AdminPlugin.Util.gs("unexpected_element1", new Object[]{reader.getName(), Element.VDB.getLocalName()}), reader.getLocation());
        }
        return null;
    }

    private static void parseVDB(XMLStreamReader reader, VDBMetaData vdb) throws XMLStreamException {
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case DESCRIPTION: {
                    vdb.setDescription(reader.getElementText());
                    continue block8;
                }
                case PROPERTY: {
                    VDBMetadataParser.parseProperty(reader, vdb);
                    continue block8;
                }
                case MODEL: {
                    ModelMetaData model = new ModelMetaData();
                    VDBMetadataParser.parseModel(reader, model);
                    vdb.addModel(model);
                    continue block8;
                }
                case TRANSLATOR: {
                    VDBTranslatorMetaData translator = new VDBTranslatorMetaData();
                    VDBMetadataParser.parseTranslator(reader, translator);
                    vdb.addOverideTranslator(translator);
                    continue block8;
                }
                case DATA_ROLE: {
                    DataPolicyMetadata policy = new DataPolicyMetadata();
                    VDBMetadataParser.parseDataRole(reader, policy);
                    vdb.addDataPolicy(policy);
                    continue block8;
                }
                case ENTRY: {
                    continue block8;
                }
            }
            throw new XMLStreamException(AdminPlugin.Util.gs("unexpected_element5", new Object[]{reader.getName(), Element.DESCRIPTION.getLocalName(), Element.PROPERTY.getLocalName(), Element.MODEL.getLocalName(), Element.TRANSLATOR.getLocalName(), Element.DATA_ROLE.getLocalName()}), reader.getLocation());
        }
    }

    private static void parseProperty(XMLStreamReader reader, AdminObjectImpl anObj) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            String key = null;
            String value = null;
            for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                if (attrName.equals(Element.NAME.getLocalName())) {
                    key = attrValue;
                }
                if (!attrName.equals(Element.VALUE.getLocalName())) continue;
                value = attrValue;
            }
            anObj.addProperty(key, value);
        }
        while (reader.nextTag() != 2) {
        }
    }

    private static void parseDataRole(XMLStreamReader reader, DataPolicyMetadata policy) throws XMLStreamException {
        Properties props = VDBMetadataParser.getAttributes(reader);
        policy.setName(props.getProperty(Element.NAME.getLocalName()));
        policy.setAnyAuthenticated(Boolean.parseBoolean(props.getProperty(Element.DATA_ROLE_ANY_ATHENTICATED_ATTR.getLocalName())));
        policy.setAllowCreateTemporaryTables(Boolean.parseBoolean(props.getProperty(Element.DATA_ROLE_ALLOW_TEMP_TABLES_ATTR.getLocalName())));
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case DESCRIPTION: {
                    policy.setDescription(reader.getElementText());
                    continue block5;
                }
                case PERMISSION: {
                    DataPolicyMetadata.PermissionMetaData permission = new DataPolicyMetadata.PermissionMetaData();
                    VDBMetadataParser.parsePermission(reader, permission);
                    policy.addPermission(permission);
                    continue block5;
                }
                case MAPPED_ROLE_NAME: {
                    policy.addMappedRoleName(reader.getElementText());
                    continue block5;
                }
            }
            throw new XMLStreamException(AdminPlugin.Util.gs("unexpected_element2", new Object[]{reader.getName(), Element.DESCRIPTION.getLocalName(), Element.PERMISSION.getLocalName(), Element.MAPPED_ROLE_NAME.getLocalName()}), reader.getLocation());
        }
    }

    private static void parsePermission(XMLStreamReader reader, DataPolicyMetadata.PermissionMetaData permission) throws XMLStreamException {
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case RESOURCE_NAME: {
                    permission.setResourceName(reader.getElementText());
                    continue block9;
                }
                case ALLOW_ALTER: {
                    permission.setAllowAlter(Boolean.parseBoolean(reader.getElementText()));
                    continue block9;
                }
                case ALLOW_CREATE: {
                    permission.setAllowCreate(Boolean.parseBoolean(reader.getElementText()));
                    continue block9;
                }
                case ALLOW_DELETE: {
                    permission.setAllowDelete(Boolean.parseBoolean(reader.getElementText()));
                    continue block9;
                }
                case ALLOW_EXECUTE: {
                    permission.setAllowExecute(Boolean.parseBoolean(reader.getElementText()));
                    continue block9;
                }
                case ALLOW_READ: {
                    permission.setAllowRead(Boolean.parseBoolean(reader.getElementText()));
                    continue block9;
                }
                case ALLOW_UPADTE: {
                    permission.setAllowUpdate(Boolean.parseBoolean(reader.getElementText()));
                    continue block9;
                }
            }
            throw new XMLStreamException(AdminPlugin.Util.gs("unexpected_element7", new Object[]{reader.getName(), Element.RESOURCE_NAME.getLocalName(), Element.ALLOW_ALTER.getLocalName(), Element.ALLOW_CREATE.getLocalName(), Element.ALLOW_DELETE.getLocalName(), Element.ALLOW_EXECUTE.getLocalName(), Element.ALLOW_READ.getLocalName(), Element.ALLOW_UPADTE}), reader.getLocation());
        }
    }

    private static void parseTranslator(XMLStreamReader reader, VDBTranslatorMetaData translator) throws XMLStreamException {
        Properties props = VDBMetadataParser.getAttributes(reader);
        translator.setName(props.getProperty(Element.NAME.getLocalName()));
        translator.setType(props.getProperty(Element.TYPE.getLocalName()));
        translator.setDescription(props.getProperty(Element.DESCRIPTION.getLocalName()));
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTY: {
                    VDBMetadataParser.parseProperty(reader, translator);
                    continue block3;
                }
            }
            throw new XMLStreamException(AdminPlugin.Util.gs("unexpected_element1", new Object[]{reader.getName(), Element.PROPERTY.getLocalName()}), reader.getLocation());
        }
    }

    private static void parseModel(XMLStreamReader reader, ModelMetaData model) throws XMLStreamException {
        Properties props = VDBMetadataParser.getAttributes(reader);
        model.setName(props.getProperty(Element.NAME.getLocalName()));
        model.setModelType(props.getProperty(Element.TYPE.getLocalName(), "PHYSICAL"));
        model.setVisible(Boolean.parseBoolean(props.getProperty(Element.VISIBLE.getLocalName(), "true")));
        model.setPath(props.getProperty(Element.PATH.getLocalName()));
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case DESCRIPTION: {
                    model.setDescription(reader.getElementText());
                    continue block7;
                }
                case PROPERTY: {
                    VDBMetadataParser.parseProperty(reader, model);
                    continue block7;
                }
                case SOURCE: {
                    Properties sourceProps = VDBMetadataParser.getAttributes(reader);
                    String name = sourceProps.getProperty(Element.NAME.getLocalName());
                    String translatorName = sourceProps.getProperty(Element.SOURCE_TRANSLATOR_NAME_ATTR.getLocalName());
                    String connectionName = sourceProps.getProperty(Element.SOURCE_CONNECTION_JNDI_NAME_ATTR.getLocalName());
                    model.addSourceMapping(name, translatorName, connectionName);
                    while (reader.nextTag() != 2) {
                    }
                    continue block7;
                }
                case VALIDATION_ERROR: {
                    Properties validationProps = VDBMetadataParser.getAttributes(reader);
                    String msg = reader.getElementText();
                    String severity = validationProps.getProperty(Element.VALIDATION_SEVERITY_ATTR.getLocalName());
                    String path = validationProps.getProperty(Element.PATH.getLocalName());
                    ModelMetaData.ValidationError ve = new ModelMetaData.ValidationError(severity, msg);
                    ve.setPath(path);
                    model.addError(ve);
                    continue block7;
                }
                case METADATA: {
                    Properties metdataProps = VDBMetadataParser.getAttributes(reader);
                    String type = metdataProps.getProperty(Element.TYPE.getLocalName(), "DDL");
                    String schema = reader.getElementText();
                    model.setSchemaSourceType(type);
                    model.setSchemaText(schema);
                    continue block7;
                }
            }
            throw new XMLStreamException(AdminPlugin.Util.gs("unexpected_element5", new Object[]{reader.getName(), Element.DESCRIPTION.getLocalName(), Element.PROPERTY.getLocalName(), Element.SOURCE.getLocalName(), Element.METADATA.getLocalName(), Element.VALIDATION_ERROR.getLocalName()}), reader.getLocation());
        }
    }

    private static Properties getAttributes(XMLStreamReader reader) {
        Properties props = new Properties();
        if (reader.getAttributeCount() > 0) {
            for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                props.setProperty(attrName, attrValue);
            }
        }
        return props;
    }

    public static void marshell(VDBMetaData vdb, OutputStream out) throws XMLStreamException, IOException {
        XMLStreamWriter writer = XMLOutputFactory.newFactory().createXMLStreamWriter(out);
        writer.writeStartDocument();
        writer.writeStartElement(Element.VDB.getLocalName());
        writer.writeAttribute(Element.NAME.getLocalName(), vdb.getName());
        writer.writeAttribute(Element.VERSION.getLocalName(), String.valueOf(vdb.getVersion()));
        if (vdb.getDescription() != null) {
            VDBMetadataParser.writeElement(writer, Element.DESCRIPTION, vdb.getDescription());
        }
        VDBMetadataParser.writeProperties(writer, vdb.getProperties());
        Collection<ModelMetaData> models = vdb.getModelMetaDatas().values();
        for (ModelMetaData model : models) {
            VDBMetadataParser.writeModel(writer, model);
        }
        for (Translator translator : vdb.getOverrideTranslators()) {
            VDBMetadataParser.writeTranslator(writer, translator);
        }
        for (DataPolicy dp : vdb.getDataPolicies()) {
            VDBMetadataParser.writeDataPolicy(writer, dp);
        }
        writer.writeEndElement();
        writer.writeEndDocument();
        writer.close();
        out.close();
    }

    private static void writeDataPolicy(XMLStreamWriter writer, DataPolicy dp) throws XMLStreamException {
        writer.writeStartElement(Element.DATA_ROLE.getLocalName());
        writer.writeAttribute(Element.NAME.getLocalName(), dp.getName());
        writer.writeAttribute(Element.DATA_ROLE_ANY_ATHENTICATED_ATTR.getLocalName(), String.valueOf(dp.isAnyAuthenticated()));
        writer.writeAttribute(Element.DATA_ROLE_ALLOW_TEMP_TABLES_ATTR.getLocalName(), String.valueOf(dp.isAllowCreateTemporaryTables()));
        VDBMetadataParser.writeElement(writer, Element.DESCRIPTION, dp.getDescription());
        for (DataPolicy.DataPermission permission : dp.getPermissions()) {
            writer.writeStartElement(Element.PERMISSION.getLocalName());
            VDBMetadataParser.writeElement(writer, Element.RESOURCE_NAME, permission.getResourceName());
            if (permission.getAllowCreate() != null) {
                VDBMetadataParser.writeElement(writer, Element.ALLOW_CREATE, permission.getAllowCreate().toString());
            }
            if (permission.getAllowRead() != null) {
                VDBMetadataParser.writeElement(writer, Element.ALLOW_READ, permission.getAllowRead().toString());
            }
            if (permission.getAllowUpdate() != null) {
                VDBMetadataParser.writeElement(writer, Element.ALLOW_UPADTE, permission.getAllowUpdate().toString());
            }
            if (permission.getAllowDelete() != null) {
                VDBMetadataParser.writeElement(writer, Element.ALLOW_DELETE, permission.getAllowDelete().toString());
            }
            if (permission.getAllowExecute() != null) {
                VDBMetadataParser.writeElement(writer, Element.ALLOW_EXECUTE, permission.getAllowExecute().toString());
            }
            if (permission.getAllowAlter() != null) {
                VDBMetadataParser.writeElement(writer, Element.ALLOW_ALTER, permission.getAllowAlter().toString());
            }
            writer.writeEndElement();
        }
        for (String roleName : dp.getMappedRoleNames()) {
            VDBMetadataParser.writeElement(writer, Element.MAPPED_ROLE_NAME, roleName);
        }
        writer.writeEndElement();
    }

    private static void writeTranslator(XMLStreamWriter writer, Translator translator) throws XMLStreamException {
        writer.writeStartElement(Element.TRANSLATOR.getLocalName());
        writer.writeAttribute(Element.NAME.getLocalName(), translator.getName());
        writer.writeAttribute(Element.TYPE.getLocalName(), translator.getType());
        writer.writeAttribute(Element.DESCRIPTION.getLocalName(), translator.getDescription());
        VDBMetadataParser.writeProperties(writer, translator.getProperties());
        writer.writeEndElement();
    }

    private static void writeModel(XMLStreamWriter writer, ModelMetaData model) throws XMLStreamException {
        writer.writeStartElement(Element.MODEL.getLocalName());
        writer.writeAttribute(Element.NAME.getLocalName(), model.getName());
        writer.writeAttribute(Element.TYPE.getLocalName(), model.getModelType().name());
        writer.writeAttribute(Element.VISIBLE.getLocalName(), String.valueOf(model.isVisible()));
        if (model.getPath() != null) {
            writer.writeAttribute(Element.PATH.getLocalName(), model.getPath());
        }
        if (model.getDescription() != null) {
            VDBMetadataParser.writeElement(writer, Element.DESCRIPTION, model.getDescription());
        }
        VDBMetadataParser.writeProperties(writer, model.getProperties());
        for (SourceMappingMetadata source : model.getSourceMappings()) {
            writer.writeStartElement(Element.SOURCE.getLocalName());
            writer.writeAttribute(Element.NAME.getLocalName(), source.getName());
            writer.writeAttribute(Element.SOURCE_TRANSLATOR_NAME_ATTR.getLocalName(), source.getTranslatorName());
            writer.writeAttribute(Element.SOURCE_CONNECTION_JNDI_NAME_ATTR.getLocalName(), source.getConnectionJndiName());
            writer.writeEndElement();
        }
        if (model.getSchemaSourceType() != null) {
            writer.writeStartElement(Element.METADATA.getLocalName());
            writer.writeAttribute(Element.TYPE.getLocalName(), model.getSchemaSourceType());
            writer.writeCData(model.getSchemaText());
            writer.writeEndElement();
        }
        for (ModelMetaData.ValidationError ve : model.getErrors()) {
            writer.writeStartElement(Element.VALIDATION_ERROR.getLocalName());
            writer.writeAttribute(Element.VALIDATION_SEVERITY_ATTR.getLocalName(), ve.getSeverity());
            if (ve.getPath() != null) {
                writer.writeAttribute(Element.PATH.getLocalName(), ve.getPath());
            }
            writer.writeCharacters(ve.getValue());
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private static void writeProperties(XMLStreamWriter writer, Properties props) throws XMLStreamException {
        Enumeration<?> keys = props.propertyNames();
        while (keys.hasMoreElements()) {
            writer.writeStartElement(Element.PROPERTY.getLocalName());
            String key = (String)keys.nextElement();
            String value = props.getProperty(key);
            writer.writeAttribute(Element.NAME.getLocalName(), key);
            writer.writeAttribute(Element.VALUE.getLocalName(), value);
            writer.writeEndElement();
        }
    }

    private static void writeElement(XMLStreamWriter writer, Element element, String value) throws XMLStreamException {
        writer.writeStartElement(element.getLocalName());
        writer.writeCharacters(value);
        writer.writeEndElement();
    }

    private static void writeAttribute(XMLStreamWriter writer, Element element, String value) throws XMLStreamException {
        writer.writeAttribute(element.getLocalName(), value);
    }

    static enum Element {
        UNKNOWN(null),
        VDB("vdb"),
        NAME("name"),
        VERSION("version"),
        DESCRIPTION("description"),
        PROPERTY("property"),
        VALUE("value"),
        MODEL("model"),
        TYPE("type"),
        VISIBLE("visible"),
        PATH("path"),
        SOURCE("source"),
        SOURCE_TRANSLATOR_NAME_ATTR("translator-name"),
        SOURCE_CONNECTION_JNDI_NAME_ATTR("connection-jndi-name"),
        VALIDATION_ERROR("validation-error"),
        VALIDATION_SEVERITY_ATTR("severity"),
        TRANSLATOR("translator"),
        DATA_ROLE("data-role"),
        DATA_ROLE_ANY_ATHENTICATED_ATTR("any-authenticated"),
        DATA_ROLE_ALLOW_TEMP_TABLES_ATTR("allow-create-temporary-tables"),
        PERMISSION("permission"),
        RESOURCE_NAME("resource-name"),
        ALLOW_CREATE("allow-create"),
        ALLOW_READ("allow-read"),
        ALLOW_UPADTE("allow-update"),
        ALLOW_DELETE("allow-delete"),
        ALLOW_EXECUTE("allow-execute"),
        ALLOW_ALTER("allow-alter"),
        MAPPED_ROLE_NAME("mapped-role-name"),
        ENTRY("entry"),
        METADATA("metadata");

        private final String name;
        private static final Map<String, Element> elements;

        private Element(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public static Element forName(String localName) {
            Element element = elements.get(localName);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<String, Element> map = new HashMap<String, Element>();
            for (Element element : Element.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            elements = map;
        }
    }
}

