/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.language.visitor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.teiid.language.ColumnReference;
import org.teiid.language.LanguageObject;
import org.teiid.language.NamedTable;
import org.teiid.language.visitor.HierarchyVisitor;

public class CollectorVisitor<T>
extends HierarchyVisitor {
    private Class<T> type;
    private Collection<T> objects = new ArrayList<T>();

    public CollectorVisitor(Class<T> type) {
        this.type = type;
    }

    @Override
    public void visitNode(LanguageObject obj) {
        if (this.type.isInstance(obj)) {
            this.objects.add(obj);
        }
        super.visitNode(obj);
    }

    public Collection<T> getCollectedObjects() {
        return this.objects;
    }

    public static <T> Collection<T> collectObjects(Class<T> type, LanguageObject object) {
        CollectorVisitor<T> visitor = new CollectorVisitor<T>(type);
        visitor.visitNode(object);
        return visitor.getCollectedObjects();
    }

    public static Collection<ColumnReference> collectElements(LanguageObject object) {
        return CollectorVisitor.collectObjects(ColumnReference.class, object);
    }

    public static Collection<NamedTable> collectGroups(LanguageObject object) {
        return CollectorVisitor.collectObjects(NamedTable.class, object);
    }

    public static Set<NamedTable> collectGroupsUsedByElements(LanguageObject object) {
        HashSet<NamedTable> groups = new HashSet<NamedTable>();
        for (ColumnReference element : CollectorVisitor.collectElements(object)) {
            if (element.getTable() == null) continue;
            groups.add(element.getTable());
        }
        return groups;
    }
}

