/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.logging;

import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.teiid.logging.Logger;

public class JavaLogger
implements Logger {
    private ConcurrentHashMap<String, java.util.logging.Logger> loggers = new ConcurrentHashMap();

    @Override
    public boolean isEnabled(String context, int msgLevel) {
        java.util.logging.Logger logger = this.getLogger(context);
        Level javaLevel = this.convertLevel(msgLevel);
        return logger.isLoggable(javaLevel);
    }

    private java.util.logging.Logger getLogger(String context) {
        java.util.logging.Logger logger = this.loggers.get(context);
        if (logger == null) {
            logger = java.util.logging.Logger.getLogger(context);
            this.loggers.put(context, logger);
        }
        return logger;
    }

    @Override
    public void log(int level, String context, Object msg) {
        java.util.logging.Logger logger = this.getLogger(context);
        Level javaLevel = this.convertLevel(level);
        logger.log(javaLevel, msg.toString());
    }

    @Override
    public void log(int level, String context, Throwable t, Object msg) {
        java.util.logging.Logger logger = this.getLogger(context);
        Level javaLevel = this.convertLevel(level);
        logger.log(javaLevel, msg != null ? msg.toString() : null, t);
    }

    public Level convertLevel(int level) {
        switch (level) {
            case 1: 
            case 2: {
                return Level.SEVERE;
            }
            case 3: {
                return Level.WARNING;
            }
            case 4: {
                return Level.FINE;
            }
            case 5: {
                return Level.FINER;
            }
            case 6: {
                return Level.FINEST;
            }
        }
        return Level.ALL;
    }

    @Override
    public void shutdown() {
    }
}

