/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.spi;

import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Set;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import org.teiid.resource.spi.BasicManagedConnectionFactory;

public class ConnectionContext {
    private static ThreadLocal<Subject> SUBJECT = new ThreadLocal<Subject>(){

        @Override
        protected Subject initialValue() {
            return null;
        }
    };

    public static Subject getSubject() {
        return SUBJECT.get();
    }

    public static void setSubject(Subject subject) {
        SUBJECT.set(subject);
    }

    public static String getUserName(Subject subject, BasicManagedConnectionFactory mcf, String defalt) {
        Set<PasswordCredential> creds = subject.getPrivateCredentials(PasswordCredential.class);
        if (creds != null && creds.size() > 0) {
            for (PasswordCredential cred : creds) {
                if (!cred.getManagedConnectionFactory().equals((Object)mcf) || cred.getUserName() == null) continue;
                return cred.getUserName();
            }
        }
        return defalt;
    }

    public static String getPassword(Subject subject, BasicManagedConnectionFactory mcf, String userName, String defalt) {
        Set<PasswordCredential> creds = subject.getPrivateCredentials(PasswordCredential.class);
        if (creds != null && creds.size() > 0) {
            for (PasswordCredential cred : creds) {
                if (!cred.getManagedConnectionFactory().equals((Object)mcf) || !cred.getUserName().equals(userName) || cred.getPassword() == null) continue;
                return new String(cred.getPassword());
            }
        }
        return defalt;
    }

    public static String[] getRoles(Subject subject, String[] defalt) {
        ArrayList<String> roles = new ArrayList<String>();
        Set<Group> principals = subject.getPrincipals(Group.class);
        if (principals != null && principals.size() > 0) {
            for (Group group : principals) {
                if (!group.getName().equalsIgnoreCase("roles")) continue;
                Enumeration members = group.members();
                while (members.hasMoreElements()) {
                    Principal member = (Principal)members.nextElement();
                    roles.add(member.getName());
                }
            }
            return roles.toArray(new String[roles.size()]);
        }
        return defalt;
    }

    public static <T> T getSecurityCredential(Subject subject, Class<T> clazz) {
        Set<T> creds = subject.getPrivateCredentials(clazz);
        if (creds != null && creds.size() > 0) {
            return creds.iterator().next();
        }
        return null;
    }
}

