/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.cache.jboss;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.teiid.cache.Cache;
import org.teiid.cache.CacheListener;
import org.teiid.cache.jboss.JBossCacheListener;

public class JBossCache<K, V>
implements Cache<K, V> {
    private org.jboss.cache.Cache<K, V> cacheStore;
    private Fqn rootFqn;
    private JBossCacheListener cacheListener;

    public JBossCache(org.jboss.cache.Cache<K, V> cacheStore, Fqn fqn) {
        this.cacheStore = cacheStore;
        this.rootFqn = fqn;
    }

    public V get(K key) {
        return (V)this.cacheStore.get(this.rootFqn, key);
    }

    public V put(K key, V value) {
        return (V)this.cacheStore.put(this.rootFqn, key, value);
    }

    public V remove(K key) {
        return (V)this.cacheStore.remove(this.rootFqn, key);
    }

    public Set<K> keySet() {
        Node node = this.cacheStore.getRoot().getChild(this.rootFqn);
        if (node != null) {
            return node.getKeys();
        }
        return Collections.emptySet();
    }

    public int size() {
        Node node = this.cacheStore.getRoot().getChild(this.rootFqn);
        if (node != null) {
            return node.dataSize();
        }
        return 0;
    }

    public void clear() {
        Node node = this.cacheStore.getRoot().getChild(this.rootFqn);
        if (node != null) {
            node.clearData();
        }
    }

    public Collection<V> values() {
        Node node = this.cacheStore.getRoot().getChild(this.rootFqn);
        if (node != null) {
            return node.getData().values();
        }
        return Collections.emptyList();
    }

    public synchronized void addListener(CacheListener listener) {
        this.cacheListener = new JBossCacheListener(this.rootFqn, listener);
        this.cacheStore.addCacheListener((Object)this.cacheListener);
    }

    public synchronized void removeListener() {
        this.cacheStore.removeCacheListener((Object)this.cacheListener);
        this.cacheListener = null;
    }

    public Cache<K, V> addChild(String name) {
        Node<K, V> node = this.getRootNode();
        Node childNode = node.addChild(Fqn.fromString((String)name));
        return new JBossCache<K, V>(this.cacheStore, childNode.getFqn());
    }

    public Cache<K, V> getChild(String name) {
        Node<K, V> node = this.getRootNode();
        Node child = node.getChild(Fqn.fromString((String)name));
        if (child != null) {
            return new JBossCache<K, V>(this.cacheStore, child.getFqn());
        }
        return null;
    }

    private Node<K, V> getRootNode() {
        Node node = this.cacheStore.getNode(this.rootFqn);
        if (node == null) {
            throw new IllegalStateException("Cache Node " + this.rootFqn + " not found.");
        }
        return node;
    }

    public List<Cache> getChildren() {
        Node<K, V> node = this.getRootNode();
        Set nodes = node.getChildren();
        if (nodes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Cache> children = new ArrayList<Cache>();
        for (Node child : nodes) {
            children.add(new JBossCache<K, V>(this.cacheStore, child.getFqn()));
        }
        return children;
    }

    public boolean removeChild(String name) {
        Node<K, V> node = this.getRootNode();
        return node.removeChild(Fqn.fromString((String)name));
    }

    public String getName() {
        return this.rootFqn.toString();
    }
}

