/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.cache.jboss;

import java.io.Serializable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.teiid.cache.Cache;
import org.teiid.cache.CacheConfiguration;
import org.teiid.cache.CacheFactory;
import org.teiid.cache.DefaultCacheFactory;
import org.teiid.cache.jboss.JBossCacheFactory;
import org.teiid.core.TeiidRuntimeException;

public class ClusterableCacheFactory
implements CacheFactory,
Serializable {
    private static final long serialVersionUID = -1992994494154581234L;
    private CacheFactory delegate;
    private String cacheName;
    private boolean enabled = false;

    public <K, V> Cache<K, V> get(Cache.Type type, CacheConfiguration config) {
        if (this.delegate == null) {
            Object cacheManager = this.getClusteredCache();
            if (cacheManager == null) {
                this.delegate = new DefaultCacheFactory();
            } else {
                try {
                    this.delegate = new JBossCacheFactory(this.cacheName, cacheManager);
                }
                catch (Exception e) {
                    throw new TeiidRuntimeException("Failed to obtain the clusted cache");
                }
            }
        }
        return this.delegate.get(type, config);
    }

    public void setClusteredCacheName(String name) {
        this.cacheName = name;
    }

    public void destroy() {
        if (this.delegate != null) {
            this.delegate.destroy();
        }
    }

    private Object getClusteredCache() {
        if (this.enabled) {
            try {
                InitialContext ctx = new InitialContext();
                return ctx.lookup("java:CacheManager");
            }
            catch (NamingException e) {
                return null;
            }
        }
        return null;
    }

    public void setEnabled(boolean value) {
        this.enabled = value;
    }
}

