/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.cache.jboss;

import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.teiid.cache.DefaultCache;
import org.teiid.cache.jboss.JBossCache;

public class ExpirationAwareCache<K, V>
extends JBossCache<K, V> {
    public ExpirationAwareCache(Cache cacheStore, Fqn fqn) {
        super(cacheStore, fqn);
    }

    @Override
    public V put(K key, V value) {
        return this.put(key, value, null);
    }

    @Override
    public V put(K key, V value, Long ttl) {
        Node node = this.getRootNode();
        Node child = node.addChild(this.getFqn(key));
        long future = DefaultCache.getExpirationTime((long)(this.config.getMaxAgeInSeconds() * 1000), (Long)ttl);
        child.put((Object)"expiration", (Object)future);
        return (V)child.put(key, value);
    }
}

