/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.cache.jboss;

import java.io.Serializable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.teiid.cache.Cache;
import org.teiid.cache.CacheConfiguration;
import org.teiid.cache.CacheFactory;
import org.teiid.cache.DefaultCacheFactory;
import org.teiid.cache.jboss.JBossCacheFactory;
import org.teiid.core.TeiidRuntimeException;

public class ClusterableCacheFactory
implements CacheFactory,
Serializable {
    private static final long serialVersionUID = -1992994494154581234L;
    private CacheFactory delegate;
    private String resultsetCacheName;
    private boolean enabled = false;
    private String cacheManagerName;

    public <K, V> Cache<K, V> get(String location, CacheConfiguration config) {
        if (this.delegate == null) {
            Object cacheManager = this.getClusteredCache();
            if (cacheManager == null) {
                this.delegate = new DefaultCacheFactory(config);
            } else {
                try {
                    this.delegate = new JBossCacheFactory(this.resultsetCacheName, cacheManager);
                }
                catch (Exception e) {
                    throw new TeiidRuntimeException("Failed to obtain the clusted cache");
                }
            }
        }
        return this.delegate.get(location, config);
    }

    public void setResultsetCacheName(String name) {
        this.resultsetCacheName = name;
    }

    public void destroy() {
        if (this.delegate != null) {
            this.delegate.destroy();
        }
    }

    private Object getClusteredCache() {
        if (this.enabled && this.cacheManagerName != null) {
            try {
                InitialContext ctx = new InitialContext();
                return ctx.lookup(this.cacheManagerName);
            }
            catch (NamingException e) {
                return null;
            }
        }
        return null;
    }

    public void setEnabled(boolean value) {
        this.enabled = value;
    }

    public void setCacheManager(String mgrName) {
        this.cacheManagerName = mgrName;
    }

    public boolean isReplicated() {
        if (this.delegate == null) {
            return false;
        }
        return this.delegate.isReplicated();
    }
}

