/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.cache.jboss;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.cache.CacheStatus;
import org.jboss.cache.Fqn;
import org.jboss.cache.Modification;
import org.jboss.cache.RegionManager;
import org.jboss.cache.ReplicationException;
import org.jboss.cache.commands.CommandsFactory;
import org.jboss.cache.commands.DataCommand;
import org.jboss.cache.commands.ReplicableCommand;
import org.jboss.cache.commands.read.ExistsCommand;
import org.jboss.cache.commands.read.GetDataMapCommand;
import org.jboss.cache.commands.remote.ClusteredGetCommand;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.loader.AbstractCacheLoader;
import org.jboss.cache.lock.StripedLock;
import org.jgroups.Address;
import org.jgroups.blocks.RspFilter;
import org.teiid.cache.jboss.TupleBatchCacheLoaderConfig;

class ClusteredTupleBatchCacheLoader
extends AbstractCacheLoader {
    private StripedLock lock = new StripedLock();
    private TupleBatchCacheLoaderConfig config;
    private CommandsFactory commandsFactory;
    private boolean init = false;

    ClusteredTupleBatchCacheLoader() {
    }

    public void start() {
        this.init();
    }

    private void init() {
        if (!this.init) {
            this.setCommandsFactory((CommandsFactory)this.cache.getComponentRegistry().getComponent(CommandsFactory.class));
            this.init = true;
        }
    }

    protected boolean isCacheReady() {
        return this.cache.getCacheStatus() == CacheStatus.STARTED;
    }

    @Inject
    public void setCommandsFactory(CommandsFactory commandsFactory) {
        this.commandsFactory = commandsFactory;
    }

    public void setConfig(CacheLoaderConfig.IndividualCacheLoaderConfig base) {
        this.config = (TupleBatchCacheLoaderConfig)base;
    }

    public CacheLoaderConfig.IndividualCacheLoaderConfig getConfig() {
        return this.config;
    }

    public Set getChildrenNames(Fqn fqn) throws Exception {
        return Collections.emptySet();
    }

    private List<Object> callRemote(DataCommand dataCommand) throws Exception {
        ClusteredGetCommand clusteredGet = this.commandsFactory.buildClusteredGetCommand(Boolean.valueOf(false), dataCommand);
        List resps = this.cache.getRPCManager().callRemoteMethods(null, (ReplicableCommand)clusteredGet, 2, this.config.getTimeout(), (RspFilter)new ResponseValidityFilter(this.cache.getMembers(), this.cache.getLocalAddress(), dataCommand), false);
        if (resps == null) {
            throw new ReplicationException("No replies to call " + dataCommand + ".  Perhaps we're alone in the cluster?");
        }
        return resps;
    }

    public Map get(Fqn name) throws Exception {
        return this.get0(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map get0(Fqn name) throws Exception {
        if (!this.isCacheReady() || !this.cache.getInvocationContext().isOriginLocal()) {
            return null;
        }
        this.lock.acquireLock(name, true);
        try {
            this.init();
            GetDataMapCommand command = this.commandsFactory.buildGetDataMapCommand(name);
            List<Object> resps = this.callRemote((DataCommand)command);
            Map result = Collections.EMPTY_MAP;
            for (Object o : resps) {
                Map resp;
                List clusteredGetResp;
                if (o == null || o instanceof Exception || !((Boolean)(clusteredGetResp = (List)o).get(0)).booleanValue() || (resp = (Map)clusteredGetResp.get(1)).isEmpty()) continue;
                result = resp;
            }
            Map map = result;
            return map;
        }
        finally {
            this.lock.releaseLock(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(Fqn name) throws Exception {
        if (!this.isCacheReady() || !this.cache.getInvocationContext().isOriginLocal()) {
            return false;
        }
        this.lock.acquireLock(name, false);
        try {
            this.init();
            ExistsCommand command = this.commandsFactory.buildExistsNodeCommand(name);
            List<Object> resps = this.callRemote((DataCommand)command);
            boolean result = false;
            for (Object o : resps) {
                List clusteredGetResp;
                if (o == null || o instanceof Exception || !((Boolean)(clusteredGetResp = (List)o).get(0)).booleanValue() || !((Boolean)clusteredGetResp.get(1)).booleanValue()) continue;
                result = true;
                break;
            }
            boolean bl = result;
            return bl;
        }
        finally {
            this.lock.releaseLock(name);
        }
    }

    public Object put(Fqn name, Object key, Object value) throws Exception {
        return null;
    }

    public void put(Fqn name, Map attributes) throws Exception {
    }

    public void put(List<Modification> modifications) throws Exception {
    }

    public Object remove(Fqn name, Object key) throws Exception {
        return null;
    }

    public void remove(Fqn name) throws Exception {
    }

    public void removeData(Fqn name) throws Exception {
    }

    public void prepare(Object tx, List modifications, boolean one_phase) throws Exception {
    }

    public void commit(Object tx) throws Exception {
    }

    public void rollback(Object tx) {
    }

    public void loadEntireState(ObjectOutputStream os) throws Exception {
    }

    public void loadState(Fqn subtree, ObjectOutputStream os) throws Exception {
    }

    public void storeEntireState(ObjectInputStream is) throws Exception {
    }

    public void storeState(Fqn subtree, ObjectInputStream is) throws Exception {
    }

    public void setRegionManager(RegionManager manager) {
    }

    public static class ResponseValidityFilter
    implements RspFilter {
        private int numValidResponses = 0;
        private List<Address> pendingResponders;
        private DataCommand command;

        public ResponseValidityFilter(List<Address> expected, Address localAddress, DataCommand command) {
            this.pendingResponders = new ArrayList<Address>(expected);
            this.pendingResponders.remove(localAddress);
            this.command = command;
        }

        public boolean isAcceptable(Object object, Address address) {
            List response;
            Boolean foundResult;
            this.pendingResponders.remove(address);
            if (object instanceof List && (foundResult = (Boolean)(response = (List)object).get(0)).booleanValue()) {
                Map resp;
                if (this.command instanceof ExistsCommand) {
                    Boolean resp2 = (Boolean)response.get(1);
                    if (resp2.booleanValue()) {
                        ++this.numValidResponses;
                    }
                } else if (this.command instanceof GetDataMapCommand && !(resp = (Map)response.get(1)).isEmpty()) {
                    ++this.numValidResponses;
                }
            }
            return true;
        }

        public boolean needMoreResponses() {
            return this.numValidResponses < 1 && this.pendingResponders.size() > 0;
        }
    }
}

