/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.cache.jboss;

import java.io.Serializable;
import org.jboss.cache.CacheManager;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.Region;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.ExpirationAlgorithmConfig;
import org.jboss.cache.eviction.LRUAlgorithmConfig;
import org.jboss.cache.eviction.RemoveOnEvictActionPolicy;
import org.teiid.cache.Cache;
import org.teiid.cache.CacheConfiguration;
import org.teiid.cache.CacheFactory;
import org.teiid.cache.jboss.ExpirationAwareCache;
import org.teiid.cache.jboss.JBossCache;
import org.teiid.core.TeiidRuntimeException;

public class JBossCacheFactory
implements CacheFactory,
Serializable {
    private static final long serialVersionUID = -2767452034178675653L;
    private transient org.jboss.cache.Cache cacheStore;
    private volatile boolean destroyed = false;

    public JBossCacheFactory(String name, Object cm) throws Exception {
        CacheManager cachemanager = (CacheManager)cm;
        this.cacheStore = cachemanager.getCache(name, true);
    }

    public Cache get(String location, CacheConfiguration config) {
        if (!this.destroyed) {
            if (!this.cacheStore.getCacheStatus().allowInvocations()) {
                this.cacheStore.start();
                if (this.cacheStore.getRegion(this.cacheStore.getRoot().getFqn(), false) != null) {
                    this.cacheStore.getRegion(this.cacheStore.getRoot().getFqn(), true).activate();
                }
            }
            Node cacheRoot = this.cacheStore.getRoot().addChild(Fqn.fromString((String)"Teiid"));
            Node node = cacheRoot.addChild(Fqn.fromString((String)location));
            node.setResident(true);
            Region cacheRegion = this.cacheStore.getRegion(node.getFqn(), true);
            cacheRegion.setEvictionRegionConfig(this.buildEvictionConfig(node.getFqn(), config));
            cacheRegion.activate();
            cacheRegion = this.cacheStore.getRegion(node.getFqn(), true);
            cacheRegion.setEvictionRegionConfig(this.buildEvictionConfig(node.getFqn(), config));
            JBossCache jc = null;
            jc = config != null && config.getPolicy().equals((Object)CacheConfiguration.Policy.EXPIRATION) ? new ExpirationAwareCache(this.cacheStore, node.getFqn()) : new JBossCache(this.cacheStore, node.getFqn());
            jc.setCacheConfiguration(config);
            return jc;
        }
        throw new TeiidRuntimeException("Cache system has been shutdown");
    }

    private EvictionRegionConfig buildEvictionConfig(Fqn rootFqn, CacheConfiguration config) {
        ExpirationAlgorithmConfig evictionConfig = null;
        if (config.getPolicy() == CacheConfiguration.Policy.LRU) {
            LRUAlgorithmConfig lru = new LRUAlgorithmConfig();
            lru.setMaxNodes(config.getMaxEntries());
            lru.setMaxAge((long)(config.getMaxAgeInSeconds() * 1000));
            lru.setTimeToLive(-1L);
            evictionConfig = lru;
        } else if (config.getPolicy() == CacheConfiguration.Policy.EXPIRATION) {
            ExpirationAlgorithmConfig lfu = new ExpirationAlgorithmConfig();
            lfu.setMaxNodes(config.getMaxEntries());
            evictionConfig = lfu;
        }
        EvictionRegionConfig erc = new EvictionRegionConfig(rootFqn, evictionConfig);
        erc.setEvictionActionPolicyClassName(RemoveOnEvictActionPolicy.class.getName());
        return erc;
    }

    public void destroy() {
        this.destroyed = true;
    }

    public void stop() {
        this.destroy();
    }

    public boolean isReplicated() {
        return true;
    }
}

