/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public abstract class BaseDriver
implements Driver {
    public abstract String getDriverName();

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        if (info == null) {
            info = new Properties();
        }
        this.parseURL(url, info);
        LinkedList<DriverPropertyInfo> driverProps = new LinkedList<DriverPropertyInfo>();
        DriverPropertyInfo dpi = new DriverPropertyInfo("VirtualDatabaseName", info.getProperty("VirtualDatabaseName"));
        dpi.required = true;
        driverProps.add(dpi);
        driverProps.add(new DriverPropertyInfo("VirtualDatabaseVersion", info.getProperty("VirtualDatabaseVersion")));
        driverProps.addAll(this.getAdditionalPropertyInfo(url, info));
        DriverPropertyInfo[] propInfo = new DriverPropertyInfo[driverProps.size()];
        return driverProps.toArray(propInfo);
    }

    abstract List<DriverPropertyInfo> getAdditionalPropertyInfo(String var1, Properties var2);

    abstract void parseURL(String var1, Properties var2) throws SQLException;
}

