/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.common.types.TransformationException;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.MMSQLException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;

final class DataTypeTransformer {
    private DataTypeTransformer() {
    }

    static final BigDecimal getBigDecimal(Object value) throws SQLException {
        return DataTypeTransformer.transform(value, BigDecimal.class, "BigDecimal");
    }

    private static final <T> T transform(Object value, Class<T> type, String typeName) throws SQLException {
        return DataTypeTransformer.transform(value, type, type, typeName);
    }

    private static final <T> T transform(Object value, Class<T> targetType, Class<?> runtimeType, String typeName) throws SQLException {
        if (value == null || targetType.isAssignableFrom(value.getClass())) {
            return (T)value;
        }
        try {
            return (T)DataTypeManager.transformValue((Object)DataTypeManager.convertToRuntimeType((Object)value), runtimeType);
        }
        catch (TransformationException e) {
            String valueStr = value.toString();
            if (valueStr.length() > 20) {
                valueStr = valueStr.substring(0, 20) + "...";
            }
            String msg = JDBCPlugin.Util.getString("DataTypeTransformer.Err_converting", new Object[]{valueStr, typeName});
            throw MMSQLException.create(e, msg);
        }
    }

    static final boolean getBoolean(Object value) throws SQLException {
        if (value == null) {
            return false;
        }
        return DataTypeTransformer.transform(value, Boolean.class, "Boolean");
    }

    static final byte getByte(Object value) throws SQLException {
        if (value == null) {
            return 0;
        }
        return DataTypeTransformer.transform(value, Byte.class, "Byte");
    }

    static final byte[] getBytes(Object value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (value instanceof Blob) {
            Blob blob = (Blob)value;
            long length = blob.length();
            if (length > Integer.MAX_VALUE) {
                throw new MMSQLException(JDBCPlugin.Util.getString("DataTypeTransformer.blob_too_big"));
            }
            return blob.getBytes(1L, (int)length);
        }
        throw new MMSQLException(JDBCPlugin.Util.getString("DataTypeTransformer.cannot_get_bytes"));
    }

    static final Character getCharacter(Object value) throws SQLException {
        return DataTypeTransformer.transform(value, Character.class, "Character");
    }

    static final Date getDate(Object value) throws SQLException {
        return DataTypeTransformer.transform(value, Date.class, "Date");
    }

    static final double getDouble(Object value) throws SQLException {
        if (value == null) {
            return 0.0;
        }
        return DataTypeTransformer.transform(value, Double.class, "Double");
    }

    static final float getFloat(Object value) throws SQLException {
        if (value == null) {
            return 0.0f;
        }
        return DataTypeTransformer.transform(value, Float.class, "Float").floatValue();
    }

    static final int getInteger(Object value) throws SQLException {
        if (value == null) {
            return 0;
        }
        return DataTypeTransformer.transform(value, Integer.class, "Integer");
    }

    static final long getLong(Object value) throws SQLException {
        if (value == null) {
            return 0L;
        }
        return DataTypeTransformer.transform(value, Long.class, "Long");
    }

    static final short getShort(Object value) throws SQLException {
        if (value == null) {
            return 0;
        }
        return DataTypeTransformer.transform(value, Short.class, "Short");
    }

    static final Time getTime(Object value) throws SQLException {
        return DataTypeTransformer.transform(value, Time.class, "Time");
    }

    static final Timestamp getTimestamp(Object value) throws SQLException {
        return DataTypeTransformer.transform(value, Timestamp.class, "Timestamp");
    }

    static final String getString(Object value) throws SQLException {
        return DataTypeTransformer.transform(value, String.class, "String");
    }

    static final Blob getBlob(Object value) throws SQLException {
        return DataTypeTransformer.transform(value, Blob.class, DataTypeManager.DefaultDataClasses.BLOB, "Blob");
    }

    static final Clob getClob(Object value) throws SQLException {
        return DataTypeTransformer.transform(value, Clob.class, DataTypeManager.DefaultDataClasses.CLOB, "Clob");
    }

    static final SQLXML getSQLXML(Object value) throws SQLException {
        return DataTypeTransformer.transform(value, SQLXML.class, DataTypeManager.DefaultDataClasses.XML, "SQLXML");
    }
}

