/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.common.classloader.NonDelegatingClassLoader;
import com.metamatrix.common.protocol.MetaMatrixURLStreamHandlerFactory;
import com.metamatrix.common.protocol.URLHelper;
import com.metamatrix.common.util.ApplicationInfo;
import com.metamatrix.jdbc.BaseDataSource;
import com.metamatrix.jdbc.BaseDriver;
import com.metamatrix.jdbc.EmbeddedConnectionFactory;
import com.metamatrix.jdbc.EmbeddedSQLException;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.util.MMJDBCURL;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class EmbeddedDriver
extends BaseDriver {
    static final String URL_PATTERN = "jdbc:metamatrix:(\\w+)@(([^;]*)[;]?)((.*)*)";
    static final String BASE_PATTERN = "jdbc:metamatrix:((\\w+)[;]?)(;([^@])+)*";
    public static final String DRIVER_NAME = "Teiid Embedded JDBC Driver";
    static final String DQP_IDENTITY = "dqp.identity";
    static final String MM_IO_TMPDIR = "mm.io.tmpdir";
    private static Logger logger = Logger.getLogger("org.teiid.jdbc");
    private static EmbeddedTransport currentTransport = null;
    static Pattern urlPattern = Pattern.compile("jdbc:metamatrix:(\\w+)@(([^;]*)[;]?)((.*)*)");
    static Pattern basePattern = Pattern.compile("jdbc:metamatrix:((\\w+)[;]?)(;([^@])+)*");

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        Connection conn = null;
        if (info == null) {
            info = new Properties();
        }
        if (!this.acceptsURL(url)) {
            return null;
        }
        this.parseURL(url, info);
        conn = this.createConnection(info);
        String logMsg = JDBCPlugin.Util.getString("JDBCDriver.Connection_sucess");
        logger.info(logMsg);
        return conn;
    }

    Connection createConnection(Properties info) throws SQLException {
        this.validateProperties(info);
        URL dqpURL = (URL)info.get("bootstrapFile");
        EmbeddedTransport transport = EmbeddedDriver.getDQPTransport(dqpURL, info);
        Connection conn = transport.createConnection(info);
        currentTransport = transport;
        return conn;
    }

    private static EmbeddedTransport getDQPTransport(URL dqpURL, Properties info) throws SQLException {
        EmbeddedTransport transport = currentTransport;
        if (transport != null && currentTransport.getURL().equals(dqpURL)) {
            String logMsg = BaseDataSource.getResourceMessage("EmbeddedDriver.use_existing_transport");
            DriverManager.println(logMsg);
        } else {
            EmbeddedDriver.shutdown();
            transport = new EmbeddedTransport(dqpURL, info);
            String logMsg = BaseDataSource.getResourceMessage("EmbeddedDriver.use_new_transport");
            DriverManager.println(logMsg);
        }
        return transport;
    }

    @Override
    void parseURL(String url, Properties info) throws SQLException {
        if (url == null || url.trim().length() == 0) {
            String logMsg = BaseDataSource.getResourceMessage("EmbeddedDriver.URL_must_be_specified");
            DriverManager.println(logMsg);
            throw new SQLException(logMsg);
        }
        try {
            MMJDBCURL jdbcURL = new MMJDBCURL(url);
            info.setProperty("VirtualDatabaseName", jdbcURL.getVDBName());
            String connectionURL = jdbcURL.getConnectionURL();
            if (connectionURL == null) {
                connectionURL = EmbeddedDriver.getDefaultConnectionURL();
                info.setProperty("vdb.definition", jdbcURL.getVDBName() + ".vdb");
            }
            URL dqpURL = URLHelper.buildURL((String)connectionURL);
            Properties optionalParams = jdbcURL.getProperties();
            MMJDBCURL.normalizeProperties(info);
            Enumeration<Object> keys = optionalParams.keys();
            while (keys.hasMoreElements()) {
                String propName = (String)keys.nextElement();
                if (info.containsKey(propName)) continue;
                info.setProperty(propName, optionalParams.getProperty(propName));
            }
            if (!info.containsKey("VirtualDatabaseVersion") && jdbcURL.getVDBVersion() != null) {
                info.setProperty("VirtualDatabaseVersion", jdbcURL.getVDBVersion());
            }
            info.put("bootstrapFile", dqpURL);
        }
        catch (Exception e) {
            String logMsg = e.getClass() + ": " + e.getMessage();
            DriverManager.println(logMsg);
            DriverManager.println(e.getStackTrace().toString());
            throw new SQLException(logMsg);
        }
    }

    static String getDefaultConnectionURL() {
        return "classpath:/deploy.properties";
    }

    void validateProperties(Properties info) throws SQLException {
        String value = null;
        value = info.getProperty("VirtualDatabaseName");
        if (value == null || value.trim().length() == 0) {
            String logMsg = BaseDataSource.getResourceMessage("MMDataSource.Virtual_database_name_must_be_specified");
            DriverManager.println(logMsg);
            throw new SQLException(logMsg);
        }
        URL url = (URL)info.get("bootstrapFile");
        if (url == null) {
            String logMsg = BaseDataSource.getResourceMessage("EmbeddedDataSource.Configuration_file_must_be_specified");
            DriverManager.println(logMsg);
            throw new SQLException(logMsg);
        }
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        Matcher m = urlPattern.matcher(url);
        boolean matched = m.matches();
        if (matched) {
            String name = m.group(2).toLowerCase();
            return !name.startsWith("mm://") && !name.startsWith("mms://");
        }
        m = basePattern.matcher(url);
        matched = m.matches();
        return matched;
    }

    @Override
    List<DriverPropertyInfo> getAdditionalPropertyInfo(String url, Properties info) {
        DriverPropertyInfo dpi = new DriverPropertyInfo("bootstrapFile", info.getProperty("bootstrapFile"));
        dpi.required = true;
        return Arrays.asList(dpi);
    }

    @Override
    public int getMajorVersion() {
        return ApplicationInfo.getInstance().getMajorReleaseVersion();
    }

    @Override
    public int getMinorVersion() {
        return ApplicationInfo.getInstance().getMinorReleaseVersion();
    }

    @Override
    public String getDriverName() {
        return DRIVER_NAME;
    }

    public static synchronized void shutdown() {
        if (currentTransport != null) {
            try {
                currentTransport.shutdown();
                currentTransport = null;
            }
            catch (SQLException e) {
                DriverManager.println(e.getMessage());
            }
        }
    }

    static {
        try {
            DriverManager.registerDriver(new EmbeddedDriver());
        }
        catch (SQLException e) {
            String logMsg = BaseDataSource.getResourceMessage("EmbeddedDriver.MMDQP_DRIVER_could_not_be_registered");
            DriverManager.println(logMsg);
        }
    }

    static class EmbeddedTransport {
        private EmbeddedConnectionFactory connectionFactory;
        private ClassLoader classLoader;
        private String workspaceDirectory;
        private URL url;

        public EmbeddedTransport(URL dqpURL, Properties info) throws SQLException {
            this.url = dqpURL;
            this.workspaceDirectory = this.createWorkspace(this.getDQPIdentity());
            Properties props = this.loadDQPProperties(dqpURL);
            props.putAll((Map<?, ?>)info);
            this.classLoader = this.getClass().getClassLoader();
            ArrayList<URL> runtimeClasspath = new ArrayList<URL>();
            if (!EmbeddedDriver.getDefaultConnectionURL().equals(dqpURL.toString())) {
                runtimeClasspath.addAll(this.libClassPath(dqpURL, "lib/patches/", "reversealpha"));
                runtimeClasspath.addAll(this.libClassPath(dqpURL, "lib/", "date"));
            }
            URL[] dqpClassPath = runtimeClasspath.toArray(new URL[runtimeClasspath.size()]);
            this.classLoader = new NonDelegatingClassLoader(dqpClassPath, Thread.currentThread().getContextClassLoader(), (URLStreamHandlerFactory)new MetaMatrixURLStreamHandlerFactory());
            String logMsg = BaseDataSource.getResourceMessage("EmbeddedDriver.use_classpath");
            DriverManager.println(logMsg);
            for (int i = 0; i < dqpClassPath.length; ++i) {
                DriverManager.println(dqpClassPath[i].toString());
            }
            ClassLoader current = null;
            try {
                current = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.classLoader);
                String className = "com.metamatrix.jdbc.EmbeddedConnectionFactoryImpl";
                Class<?> clazz = this.classLoader.loadClass(className);
                this.connectionFactory = (EmbeddedConnectionFactory)clazz.newInstance();
            }
            catch (Exception e) {
                DriverManager.println(e.getClass() + ": " + e.getMessage());
                throw new EmbeddedSQLException(e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(current);
            }
        }

        URL getURL() {
            return this.url;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<URL> libClassPath(URL dqpURL, String directory, String sortStyle) {
            ObjectInputStream in = null;
            ArrayList<URL> urlList = new ArrayList<URL>();
            try {
                urlList.add(URLHelper.buildURL((URL)dqpURL, (String)directory));
                dqpURL = URLHelper.buildURL((URL)dqpURL, (String)(directory + "?action=list&filter=.jar&sort=" + sortStyle));
                in = new ObjectInputStream(dqpURL.openStream());
                String[] urls = (String[])in.readObject();
                for (int i = 0; i < urls.length; ++i) {
                    boolean add = true;
                    URL jarURL = URLHelper.buildURL((String)urls[i]);
                    if (!add) continue;
                    urlList.add(jarURL);
                }
            }
            catch (IOException e) {
            }
            catch (ClassNotFoundException e) {
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
            }
            return urlList;
        }

        Properties loadDQPProperties(URL dqpURL) throws SQLException {
            InputStream in = null;
            try {
                in = dqpURL.openStream();
                Properties props = new Properties();
                props.load(in);
                String logMsg = BaseDataSource.getResourceMessage("EmbeddedDriver.use_properties");
                DriverManager.println(logMsg);
                for (String string : props.keySet()) {
                    DriverManager.println(string + "=" + props.getProperty(string));
                }
                Properties properties = props;
                return properties;
            }
            catch (IOException e) {
                String logMsg = BaseDataSource.getResourceMessage("EmbeddedTransport.invalid_dqpproperties_path", new Object[]{dqpURL});
                DriverManager.println(e.getClass() + ": " + e.getMessage());
                DriverManager.println(e.getStackTrace().toString());
                throw new EmbeddedSQLException(e, logMsg);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
            }
        }

        void shutdown() throws SQLException {
            File file;
            this.connectionFactory.shutdown();
            if (this.workspaceDirectory != null && (file = new File(this.workspaceDirectory)).exists()) {
                this.delete(file);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Connection createConnection(Properties info) throws SQLException {
            ClassLoader current = null;
            try {
                current = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.classLoader);
                Connection connection = this.connectionFactory.createConnection(info);
                return connection;
            }
            finally {
                Thread.currentThread().setContextClassLoader(current);
            }
        }

        String getDQPIdentity() {
            String id = System.getProperty(EmbeddedDriver.DQP_IDENTITY, "0");
            int identity = Integer.parseInt(id) + 1;
            id = String.valueOf(identity);
            System.setProperty(EmbeddedDriver.DQP_IDENTITY, id);
            return id;
        }

        String createWorkspace(String identity) {
            String dir = System.getProperty("java.io.tmpdir") + "/metamatrix/" + identity;
            System.setProperty(EmbeddedDriver.MM_IO_TMPDIR, dir);
            File f = new File(dir);
            if (f.exists()) {
                this.delete(f);
            }
            if (!f.exists()) {
                f.mkdirs();
            }
            return dir;
        }

        private void delete(File file) {
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    this.delete(files[i]);
                }
            }
            if (file.getName().endsWith(".jar")) {
                file.delete();
            }
        }
    }
}

