/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.common.comm.api.ServerConnection;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.exception.ConnectionException;
import com.metamatrix.common.comm.platform.socket.client.SocketServerConnection;
import com.metamatrix.common.comm.platform.socket.client.SocketServerConnectionFactory;
import com.metamatrix.common.util.ApplicationInfo;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.core.MetaMatrixCoreException;
import com.metamatrix.jdbc.BaseDriver;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.MMSQLException;
import com.metamatrix.jdbc.MMServerConnection;
import com.metamatrix.jdbc.util.MMJDBCURL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class MMDriver
extends BaseDriver {
    private static Logger logger = Logger.getLogger("org.teiid.jdbc");
    static final String JDBC = "jdbc:";
    static final String URL_PREFIX = "jdbc:metamatrix";
    static final String DRIVER_NAME = "Teiid JDBC Driver";
    static final String HOST_PORT_PATTERN = "[\\p{Alnum}\\.\\-]+:\\d+";
    static final String URL_PATTERN = "jdbc:metamatrix:(\\w+)@((mm[s]?://[\\p{Alnum}\\.\\-]+:\\d+(,[\\p{Alnum}\\.\\-]+:\\d+)*)[;]?){1}((.*)*)";
    static Pattern urlPattern = Pattern.compile("jdbc:metamatrix:(\\w+)@((mm[s]?://[\\p{Alnum}\\.\\-]+:\\d+(,[\\p{Alnum}\\.\\-]+:\\d+)*)[;]?){1}((.*)*)");
    private static MMDriver INSTANCE = new MMDriver();

    public static MMDriver getInstance() {
        return INSTANCE;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        MMServerConnection myConnection = null;
        info = info == null ? new Properties() : PropertiesUtils.clone((Properties)info);
        if (!this.acceptsURL(url)) {
            return null;
        }
        try {
            this.parseURL(url, info);
            myConnection = this.createMMConnection(url, info);
        }
        catch (MetaMatrixCoreException e) {
            DriverManager.println(e.getMessage());
            throw MMSQLException.create(e, e.getMessage());
        }
        String logMsg = JDBCPlugin.Util.getString("JDBCDriver.Connection_sucess");
        logger.info(logMsg);
        return myConnection;
    }

    MMServerConnection createMMConnection(String url, Properties info) throws ConnectionException, CommunicationException {
        SocketServerConnection serverConn = SocketServerConnectionFactory.getInstance().createConnection(info);
        MMServerConnection connection = MMServerConnection.newInstance((ServerConnection)serverConn, info, url);
        return connection;
    }

    @Override
    void parseURL(String url, Properties info) throws SQLException {
        if (url == null) {
            String msg = JDBCPlugin.Util.getString("MMDriver.urlFormat");
            throw new MMSQLException(msg);
        }
        try {
            MMJDBCURL jdbcURL = new MMJDBCURL(url);
            info.setProperty("VirtualDatabaseName", jdbcURL.getVDBName());
            info.setProperty("serverURL", jdbcURL.getConnectionURL());
            Properties optionalParams = jdbcURL.getProperties();
            MMJDBCURL.normalizeProperties(info);
            Enumeration<Object> keys = optionalParams.keys();
            while (keys.hasMoreElements()) {
                String propName = (String)keys.nextElement();
                if (info.containsKey(propName)) continue;
                info.setProperty(propName, optionalParams.getProperty(propName));
            }
            if (!info.containsKey("VirtualDatabaseVersion") && jdbcURL.getVDBVersion() != null) {
                info.setProperty("VirtualDatabaseVersion", jdbcURL.getVDBVersion());
            }
        }
        catch (IllegalArgumentException iae) {
            throw new MMSQLException(JDBCPlugin.Util.getString("MMDriver.urlFormat"));
        }
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        Matcher m = urlPattern.matcher(url);
        return m.matches();
    }

    @Override
    public int getMajorVersion() {
        return ApplicationInfo.getInstance().getMajorReleaseVersion();
    }

    @Override
    public int getMinorVersion() {
        return ApplicationInfo.getInstance().getMinorReleaseVersion();
    }

    @Override
    public String getDriverName() {
        return DRIVER_NAME;
    }

    @Override
    List<DriverPropertyInfo> getAdditionalPropertyInfo(String url, Properties info) {
        LinkedList<DriverPropertyInfo> dpis = new LinkedList<DriverPropertyInfo>();
        DriverPropertyInfo dpi = new DriverPropertyInfo("serverURL", info.getProperty("serverURL"));
        dpi.required = true;
        dpis.add(dpi);
        dpis.add(new DriverPropertyInfo("user", info.getProperty("user")));
        dpis.add(new DriverPropertyInfo("password", info.getProperty("password")));
        dpis.add(new DriverPropertyInfo("clientToken", info.getProperty("password")));
        return dpis;
    }

    static {
        try {
            DriverManager.registerDriver(INSTANCE);
        }
        catch (SQLException e) {
            String logMsg = JDBCPlugin.Util.getString("MMDriver.Err_registering", new Object[]{e.getMessage()});
            DriverManager.println(logMsg);
        }
    }
}

