/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.common.lob.LobChunkInputStream;
import com.metamatrix.common.lob.LobChunkProducer;
import com.metamatrix.common.types.XMLType;
import com.metamatrix.dqp.client.impl.StreamingLobChunckProducer;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.MMSQLException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class MMSQLXML
implements SQLXML {
    private final StreamingLobChunckProducer.Factory lobChunckFactory;

    public static SQLXML newInstance(StreamingLobChunckProducer.Factory lobChunckFactory, XMLType srcXML) throws SQLException {
        SQLXML sourceSQLXML;
        if (Boolean.getBoolean("FORCE_STREAMING") && (sourceSQLXML = srcXML.getSourceSQLXML()) != null) {
            return sourceSQLXML;
        }
        return new MMSQLXML(lobChunckFactory);
    }

    public MMSQLXML(StreamingLobChunckProducer.Factory lobChunckFactory) throws SQLException {
        this.lobChunckFactory = lobChunckFactory;
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        return new LobChunkInputStream((LobChunkProducer)this.lobChunckFactory.getLobChunkProducer()).getUTF16Reader();
    }

    @Override
    public String getString() throws SQLException {
        LobChunkInputStream in = new LobChunkInputStream((LobChunkProducer)this.lobChunckFactory.getLobChunkProducer());
        try {
            return new String(in.getByteContents(), Charset.forName("UTF-16"));
        }
        catch (IOException e) {
            throw MMSQLException.create(e);
        }
    }

    public String toString() {
        try {
            return this.getString();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T extends Source> T getSource(Class<T> sourceClass) throws SQLException {
        if (sourceClass == null || sourceClass == StreamSource.class) {
            return (T)new StreamSource(this.getCharacterStream());
        }
        throw new SQLException(JDBCPlugin.Util.getString("MMSQLXML.unsupported_source", new Object[]{sourceClass}));
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void free() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public OutputStream setBinaryStream() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Writer setCharacterStream() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T extends Result> T setResult(Class<T> resultClass) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setString(String value) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}

