/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.dqp.client.ClientSideDQP;
import com.metamatrix.dqp.client.ResultsFuture;
import com.metamatrix.dqp.message.ParameterInfo;
import com.metamatrix.dqp.message.RequestMessage;
import com.metamatrix.dqp.message.ResultsMessage;
import com.metamatrix.jdbc.AnnotationImpl;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.MMConnection;
import com.metamatrix.jdbc.MMResultSet;
import com.metamatrix.jdbc.MMSQLException;
import com.metamatrix.jdbc.PlanNodeImpl;
import com.metamatrix.jdbc.WarningUtil;
import com.metamatrix.jdbc.WrapperImpl;
import com.metamatrix.jdbc.api.PlanNode;
import com.metamatrix.jdbc.api.Statement;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MMStatement
extends WrapperImpl
implements Statement {
    private static Logger logger = Logger.getLogger("org.teiid.jdbc");
    protected static final int TIMED_OUT = 4;
    protected static final int CANCELLED = 3;
    protected static final int NO_TIMEOUT = 0;
    private static final int NO_LIMIT = 0;
    private MMConnection driverConnection;
    private Properties execProps = null;
    private String styleSheet;
    private int fetchSize = 2000;
    private int fetchDirection = 1000;
    private int resultSetType = 1003;
    private int resultSetConcurrency = 1007;
    private boolean isClosed = false;
    protected int commandStatus = -1;
    protected int queryTimeout = 0;
    protected long currentRequestID = -1L;
    private Map currentPlanDescription;
    private String debugLog;
    private List annotations;
    protected MMResultSet resultSet;
    private List<Exception> serverWarnings;
    private Serializable payload;
    private List batchedUpdates;
    protected int[] updateCounts;
    private Calendar defaultCalendar;
    private int maxRows = 0;
    private static int SPIN_TIMEOUT = 500;
    protected Map outParamIndexMap = new HashMap();

    static MMStatement newInstance(MMConnection driverConnection, int resultSetType, int resultSetConcurrency) {
        return new MMStatement(driverConnection, resultSetType, resultSetConcurrency);
    }

    MMStatement(MMConnection driverConnection, int resultSetType, int resultSetConcurrency) {
        this.driverConnection = driverConnection;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.execProps = PropertiesUtils.clone((Properties)this.getConnectionProperties());
        String fetchSizeStr = this.execProps.getProperty("fetchSize");
        if (fetchSizeStr != null) {
            try {
                this.fetchSize = Integer.parseInt(fetchSizeStr);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    protected ClientSideDQP getDQP() {
        return this.driverConnection.getDQP();
    }

    protected MMConnection getMMConnection() {
        return this.driverConnection;
    }

    protected TimeZone getServerTimeZone() throws SQLException {
        return this.driverConnection.getServerConnection().getLogonResult().getTimeZone();
    }

    protected void resetExecutionState() throws SQLException {
        this.currentRequestID = -1L;
        this.currentPlanDescription = null;
        this.debugLog = null;
        this.annotations = null;
        if (this.resultSet != null) {
            this.resultSet.close();
            this.resultSet = null;
        }
        this.serverWarnings = null;
        this.batchedUpdates = null;
        this.updateCounts = null;
        this.outParamIndexMap.clear();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.checkStatement();
        if (this.batchedUpdates == null) {
            this.batchedUpdates = new ArrayList();
        }
        this.batchedUpdates.add(sql);
    }

    @Override
    public void cancel() throws SQLException {
        this.commandStatus = 3;
        this.cancelRequest();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkStatement();
        this.serverWarnings = null;
    }

    @Override
    public void clearBatch() throws SQLException {
        this.batchedUpdates.clear();
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        if (this.currentRequestID > -1L) {
            if (this.resultSet == null) {
                try {
                    this.getDQP().closeRequest(this.currentRequestID);
                }
                catch (MetaMatrixProcessingException e) {
                    throw MMSQLException.create(e);
                }
                catch (MetaMatrixComponentException e) {
                    throw MMSQLException.create(e);
                }
            } else {
                this.resultSet.close();
                this.resultSet = null;
            }
        }
        this.isClosed = true;
        this.driverConnection.closeStatement(this);
        logger.info(JDBCPlugin.Util.getString("MMStatement.Close_stmt_success"));
        this.driverConnection = null;
    }

    protected void checkStatement() throws SQLException {
        if (this.isClosed) {
            throw new MMSQLException(JDBCPlugin.Util.getString("MMStatement.Stmt_closed"));
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.executeSql(new String[]{sql}, false, null);
        return this.hasResultSet();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        if (this.batchedUpdates == null || this.batchedUpdates.isEmpty()) {
            return new int[0];
        }
        String[] commands = this.batchedUpdates.toArray(new String[this.batchedUpdates.size()]);
        this.executeSql(commands, true, false);
        return this.updateCounts;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.executeSql(new String[]{sql}, false, true);
        return this.resultSet;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        String[] commands = new String[]{sql};
        this.executeSql(commands, false, false);
        return this.updateCounts[0];
    }

    protected boolean hasResultSet() throws SQLException {
        return this.resultSet != null && this.resultSet.getMetaData().getColumnCount() > 0;
    }

    protected void createResultSet(ResultsMessage resultsMsg) throws SQLException {
        List listOfParameters = resultsMsg.getParameters();
        if (listOfParameters != null) {
            int resultSetSize = 0;
            for (ParameterInfo parameter : listOfParameters) {
                if (parameter.getType() != 5) continue;
                resultSetSize = parameter.getNumColumns();
                break;
            }
            int index = 0;
            int count = 0;
            for (ParameterInfo parameter : listOfParameters) {
                if (parameter.getType() != 4) continue;
                this.outParamIndexMap.put(new Integer(++index), new Integer(resultSetSize + ++count));
                break;
            }
            for (ParameterInfo parameter : listOfParameters) {
                if (parameter.getType() == 4 || parameter.getType() == 5) continue;
                ++index;
                if (parameter.getType() != 2 && parameter.getType() != 3) continue;
                this.outParamIndexMap.put(new Integer(index), new Integer(resultSetSize + ++count));
            }
        }
        this.resultSet = new MMResultSet(resultsMsg, this, null, this.outParamIndexMap.size());
    }

    protected void executeSql(String[] commands, boolean isBatchedCommand, Boolean requiresResultSet) throws SQLException, MMSQLException {
        this.checkStatement();
        this.resetExecutionState();
        RequestMessage reqMessage = this.createRequestMessage(commands, isBatchedCommand, requiresResultSet);
        ResultsMessage resultsMsg = null;
        try {
            resultsMsg = this.sendRequestMessageAndWait(reqMessage);
        }
        catch (Throwable ex) {
            String msg = JDBCPlugin.Util.getString("MMStatement.Error_executing_stmt", new Object[]{reqMessage.getCommandString()});
            logger.log(Level.SEVERE, msg, ex);
            throw MMSQLException.create(ex, msg);
        }
        List resultsWarning = resultsMsg.getWarnings();
        this.setAnalysisInfo(resultsMsg);
        if (resultsMsg.getException() != null) {
            throw MMSQLException.create(resultsMsg.getException());
        }
        if (resultsWarning != null) {
            this.accumulateWarnings(resultsWarning);
        }
        if (resultsMsg.isUpdateResult()) {
            List[] results = resultsMsg.getResults();
            this.updateCounts = new int[results.length];
            for (int i = 0; i < results.length; ++i) {
                this.updateCounts[i] = (Integer)results[i].get(0);
            }
        } else {
            this.createResultSet(resultsMsg);
        }
        logger.info(JDBCPlugin.Util.getString("MMStatement.Success_query", new Object[]{reqMessage.getCommandString()}));
    }

    protected RequestMessage createRequestMessage(String[] commands, boolean isBatchedCommand, Boolean requiresResultSet) throws MMSQLException {
        if (isBatchedCommand || requiresResultSet == Boolean.FALSE) {
            throw new MMSQLException(JDBCPlugin.Util.getString("MMStatement.Operation_Not_Supported", Arrays.asList(commands)));
        }
        RequestMessage reqMessage = new RequestMessage();
        reqMessage.setCommands(commands);
        reqMessage.setBatchedUpdate(isBatchedCommand);
        reqMessage.setRequireResultSet(requiresResultSet);
        return reqMessage;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.checkStatement();
        if (this.resultSet != null) {
            this.resultSet.close();
            this.resultSet = null;
        }
        this.updateCounts = null;
        return false;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.checkStatement();
        return false;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkStatement();
        return this.queryTimeout;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkStatement();
        if (!this.hasResultSet()) {
            return null;
        }
        return this.resultSet;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetType() {
        return this.resultSetType;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkStatement();
        if (this.updateCounts == null) {
            return -1;
        }
        return this.updateCounts[0];
    }

    protected void accumulateWarnings(List<Exception> serverWarnings) {
        if (serverWarnings == null || serverWarnings.isEmpty()) {
            return;
        }
        if (this.serverWarnings == null) {
            this.serverWarnings = new ArrayList<Exception>();
        }
        this.serverWarnings.addAll(serverWarnings);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkStatement();
        if (this.serverWarnings != null && this.serverWarnings.size() != 0) {
            return WarningUtil.convertWarnings(this.serverWarnings);
        }
        return null;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkStatement();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkStatement();
        this.fetchDirection = direction;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkStatement();
        if (rows < 0) {
            String msg = JDBCPlugin.Util.getString("MMStatement.Invalid_fetch_size");
            throw new MMSQLException(msg);
        }
        this.fetchSize = rows == 0 ? 2000 : rows;
    }

    @Override
    public void setMaxRows(int maxRows) throws SQLException {
        this.checkStatement();
        this.maxRows = maxRows;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkStatement();
        if (seconds < 0) {
            throw new MMSQLException(JDBCPlugin.Util.getString("MMStatement.Bad_timeout_value"));
        }
        this.queryTimeout = seconds;
    }

    protected Properties getConnectionProperties() {
        return this.driverConnection.propInfo;
    }

    protected void copyPropertiesToRequest(RequestMessage res, Properties props) throws MMSQLException {
        String partial = this.getExecutionProperty("partialResultsMode");
        res.setPartialResults(Boolean.valueOf(partial).booleanValue());
        res.setFetchSize(this.fetchSize);
        res.setCursorType(this.resultSetType);
        String validate = this.getExecutionProperty("XMLValidation");
        if (validate == null) {
            res.setValidationMode(false);
        } else {
            res.setValidationMode(Boolean.valueOf(validate).booleanValue());
        }
        String format = this.getExecutionProperty("XMLFormat");
        res.setXMLFormat(format);
        String txnAutoWrapMode = this.getExecutionProperty("txnAutoWrap");
        try {
            res.setTxnAutoWrapMode(txnAutoWrapMode);
        }
        catch (MetaMatrixProcessingException e) {
            throw MMSQLException.create(e);
        }
        String rsCache = this.getExecutionProperty("resultSetCacheMode");
        res.setUseResultSetCache(Boolean.valueOf(rsCache).booleanValue());
        res.setQueryPlanAllowed(Boolean.valueOf(this.getExecutionProperty("planNotAllowed")) == false);
    }

    protected void timeoutOccurred() {
        logger.warning(JDBCPlugin.Util.getString("MMStatement.Timeout_ocurred_in_Statement."));
        try {
            this.cancel();
            this.commandStatus = 4;
            this.queryTimeout = 0;
            this.currentRequestID = -1L;
            if (this.resultSet != null) {
                this.resultSet.close();
            }
        }
        catch (SQLException se) {
            logger.log(Level.SEVERE, JDBCPlugin.Util.getString("MMStatement.Error_timing_out."), se);
        }
    }

    protected void cancelRequest() throws SQLException {
        this.checkStatement();
        try {
            this.getDQP().cancelRequest(this.currentRequestID);
        }
        catch (MetaMatrixProcessingException e) {
            throw MMSQLException.create(e);
        }
        catch (MetaMatrixComponentException e) {
            throw MMSQLException.create(e);
        }
    }

    @Override
    public void setPayload(Serializable payload) {
        this.payload = payload;
    }

    @Override
    public void setExecutionProperty(String name, String value) {
        this.execProps.put(name, value);
    }

    @Override
    public String getExecutionProperty(String name) {
        return (String)this.execProps.get(name);
    }

    protected ResultsMessage sendRequestMessageAndWait(RequestMessage reqMsg) throws SQLException, InterruptedException, TimeoutException, CommunicationException {
        this.currentRequestID = this.driverConnection.nextRequestID();
        reqMsg.markSubmissionStart();
        reqMsg.setExecutionPayload(this.payload);
        reqMsg.setDoubleQuotedVariableAllowed(Boolean.valueOf(this.getExecutionProperty("allowDoubleQuotedVariable")).booleanValue());
        String sqlOptions = this.getExecutionProperty("sqlOptions");
        if (sqlOptions != null && sqlOptions.toUpperCase().indexOf("SHOWPLAN".toUpperCase()) >= 0) {
            reqMsg.setShowPlan(true);
        }
        reqMsg.setFetchSize(this.getFetchSize());
        reqMsg.setStyleSheet(this.styleSheet);
        reqMsg.setRowLimit(this.maxRows);
        this.copyPropertiesToRequest(reqMsg, this.getConnectionProperties());
        reqMsg.setExecutionId(this.currentRequestID);
        ResultsFuture pendingResult = null;
        try {
            pendingResult = this.getDQP().executeRequest(this.currentRequestID, reqMsg);
        }
        catch (MetaMatrixException e) {
            throw MMSQLException.create(e);
        }
        long timeoutMillis = this.queryTimeout * 1000;
        long endTime = System.currentTimeMillis() + timeoutMillis;
        ResultsMessage result = null;
        while (result == null) {
            if (timeoutMillis > 0L && endTime <= System.currentTimeMillis() && this.commandStatus != 4 && this.commandStatus != 3) {
                this.timeoutOccurred();
            }
            this.checkStatement();
            try {
                result = (ResultsMessage)pendingResult.get(SPIN_TIMEOUT, TimeUnit.MILLISECONDS);
            }
            catch (ExecutionException e) {
                throw MMSQLException.create(e);
            }
            catch (TimeoutException e) {
            }
        }
        if (this.commandStatus == 3) {
            throw new MMSQLException(JDBCPlugin.Util.getString("MMStatement.Cancel_before_execute"));
        }
        if (this.commandStatus == 4) {
            throw new TimeoutException(JDBCPlugin.Util.getString("MMStatement.Timeout_before_complete"));
        }
        return result;
    }

    long getCurrentRequestID() {
        return this.currentRequestID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attachStylesheet(Reader reader) throws IOException {
        BufferedReader bufferedReader = null;
        StringBuffer buffer = new StringBuffer();
        try {
            String line;
            bufferedReader = new BufferedReader(reader);
            while ((line = bufferedReader.readLine()) != null) {
                buffer.append(line);
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        this.styleSheet = buffer.toString();
    }

    @Override
    public void clearStylesheet() {
        this.styleSheet = null;
    }

    void setPlanDescription(Map planDescription) {
        this.currentPlanDescription = planDescription;
    }

    void setDebugLog(String debugLog) {
        this.debugLog = debugLog;
    }

    void setAnnotations(List annotations) {
        this.annotations = annotations;
    }

    @Override
    public PlanNode getPlanDescription() {
        Map planDescription = null;
        if (this.resultSet != null) {
            planDescription = this.resultSet.getUpdatedPlanDescription();
        }
        if (planDescription != null) {
            this.currentPlanDescription = planDescription;
            return PlanNodeImpl.constructFromMap(this.currentPlanDescription);
        }
        if (this.currentPlanDescription != null) {
            return PlanNodeImpl.constructFromMap(this.currentPlanDescription);
        }
        return null;
    }

    @Override
    public String getDebugLog() {
        return this.debugLog;
    }

    @Override
    public Collection getAnnotations() {
        return this.annotations;
    }

    public void setPartialResults(boolean isPartialResults) {
        if (isPartialResults) {
            this.execProps.put("partialResultsMode", "true");
        }
    }

    @Override
    public String getRequestIdentifier() {
        if (this.currentRequestID >= 0L) {
            return Long.toString(this.currentRequestID);
        }
        return null;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    protected void setAnalysisInfo(ResultsMessage resultsMsg) {
        this.debugLog = resultsMsg.getDebugLog();
        this.currentPlanDescription = resultsMsg.getPlanDescription();
        Collection serverAnnotations = resultsMsg.getAnnotations();
        if (serverAnnotations != null) {
            ArrayList<AnnotationImpl> annotations = new ArrayList<AnnotationImpl>(serverAnnotations.size());
            for (String[] serverAnnotation : serverAnnotations) {
                AnnotationImpl annotation = new AnnotationImpl(serverAnnotation);
                annotations.add(annotation);
            }
            this.annotations = annotations;
        }
    }

    Calendar getDefaultCalendar() {
        if (this.defaultCalendar == null) {
            this.defaultCalendar = Calendar.getInstance();
        }
        return this.defaultCalendar;
    }

    void setDefaultCalendar(Calendar cal) {
        this.defaultCalendar = cal;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkStatement();
        return false;
    }

    @Override
    public void setPoolable(boolean arg0) throws SQLException {
        this.checkStatement();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.driverConnection;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}

