/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.MMConnection;
import com.metamatrix.jdbc.MMXAResource;
import com.metamatrix.jdbc.api.Connection;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.util.HashSet;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.StatementEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;

public class MMXAConnection
implements XAConnection {
    private HashSet listeners;
    private XAResource resource;
    private MMConnection connection;
    private ConnectionSource cs;
    private boolean isClosed;

    public static MMXAConnection newInstance(ConnectionSource cs) {
        return new MMXAConnection(cs);
    }

    public MMXAConnection(ConnectionSource cs) {
        this.cs = cs;
    }

    @Override
    public java.sql.Connection getConnection() throws SQLException {
        MMConnection conn = this.getMMConnection();
        java.sql.Connection result = (java.sql.Connection)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)new CloseInterceptor(conn));
        return result;
    }

    MMConnection getMMConnection() throws SQLException {
        if (this.isClosed) {
            throw new SQLException(JDBCPlugin.Util.getString("MMXAConnection.connection_is_closed"));
        }
        if (this.connection == null) {
            try {
                this.connection = this.cs.createConnection();
            }
            catch (SQLException e) {
                this.notifyListener(e);
                throw e;
            }
        }
        return this.connection;
    }

    @Override
    public synchronized void addConnectionEventListener(ConnectionEventListener listener) {
        if (this.listeners == null) {
            this.listeners = new HashSet();
        }
        this.listeners.add(listener);
    }

    @Override
    public synchronized void removeConnectionEventListener(ConnectionEventListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    @Override
    public XAResource getXAResource() throws SQLException {
        if (this.resource == null) {
            this.resource = MMXAResource.newInstance(this);
        }
        return this.resource;
    }

    @Override
    public void close() throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.close();
        }
        this.isClosed = true;
    }

    protected synchronized void notifyListener(SQLException e) {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            for (ConnectionEventListener listener : this.listeners) {
                if (e == null) {
                    listener.connectionClosed(new ConnectionEvent(this));
                    continue;
                }
                listener.connectionErrorOccurred(new ConnectionEvent(this, e));
            }
        }
    }

    @Override
    public void addStatementEventListener(StatementEventListener arg0) {
    }

    @Override
    public void removeStatementEventListener(StatementEventListener arg0) {
    }

    private final class CloseInterceptor
    implements InvocationHandler {
        private MMConnection proxiedConnection;

        CloseInterceptor(MMConnection connection) {
            this.proxiedConnection = connection;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("close".equals(method.getName())) {
                this.proxiedConnection.recycleConnection();
                MMXAConnection.this.notifyListener(null);
                return null;
            }
            try {
                return method.invoke((Object)this.proxiedConnection, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }

    static interface ConnectionSource {
        public MMConnection createConnection() throws SQLException;
    }
}

