/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.sql.BatchUpdateException;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.teiid.client.DQP;
import org.teiid.client.RequestMessage;
import org.teiid.client.ResultsMessage;
import org.teiid.client.metadata.ParameterInfo;
import org.teiid.client.metadata.ResultsMetadataConstants;
import org.teiid.client.plan.Annotation;
import org.teiid.client.plan.PlanNode;
import org.teiid.client.util.ResultsFuture;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.JDBCSQLTypeInfo;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.util.SqlUtil;
import org.teiid.core.util.StringUtil;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.DataTypeTransformer;
import org.teiid.jdbc.EnhancedTimer;
import org.teiid.jdbc.JDBCPlugin;
import org.teiid.jdbc.MetadataProvider;
import org.teiid.jdbc.NonBlockingRowProcessor;
import org.teiid.jdbc.RequestOptions;
import org.teiid.jdbc.ResultSetImpl;
import org.teiid.jdbc.ResultSetMetaDataImpl;
import org.teiid.jdbc.StatementCallback;
import org.teiid.jdbc.TeiidSQLException;
import org.teiid.jdbc.TeiidStatement;
import org.teiid.jdbc.WarningUtil;
import org.teiid.jdbc.WrapperImpl;

public class StatementImpl
extends WrapperImpl
implements TeiidStatement {
    private static Logger logger = Logger.getLogger("org.teiid.jdbc");
    static EnhancedTimer cancellationTimer = new EnhancedTimer("Teiid Statement Timeout");
    protected static final int NO_TIMEOUT = 0;
    private static final int NO_LIMIT = 0;
    private QueryTimeoutCancelTask cancelTask = new QueryTimeoutCancelTask(this);
    private ConnectionImpl driverConnection;
    private Properties execProps;
    private int fetchSize = 2048;
    private int fetchDirection = 1000;
    private int resultSetType = 1003;
    private int resultSetConcurrency = 1007;
    private boolean isClosed = false;
    protected volatile State commandStatus = State.RUNNING;
    protected long queryTimeoutMS = 0L;
    protected long currentRequestID = -1L;
    private PlanNode currentPlanDescription;
    private String debugLog;
    private Collection<Annotation> annotations;
    protected volatile ResultSetImpl resultSet;
    private List<Throwable> serverWarnings;
    private Serializable payload;
    private List<String> batchedUpdates;
    protected int[] updateCounts;
    private Calendar defaultCalendar;
    private int maxRows = 0;
    private int maxFieldSize = 0;
    protected Map<Integer, Integer> outParamIndexMap = new HashMap<Integer, Integer>();
    protected Map<String, Integer> outParamByName = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
    private boolean closeOnCompletion;
    static Pattern TRANSACTION_STATEMENT = Pattern.compile("\\s*(commit|rollback|(start\\s+transaction))\\s*;?\\s*", 2);
    static Pattern SET_STATEMENT = Pattern.compile("\\s*set(?:\\s+(payload))?\\s+((?:session authorization)|(?:[a-zA-Z]\\w*)|(?:\"[^\"]*\")+)\\s+(?:to\\s+)?((?:[^\\s]*)|(?:'[^']*')+)\\s*;?\\s*", 2);
    static Pattern SET_CHARACTERISTIC_STATEMENT = Pattern.compile("\\s*set\\s+session\\s+characteristics\\s+as\\s+transaction\\s+isolation\\s+level\\s+((?:read\\s+(?:(?:committed)|(?:uncommitted)))|(?:repeatable\\s+read)|(?:serializable))\\s*", 2);
    static Pattern SHOW_STATEMENT = Pattern.compile("\\s*show\\s+([a-zA-Z]\\w*|(?:\"[^\"]*\")+)\\s*;?\\s*?", 2);

    StatementImpl(ConnectionImpl driverConnection, int resultSetType, int resultSetConcurrency) {
        this.driverConnection = driverConnection;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.execProps = new Properties(this.driverConnection.getExecutionProperties());
        String fetchSizeStr = this.execProps.getProperty("fetchSize");
        if (fetchSizeStr != null) {
            try {
                this.fetchSize = Integer.parseInt(fetchSizeStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setTimeoutFromProperties();
    }

    private void setTimeoutFromProperties() {
        String queryTimeoutStr = this.execProps.getProperty("QUERYTIMEOUT");
        if (queryTimeoutStr != null) {
            try {
                this.queryTimeoutMS = Integer.parseInt(queryTimeoutStr) * 1000;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected DQP getDQP() {
        return this.driverConnection.getDQP();
    }

    protected ConnectionImpl getMMConnection() {
        return this.driverConnection;
    }

    protected TimeZone getServerTimeZone() throws SQLException {
        return this.driverConnection.getServerConnection().getLogonResult().getTimeZone();
    }

    protected synchronized void resetExecutionState() throws SQLException {
        this.currentRequestID = -1L;
        this.currentPlanDescription = null;
        this.debugLog = null;
        this.annotations = null;
        if (this.resultSet != null) {
            ResultSetImpl rs = this.resultSet;
            this.resultSet = null;
            rs.close();
            this.checkStatement();
        }
        this.serverWarnings = null;
        this.batchedUpdates = null;
        this.updateCounts = null;
        this.outParamIndexMap.clear();
        this.outParamByName.clear();
        this.commandStatus = State.RUNNING;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.checkStatement();
        if (this.batchedUpdates == null) {
            this.batchedUpdates = new ArrayList<String>();
        }
        this.batchedUpdates.add(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() throws SQLException {
        long request = 0L;
        StatementImpl statementImpl = this;
        synchronized (statementImpl) {
            this.commandStatus = State.CANCELLED;
            this.checkStatement();
            request = this.currentRequestID;
            if (request == -1L) {
                return;
            }
        }
        try {
            this.getDQP().cancelRequest(request);
        }
        catch (TeiidProcessingException e) {
            throw TeiidSQLException.create(e);
        }
        catch (TeiidComponentException e) {
            throw TeiidSQLException.create(e);
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkStatement();
        this.serverWarnings = null;
    }

    @Override
    public void clearBatch() throws SQLException {
        if (this.batchedUpdates != null) {
            this.batchedUpdates.clear();
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        if (this.resultSet != null) {
            ResultSetImpl rs = this.resultSet;
            this.resultSet = null;
            rs.close();
        }
        this.isClosed = true;
        this.driverConnection.closeStatement(this);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(JDBCPlugin.Util.getString("MMStatement.Close_stmt_success"));
        }
    }

    protected void checkStatement() throws TeiidSQLException {
        this.driverConnection.checkConnection();
        if (this.isClosed) {
            throw new TeiidSQLException(JDBCPlugin.Util.getString("MMStatement.Stmt_closed"));
        }
    }

    @Override
    public void submitExecute(String sql, StatementCallback callback, RequestOptions options) throws SQLException {
        NonBlockingRowProcessor processor = new NonBlockingRowProcessor(this, callback);
        this.submitExecute(sql, options).addCompletionListener(processor);
    }

    public ResultsFuture<Boolean> submitExecute(String sql, RequestOptions options) throws SQLException {
        return this.executeSql(new String[]{sql}, false, RequestMessage.ResultsMode.EITHER, false, options);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.execute(sql, 2);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        if (this.batchedUpdates == null || this.batchedUpdates.isEmpty()) {
            return new int[0];
        }
        String[] commands = this.batchedUpdates.toArray(new String[this.batchedUpdates.size()]);
        this.executeSql(commands, true, RequestMessage.ResultsMode.UPDATECOUNT, true, null);
        return this.updateCounts;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.executeSql(new String[]{sql}, false, RequestMessage.ResultsMode.RESULTSET, true, null);
        return this.resultSet;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return this.executeUpdate(sql, 2);
    }

    protected boolean hasResultSet() throws SQLException {
        return this.updateCounts == null && this.resultSet != null && this.resultSet.getMetaData().getColumnCount() > 0;
    }

    protected void createResultSet(ResultsMessage resultsMsg) throws SQLException {
        List listOfParameters = resultsMsg.getParameters();
        if (listOfParameters != null) {
            int resultIndex;
            int resultSetSize = 0;
            for (ParameterInfo parameter : listOfParameters) {
                if (parameter.getType() != 5) continue;
                resultSetSize = parameter.getNumColumns();
                break;
            }
            int index = 0;
            int count = 0;
            for (ParameterInfo parameter : listOfParameters) {
                if (parameter.getType() != 4) continue;
                resultIndex = resultSetSize + ++count;
                this.outParamIndexMap.put(++index, resultIndex);
                this.outParamByName.put(resultsMsg.getColumnNames()[resultIndex - 1].toUpperCase(), resultIndex);
                break;
            }
            for (ParameterInfo parameter : listOfParameters) {
                if (parameter.getType() == 4 || parameter.getType() == 5) continue;
                ++index;
                if (parameter.getType() != 2 && parameter.getType() != 3) continue;
                resultIndex = resultSetSize + ++count;
                this.outParamIndexMap.put(index, resultIndex);
                this.outParamByName.put(resultsMsg.getColumnNames()[resultIndex - 1].toUpperCase(), resultIndex);
            }
        }
        ResultSetMetaData metadata = null;
        if (this.updateCounts != null) {
            metadata = this.createResultSetMetaData(this.createMetadataMap(resultsMsg.getColumnNames(), resultsMsg.getDataTypes()));
        }
        this.resultSet = new ResultSetImpl(resultsMsg, this, metadata, this.outParamIndexMap.size());
        this.resultSet.setMaxFieldSize(this.maxFieldSize);
    }

    protected ResultsFuture<Boolean> executeSql(String[] commands, boolean isBatchedCommand, RequestMessage.ResultsMode resultsMode, boolean synch, RequestOptions options) throws SQLException {
        return this.executeSql(commands, isBatchedCommand, resultsMode, synch, options, false);
    }

    protected ResultsFuture<Boolean> executeSql(String[] commands, boolean isBatchedCommand, RequestMessage.ResultsMode resultsMode, boolean synch, RequestOptions options, boolean autoGenerateKeys) throws SQLException {
        this.checkStatement();
        this.resetExecutionState();
        if (options != null && options.isContinuous()) {
            if (!this.driverConnection.getServerConnection().supportsContinuous()) {
                throw new TeiidSQLException(JDBCPlugin.Util.getString("JDBC.continuous"));
            }
            if (this.getResultSetType() != 1003) {
                String msg = JDBCPlugin.Util.getString("JDBC.forward_only_resultset");
                throw new TeiidSQLException(msg);
            }
            if (resultsMode == RequestMessage.ResultsMode.EITHER) {
                resultsMode = RequestMessage.ResultsMode.RESULTSET;
            } else if (resultsMode == RequestMessage.ResultsMode.UPDATECOUNT) {
                String msg = JDBCPlugin.Util.getString("JDBC.forward_only_resultset");
                throw new TeiidSQLException(msg);
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Executing: requestID " + this.getCurrentRequestID() + " commands: " + Arrays.toString(commands) + " expecting: " + (Object)((Object)resultsMode));
        }
        if (commands.length == 1) {
            Matcher match = SET_STATEMENT.matcher(commands[0]);
            if (match.matches()) {
                if (resultsMode == RequestMessage.ResultsMode.RESULTSET) {
                    throw new TeiidSQLException(JDBCPlugin.Util.getString("StatementImpl.set_result_set"));
                }
                String val = match.group(2);
                String key = this.unescapeId(val);
                String value = match.group(3);
                if (value != null && value.startsWith("'") && value.endsWith("'")) {
                    value = value.substring(1, value.length() - 1);
                    value = StringUtil.replaceAll((String)value, (String)"''", (String)"'");
                }
                if (match.group(1) != null) {
                    Properties p = this.getMMConnection().getPayload();
                    if (p == null) {
                        p = new Properties();
                        this.getMMConnection().setPayload(p);
                    }
                    p.setProperty(key, value);
                } else if (val == key && "SESSION AUTHORIZATION".equalsIgnoreCase(key)) {
                    this.getMMConnection().changeUser(value, this.getMMConnection().getPassword());
                } else if (key.equalsIgnoreCase("password")) {
                    this.getMMConnection().setPassword(value);
                } else if ("NEWINSTANCE".equalsIgnoreCase(key)) {
                    if (Boolean.valueOf(value).booleanValue()) {
                        this.getMMConnection().getServerConnection().cleanUp();
                    }
                } else {
                    this.driverConnection.setExecutionProperty(key, value);
                }
                this.updateCounts = new int[]{0};
                return StatementImpl.booleanFuture(false);
            }
            match = SET_CHARACTERISTIC_STATEMENT.matcher(commands[0]);
            if (match.matches()) {
                String value = match.group(1);
                if (StringUtil.endsWithIgnoreCase((String)value, (String)"uncommitted")) {
                    this.getMMConnection().setTransactionIsolation(1);
                } else if (StringUtil.endsWithIgnoreCase((String)value, (String)"committed")) {
                    this.getMMConnection().setTransactionIsolation(2);
                } else if (StringUtil.startsWithIgnoreCase((String)value, (String)"repeatable")) {
                    this.getMMConnection().setTransactionIsolation(4);
                } else if ("serializable".equalsIgnoreCase(value)) {
                    this.getMMConnection().setTransactionIsolation(8);
                }
                this.updateCounts = new int[]{0};
                return StatementImpl.booleanFuture(false);
            }
            match = TRANSACTION_STATEMENT.matcher(commands[0]);
            if (match.matches()) {
                logger.finer("Executing as transaction statement");
                if (resultsMode == RequestMessage.ResultsMode.RESULTSET) {
                    throw new TeiidSQLException(JDBCPlugin.Util.getString("StatementImpl.set_result_set"));
                }
                String command = match.group(1);
                Boolean commit = null;
                if (StringUtil.startsWithIgnoreCase((String)command, (String)"start")) {
                    this.getConnection().setAutoCommit(false);
                } else if (command.equalsIgnoreCase("commit")) {
                    commit = true;
                    if (synch) {
                        this.getConnection().setAutoCommit(true);
                    }
                } else if (command.equalsIgnoreCase("rollback")) {
                    commit = false;
                    if (synch || !this.getConnection().isInLocalTxn()) {
                        this.getConnection().rollback(false);
                    }
                }
                this.updateCounts = new int[]{0};
                if (commit != null && !synch) {
                    ResultsFuture<?> pending = this.getConnection().submitSetAutoCommitTrue(commit);
                    final ResultsFuture<Boolean> result = new ResultsFuture<Boolean>();
                    pending.addCompletionListener(new ResultsFuture.CompletionListener(){

                        public void onCompletion(ResultsFuture future) {
                            try {
                                future.get();
                                result.getResultsReceiver().receiveResults(false);
                            }
                            catch (Throwable t) {
                                result.getResultsReceiver().exceptionOccurred(t);
                            }
                        }
                    });
                    return result;
                }
                return StatementImpl.booleanFuture(false);
            }
            match = SHOW_STATEMENT.matcher(commands[0]);
            if (match.matches()) {
                logger.finer("Executing as show statement");
                if (resultsMode == RequestMessage.ResultsMode.UPDATECOUNT) {
                    throw new TeiidSQLException(JDBCPlugin.Util.getString("StatementImpl.show_update_count"));
                }
                return this.executeShow(match);
            }
        }
        final RequestMessage reqMessage = this.createRequestMessage(commands, isBatchedCommand, resultsMode);
        reqMessage.setReturnAutoGeneratedKeys(autoGenerateKeys);
        reqMessage.setRequestOptions(options);
        ResultsFuture<ResultsMessage> pendingResult = this.execute(reqMessage, synch);
        final ResultsFuture<Boolean> result = new ResultsFuture<Boolean>();
        pendingResult.addCompletionListener(new ResultsFuture.CompletionListener<ResultsMessage>(){

            @Override
            public void onCompletion(ResultsFuture<ResultsMessage> future) {
                try {
                    StatementImpl.this.postReceiveResults(reqMessage, future.get());
                    result.getResultsReceiver().receiveResults(StatementImpl.this.hasResultSet());
                }
                catch (Throwable t) {
                    result.getResultsReceiver().exceptionOccurred(t);
                }
            }
        });
        if (synch) {
            try {
                pendingResult.get(this.queryTimeoutMS == 0L ? Integer.MAX_VALUE : this.queryTimeoutMS, TimeUnit.MILLISECONDS);
                result.get();
                return result;
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof SQLException) {
                    throw (SQLException)e.getCause();
                }
                if (e.getCause() != null) {
                    throw TeiidSQLException.create(e.getCause());
                }
                throw TeiidSQLException.create(e);
            }
            catch (InterruptedException e) {
                this.timeoutOccurred();
            }
            catch (TimeoutException e) {
                this.timeoutOccurred();
            }
            throw new TeiidSQLException(JDBCPlugin.Util.getString("MMStatement.Timeout_before_complete"));
        }
        return result;
    }

    private String unescapeId(String key) {
        if (key.startsWith("\"")) {
            key = key.substring(1, key.length() - 1);
            key = StringUtil.replaceAll((String)key, (String)"\"\"", (String)"\"");
        }
        return key;
    }

    ResultsFuture<Boolean> executeShow(Matcher match) throws SQLException {
        String show = match.group(1);
        if ((show = this.unescapeId(show)).equalsIgnoreCase("PLAN")) {
            ArrayList records = new ArrayList(1);
            PlanNode plan = this.driverConnection.getCurrentPlanDescription();
            String connDebugLog = this.driverConnection.getDebugLog();
            if (plan != null || connDebugLog != null) {
                ArrayList<Clob> row = new ArrayList<Clob>(3);
                if (plan != null) {
                    row.add(DataTypeTransformer.getClob(plan.toString()));
                    row.add((Clob)new SQLXMLImpl(plan.toXml()));
                } else {
                    row.add(null);
                    row.add(null);
                }
                row.add(DataTypeTransformer.getClob(connDebugLog));
                records.add(row);
            }
            this.createResultSet(records, new String[]{"PLAN_TEXT", "PLAN_XML", "DEBUG_LOG"}, new String[]{"clob", "xml", "clob"});
            return StatementImpl.booleanFuture(true);
        }
        if (show.equalsIgnoreCase("ANNOTATIONS")) {
            ArrayList records = new ArrayList(1);
            Collection<Annotation> annos = this.driverConnection.getAnnotations();
            for (Annotation annotation : annos) {
                ArrayList<String> row = new ArrayList<String>(4);
                row.add(annotation.getCategory());
                row.add(annotation.getPriority().name());
                row.add(annotation.getAnnotation());
                row.add(annotation.getResolution());
                records.add(row);
            }
            this.createResultSet(records, new String[]{"CATEGORY", "PRIORITY", "ANNOTATION", "RESOLUTION"}, new String[]{"string", "string", "string", "string"});
            return StatementImpl.booleanFuture(true);
        }
        if (show.equalsIgnoreCase("ALL")) {
            ArrayList records = new ArrayList(1);
            for (String key : this.driverConnection.getExecutionProperties().stringPropertyNames()) {
                ArrayList<Object> row = new ArrayList<Object>(4);
                row.add(key);
                row.add(this.driverConnection.getExecutionProperties().get(key));
                records.add(row);
            }
            this.createResultSet(records, new String[]{"NAME", "VALUE"}, new String[]{"string", "string"});
            return StatementImpl.booleanFuture(true);
        }
        List<List<String>> records = Collections.singletonList(Collections.singletonList(this.driverConnection.getExecutionProperty(show)));
        this.createResultSet(records, new String[]{show}, new String[]{"string"});
        return StatementImpl.booleanFuture(true);
    }

    private ResultsFuture<ResultsMessage> execute(RequestMessage reqMsg, boolean synch) throws SQLException, TeiidSQLException {
        this.getConnection().beginLocalTxnIfNeeded();
        this.currentRequestID = this.driverConnection.nextRequestID();
        if (this.payload != null) {
            reqMsg.setExecutionPayload(this.payload);
        } else {
            reqMsg.setExecutionPayload(this.getMMConnection().getPayload());
        }
        reqMsg.setDelaySerialization(true);
        reqMsg.setCursorType(this.resultSetType);
        reqMsg.setFetchSize(this.fetchSize);
        reqMsg.setRowLimit(this.maxRows);
        reqMsg.setTransactionIsolation(this.driverConnection.getTransactionIsolation());
        reqMsg.setSync(synch && this.useCallingThread());
        this.copyPropertiesToRequest(reqMsg);
        reqMsg.setExecutionId(this.currentRequestID);
        ResultsFuture.CompletionListener<ResultsMessage> compeletionListener = null;
        if (this.queryTimeoutMS > 0L && (!synch || this.driverConnection.getServerConnection().isLocal())) {
            final EnhancedTimer.Task c = cancellationTimer.add(this.cancelTask, this.queryTimeoutMS);
            compeletionListener = new ResultsFuture.CompletionListener<ResultsMessage>(){

                @Override
                public void onCompletion(ResultsFuture<ResultsMessage> future) {
                    c.cancel();
                }
            };
        }
        ResultsFuture<ResultsMessage> pendingResult = null;
        try {
            pendingResult = this.getDQP().executeRequest(this.currentRequestID, reqMsg);
        }
        catch (TeiidException e) {
            throw TeiidSQLException.create(e);
        }
        if (compeletionListener != null) {
            pendingResult.addCompletionListener(compeletionListener);
        }
        return pendingResult;
    }

    boolean useCallingThread() throws SQLException {
        if (this.getConnection().getServerConnection() == null || !this.getConnection().getServerConnection().isLocal()) {
            return false;
        }
        String useCallingThread = this.getExecutionProperty("useCallingThread");
        return useCallingThread == null || Boolean.valueOf(useCallingThread) != false;
    }

    public static ResultsFuture<Boolean> booleanFuture(boolean isTrue) {
        ResultsFuture<Boolean> rs = new ResultsFuture<Boolean>();
        rs.getResultsReceiver().receiveResults(isTrue);
        return rs;
    }

    private synchronized void postReceiveResults(RequestMessage reqMessage, ResultsMessage resultsMsg) throws TeiidSQLException, SQLException {
        this.commandStatus = State.DONE;
        List<Throwable> resultsWarning = resultsMsg.getWarnings();
        this.setAnalysisInfo(resultsMsg);
        if (!(resultsMsg.getException() == null || resultsMsg.isUpdateResult() && resultsMsg.getResultsList() != null)) {
            throw TeiidSQLException.create(resultsMsg.getException());
        }
        if (resultsWarning != null) {
            this.accumulateWarnings(resultsWarning);
        }
        resultsMsg.processResults();
        if (resultsMsg.isUpdateResult()) {
            List<List<?>> results = resultsMsg.getResultsList();
            if (resultsMsg.getUpdateCount() == -1) {
                this.updateCounts = new int[results.size()];
                for (int i = 0; i < results.size(); ++i) {
                    this.updateCounts[i] = (Integer)results.get(i).get(0);
                }
            } else {
                this.updateCounts = new int[]{resultsMsg.getUpdateCount()};
                this.createResultSet(resultsMsg);
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Recieved update counts: " + Arrays.toString(this.updateCounts));
            }
            try {
                this.getDQP().closeRequest(this.getCurrentRequestID());
            }
            catch (TeiidProcessingException e) {
                throw TeiidSQLException.create(e);
            }
            catch (TeiidComponentException e) {
                throw TeiidSQLException.create(e);
            }
            if (resultsMsg.getException() != null) {
                TeiidSQLException exe = TeiidSQLException.create(resultsMsg.getException());
                BatchUpdateException batchUpdateException = new BatchUpdateException(exe.getMessage(), exe.getSQLState(), exe.getErrorCode(), this.updateCounts, (Throwable)exe);
                this.updateCounts = null;
                throw batchUpdateException;
            }
        } else {
            this.createResultSet(resultsMsg);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(JDBCPlugin.Util.getString("MMStatement.Success_query", new Object[]{reqMessage.getCommandString()}));
        }
    }

    protected RequestMessage createRequestMessage(String[] commands, boolean isBatchedCommand, RequestMessage.ResultsMode resultsMode) {
        RequestMessage reqMessage = new RequestMessage();
        reqMessage.setCommands(commands);
        reqMessage.setBatchedUpdate(isBatchedCommand);
        reqMessage.setResultsMode(resultsMode);
        return reqMessage;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.checkStatement();
        if ((current == 3 || current == 1) && this.resultSet != null) {
            this.resultSet.close();
            this.resultSet = null;
        }
        this.updateCounts = null;
        return false;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkStatement();
        return (int)this.queryTimeoutMS / 1000;
    }

    @Override
    public ResultSetImpl getResultSet() throws SQLException {
        this.checkStatement();
        if (!this.hasResultSet()) {
            return null;
        }
        return this.resultSet;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetType() {
        return this.resultSetType;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkStatement();
        if (this.updateCounts == null) {
            return -1;
        }
        if (this.updateCounts.length == 0) {
            return 0;
        }
        return this.updateCounts[0];
    }

    protected void accumulateWarnings(List<Throwable> serverWarnings) {
        if (serverWarnings == null || serverWarnings.isEmpty()) {
            return;
        }
        if (this.serverWarnings == null) {
            this.serverWarnings = new ArrayList<Throwable>();
        }
        this.serverWarnings.addAll(serverWarnings);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkStatement();
        if (this.serverWarnings != null && this.serverWarnings.size() != 0) {
            return WarningUtil.convertWarnings(this.serverWarnings);
        }
        return null;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkStatement();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkStatement();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkStatement();
        if (rows < 0) {
            String msg = JDBCPlugin.Util.getString("MMStatement.Invalid_fetch_size");
            throw new TeiidSQLException(msg);
        }
        this.fetchSize = rows == 0 ? 2048 : rows;
    }

    @Override
    public void setMaxRows(int maxRows) throws SQLException {
        this.checkStatement();
        if (maxRows < 0 || maxRows == Integer.MAX_VALUE) {
            maxRows = 0;
        }
        this.maxRows = maxRows;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkStatement();
        if (seconds < 0) {
            throw new TeiidSQLException(JDBCPlugin.Util.getString("MMStatement.Bad_timeout_value"));
        }
        this.queryTimeoutMS = seconds * 1000;
    }

    void setQueryTimeoutMS(int queryTimeoutMS) {
        this.queryTimeoutMS = queryTimeoutMS;
    }

    protected void copyPropertiesToRequest(RequestMessage res) throws TeiidSQLException {
        String noExec;
        String partial = this.getExecutionProperty("partialResultsMode");
        res.setPartialResults(Boolean.valueOf(partial));
        String validate = this.getExecutionProperty("XMLValidation");
        if (validate == null) {
            res.setValidationMode(false);
        } else {
            res.setValidationMode(Boolean.valueOf(validate));
        }
        String format = this.getExecutionProperty("XMLFormat");
        res.setXMLFormat(format);
        String txnAutoWrapMode = this.getExecutionProperty("autoCommitTxn");
        try {
            res.setTxnAutoWrapMode(txnAutoWrapMode);
        }
        catch (TeiidProcessingException e) {
            throw TeiidSQLException.create(e);
        }
        String rsCache = this.getExecutionProperty("resultSetCacheMode");
        res.setUseResultSetCache(Boolean.valueOf(rsCache));
        res.setAnsiQuotedIdentifiers(Boolean.valueOf(this.getExecutionProperty("ansiQuotedIdentifiers")));
        String showPlan = this.getExecutionProperty("SHOWPLAN");
        if (showPlan != null) {
            try {
                res.setShowPlan(RequestMessage.ShowPlan.valueOf(showPlan.toUpperCase()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ((noExec = this.getExecutionProperty("NOEXEC")) != null) {
            res.setNoExec(noExec.equalsIgnoreCase("ON"));
        }
    }

    protected synchronized void timeoutOccurred() {
        if (this.commandStatus != State.RUNNING) {
            return;
        }
        logger.warning(JDBCPlugin.Util.getString("MMStatement.Timeout_ocurred_in_Statement."));
        try {
            this.cancel();
            this.commandStatus = State.TIMED_OUT;
            this.queryTimeoutMS = 0L;
            this.setTimeoutFromProperties();
            this.currentRequestID = -1L;
            if (this.resultSet != null) {
                this.resultSet.close();
            }
        }
        catch (SQLException se) {
            logger.log(Level.FINE, JDBCPlugin.Util.getString("MMStatement.Error_timing_out."), se);
        }
    }

    @Override
    public void setPayload(Serializable payload) {
        this.payload = payload;
    }

    @Override
    public void setExecutionProperty(String name, String value) {
        this.execProps.setProperty(name, value);
    }

    @Override
    public String getExecutionProperty(String name) {
        return this.execProps.getProperty(name);
    }

    long getCurrentRequestID() {
        return this.currentRequestID;
    }

    @Override
    public PlanNode getPlanDescription() {
        if (this.resultSet != null) {
            return this.resultSet.getUpdatedPlanDescription();
        }
        if (this.currentPlanDescription != null) {
            return this.currentPlanDescription;
        }
        return null;
    }

    @Override
    public String getDebugLog() {
        return this.debugLog;
    }

    @Override
    public Collection<Annotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public String getRequestIdentifier() {
        if (this.currentRequestID >= 0L) {
            return Long.toString(this.currentRequestID);
        }
        return null;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    protected void setAnalysisInfo(ResultsMessage resultsMsg) {
        if (resultsMsg.getDebugLog() != null) {
            this.debugLog = resultsMsg.getDebugLog();
        }
        if (resultsMsg.getPlanDescription() != null) {
            this.currentPlanDescription = resultsMsg.getPlanDescription();
        }
        if (resultsMsg.getAnnotations() != null) {
            this.annotations = resultsMsg.getAnnotations();
        }
        this.driverConnection.setDebugLog(this.debugLog);
        this.driverConnection.setCurrentPlanDescription(this.currentPlanDescription);
        this.driverConnection.setAnnotations(this.annotations);
    }

    Calendar getDefaultCalendar() {
        if (this.defaultCalendar == null) {
            this.defaultCalendar = Calendar.getInstance();
        }
        return this.defaultCalendar;
    }

    void setDefaultCalendar(Calendar cal) {
        this.defaultCalendar = cal;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkStatement();
        return false;
    }

    @Override
    public void setPoolable(boolean arg0) throws SQLException {
        this.checkStatement();
    }

    @Override
    public ConnectionImpl getConnection() throws SQLException {
        return this.driverConnection;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.executeSql(new String[]{sql}, false, RequestMessage.ResultsMode.EITHER, true, null, autoGeneratedKeys == 1);
        return this.hasResultSet();
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.execute(sql, 1);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.execute(sql, 1);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.executeSql(new String[]{sql}, false, RequestMessage.ResultsMode.UPDATECOUNT, true, null, autoGeneratedKeys == 1);
        if (this.updateCounts == null) {
            return 0;
        }
        return this.updateCounts[0];
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.executeUpdate(sql, 1);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.executeUpdate(sql, 1);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        if (this.updateCounts != null && this.resultSet != null) {
            return this.resultSet;
        }
        return this.createResultSet(Collections.emptyList(), new Map[0]);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.checkStatement();
        if (max < 0) {
            throw new TeiidSQLException(JDBCPlugin.Util.getString("MMStatement.Invalid_field_size", new Object[]{max}));
        }
        this.maxFieldSize = max;
    }

    ResultSetImpl createResultSet(List records, String[] columnNames, String[] dataTypes) throws SQLException {
        Map[] metadata = this.createMetadataMap(columnNames, dataTypes);
        return this.createResultSet(records, metadata);
    }

    private Map[] createMetadataMap(String[] columnNames, String[] dataTypes) throws SQLException {
        Map[] metadata = new Map[columnNames.length];
        for (int i = 0; i < columnNames.length; ++i) {
            metadata[i] = StatementImpl.getColumnMetadata(null, columnNames[i], dataTypes[i], ResultsMetadataConstants.NULL_TYPES.UNKNOWN, this.driverConnection);
        }
        return metadata;
    }

    ResultSetImpl createResultSet(List records, Map[] columnMetadata) throws SQLException {
        ResultSetMetaData rsmd = this.createResultSetMetaData(columnMetadata);
        return this.createResultSet(records, rsmd);
    }

    private ResultSetMetaData createResultSetMetaData(Map[] columnMetadata) {
        ResultSetMetaDataImpl rsmd = new ResultSetMetaDataImpl(new MetadataProvider(columnMetadata), this.getExecutionProperty("useJDBC4ColumnNameAndLabelSemantics"));
        return rsmd;
    }

    ResultSetImpl createResultSet(List records, ResultSetMetaData rsmd) throws SQLException {
        if (rsmd.getColumnCount() > 0) {
            rsmd.getScale(1);
        }
        ResultsMessage resultsMsg = StatementImpl.createDummyResultsMessage(null, null, records);
        this.resultSet = new ResultSetImpl(resultsMsg, this, rsmd, 0);
        this.resultSet.setMaxFieldSize(this.maxFieldSize);
        return this.resultSet;
    }

    static ResultsMessage createDummyResultsMessage(String[] columnNames, String[] dataTypes, List records) {
        ResultsMessage resultsMsg = new ResultsMessage();
        resultsMsg.setColumnNames(columnNames);
        resultsMsg.setDataTypes(dataTypes);
        resultsMsg.setFirstRow(1);
        resultsMsg.setLastRow(records.size());
        resultsMsg.setFinalRow(records.size());
        resultsMsg.setResults(records.toArray(new List[records.size()]));
        return resultsMsg;
    }

    static Map<Integer, Object> getColumnMetadata(String tableName, String columnName, String dataType, Integer nullable, ConnectionImpl driverConnection) throws SQLException {
        return StatementImpl.getColumnMetadata(tableName, columnName, dataType, nullable, ResultsMetadataConstants.SEARCH_TYPES.UNSEARCHABLE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, driverConnection);
    }

    static Map<Integer, Object> getColumnMetadata(String tableName, String columnName, String dataType, Integer nullable, Integer searchable, Boolean writable, Boolean signed, Boolean caseSensitive, ConnectionImpl driverConnection) throws SQLException {
        HashMap<Integer, Object> metadataMap = new HashMap<Integer, Object>();
        metadataMap.put(ResultsMetadataConstants.VIRTUAL_DATABASE_NAME, driverConnection.getVDBName());
        metadataMap.put(ResultsMetadataConstants.GROUP_NAME, tableName);
        metadataMap.put(ResultsMetadataConstants.ELEMENT_NAME, columnName);
        metadataMap.put(ResultsMetadataConstants.DATA_TYPE, dataType);
        metadataMap.put(ResultsMetadataConstants.PRECISION, JDBCSQLTypeInfo.getDefaultPrecision((String)dataType));
        metadataMap.put(ResultsMetadataConstants.RADIX, new Integer(10));
        metadataMap.put(ResultsMetadataConstants.SCALE, new Integer(0));
        metadataMap.put(ResultsMetadataConstants.AUTO_INCREMENTING, Boolean.FALSE);
        metadataMap.put(ResultsMetadataConstants.CASE_SENSITIVE, caseSensitive);
        metadataMap.put(ResultsMetadataConstants.NULLABLE, nullable);
        metadataMap.put(ResultsMetadataConstants.SEARCHABLE, searchable);
        metadataMap.put(ResultsMetadataConstants.SIGNED, signed);
        metadataMap.put(ResultsMetadataConstants.WRITABLE, writable);
        metadataMap.put(ResultsMetadataConstants.CURRENCY, Boolean.FALSE);
        metadataMap.put(ResultsMetadataConstants.DISPLAY_SIZE, JDBCSQLTypeInfo.getMaxDisplaySize((String)dataType));
        return metadataMap;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.closeOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.closeOnCompletion;
    }

    static enum State {
        RUNNING,
        DONE,
        TIMED_OUT,
        CANCELLED;

    }

    private static final class QueryTimeoutCancelTask
    implements Runnable {
        private WeakReference<StatementImpl> ref;

        private QueryTimeoutCancelTask(StatementImpl stmt) {
            this.ref = new WeakReference<StatementImpl>(stmt);
        }

        @Override
        public void run() {
            StatementImpl stmt = (StatementImpl)this.ref.get();
            if (stmt != null) {
                stmt.timeoutOccurred();
            }
        }
    }
}

