/*
 * JBoss, Home of Professional Open Source.
 * See the COPYRIGHT.txt file distributed with this work for information
 * regarding copyright ownership.  Some portions may be licensed
 * to Red Hat, Inc. under one or more contributor license agreements.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 */

package com.metamatrix.common.vdb.api;

import java.io.InputStream;

public interface VDBFile {

    /**
     * Get the path to the file represented by this record in the
     * vdb.  
     * @return The path to the file in the vdb
     * @since 4.2
     */
    String getPathInVdb();
	
	/**
     * Get the contents of the file in the VDB.
     * @return A inputstream as the vdb resource content.
     * @since 4.2
     */
    InputStream getContent();

    /**
     * Get the length of the file this record represents 
     * @return Lenth of the file
     * @since 4.2
     */
    long getFileLength();

}
