/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.api.core.message;

import com.metamatrix.api.core.message.Message;
import com.metamatrix.api.core.message.MessageTypes;
import com.metamatrix.common.CommonPlugin;
import java.util.StringTokenizer;

public class DefaultMessage
implements Message,
MessageTypes {
    private static final int PRIME = 1000003;
    private String text;
    private int type;
    private Object target;

    public static Message createErrorMessage(String text) {
        return DefaultMessage.createErrorMessage(text, null);
    }

    public static Message createErrorMessage(String text, Object target) {
        return new DefaultMessage(text, 3, target);
    }

    public static Message createNotificationMessage(String text) {
        return DefaultMessage.createNotificationMessage(text, null);
    }

    public static Message createNotificationMessage(String text, Object target) {
        return new DefaultMessage(text, 1, target);
    }

    public static Message createWarningMessage(String text) {
        return DefaultMessage.createWarningMessage(text, null);
    }

    public static Message createWarningMessage(String text, Object target) {
        return new DefaultMessage(text, 2, target);
    }

    public DefaultMessage() {
        this(null, 0);
    }

    public DefaultMessage(String text) {
        this(text, 1);
    }

    public DefaultMessage(String text, int type) {
        this(text, type, null);
    }

    public DefaultMessage(String text, int type, Object target) {
        this.constructDefaultMessage(text, type, target);
    }

    public DefaultMessage(Message message) {
        this.setMessage(message);
    }

    public void clear() {
        this.setType(0);
    }

    protected void constructDefaultMessage(String text, int type, Object target) {
        this.set(text, type, target);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Message)) {
            return false;
        }
        Message msg = (Message)object;
        String msgText = msg.getText();
        String text = this.getText();
        return (text == msgText || text != null && text.equals(msgText)) && this.getType() == msg.getType() && this.getTarget() == msg.getTarget();
    }

    @Override
    public Object getTarget() {
        return this.target;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public int getType() {
        return this.type;
    }

    public int hashCode() {
        int code = this.text == null ? 0 : this.text.hashCode();
        code = 1000003 * code + this.type;
        return this.target == null ? 1000003 * code : 1000003 * code + this.target.hashCode();
    }

    public void set(String text) {
        this.set(text, 1);
    }

    public void set(String text, int type) {
        this.set(text, type, null);
    }

    public void set(String text, int type, Object target) {
        this.setType(type);
        this.setText(text);
        this.setTarget(target);
    }

    public void setMessage(Message message) {
        if (message == null) {
            throw new NullPointerException(CommonPlugin.Util.getString("ERR.003.003.0003"));
        }
        this.set(message.getText(), message.getType(), message.getTarget());
    }

    public void setTarget(Object target) {
        if (target != null && this.type == 0) {
            throw new IllegalStateException(CommonPlugin.Util.getString("ERR.003.003.0004"));
        }
        this.target = target;
    }

    public void setText(String text) {
        if (text != null && this.type == 0) {
            throw new IllegalStateException(CommonPlugin.Util.getString("ERR.003.003.0005"));
        }
        this.text = this.removeEscapeSequences(text);
    }

    public void setType(int type) {
        if (type == 0) {
            this.setText(null);
            this.setTarget(null);
        }
        this.type = type;
    }

    public String toString() {
        return this.getText();
    }

    private String removeEscapeSequences(String value) {
        String next;
        StringTokenizer s;
        boolean hasTabs;
        if (value == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        boolean hasNewLine = value.indexOf("\n") != -1;
        boolean hasReturn = value.indexOf("\r") != -1;
        boolean bl = hasTabs = value.indexOf("\t") != -1;
        if (hasNewLine) {
            s = new StringTokenizer(value, "\n");
            while (s.hasMoreTokens()) {
                next = s.nextToken();
                buffer.append(next + " ");
            }
            value = buffer.toString().trim();
        }
        if (hasReturn) {
            s = new StringTokenizer(value, "\r");
            while (s.hasMoreTokens()) {
                next = s.nextToken();
                buffer.append(next + " ");
            }
            value = buffer.toString().trim();
        }
        if (hasTabs) {
            s = new StringTokenizer(value, "\t");
            while (s.hasMoreTokens()) {
                next = s.nextToken();
                buffer.append(next + " ");
            }
            value = buffer.toString().trim();
        }
        return value;
    }
}

