/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.api.core.xmi;

import com.metamatrix.api.core.xmi.FeatureInfo;
import com.metamatrix.common.CommonPlugin;
import org.xml.sax.Attributes;

public class EntityInfo {
    private String metamodelURI;
    private String metaClassName;
    private String qMetaClassName;
    private String parentId;
    private String entityName;
    private String entityID;
    private String entityUUID;
    private Attributes attributes;
    private String entityHref;
    private String entityLabel;
    private String entityIDRef;
    private final FeatureInfo ownerFeature;

    public EntityInfo(FeatureInfo ownerFeature, String metaClassName) {
        this(ownerFeature, metaClassName, null);
    }

    public EntityInfo(FeatureInfo ownerFeature, String metaClassName, String uri) {
        if (metaClassName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.003.0013"));
        }
        if (metaClassName.length() == 0) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.003.0014"));
        }
        this.metaClassName = metaClassName;
        this.qMetaClassName = uri + ":" + metaClassName;
        this.metamodelURI = uri;
        this.ownerFeature = ownerFeature;
        this.entityName = metaClassName;
    }

    public String getMetaClassName() {
        return this.metaClassName;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String id) {
        this.parentId = id;
    }

    public String getQMetaClassName() {
        return this.qMetaClassName;
    }

    public void setQMetaClassName(String uri, String metaClassName) {
        if (metaClassName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.003.0013"));
        }
        if (metaClassName.length() == 0) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.003.0014"));
        }
        if (uri == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.003.0015"));
        }
        if (uri.length() == 0) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.003.0016"));
        }
        this.qMetaClassName = uri + ":" + metaClassName;
    }

    public void setMetaClassName(String metaClassName) {
        if (metaClassName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.003.0013"));
        }
        if (metaClassName.length() == 0) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.003.0014"));
        }
        this.metaClassName = metaClassName;
    }

    public String getName() {
        return this.entityName;
    }

    public void setName(String name) {
        this.entityName = name;
    }

    public String getMetaModelURI() {
        return this.metamodelURI;
    }

    public void setMetaModelURI(String uri) {
        this.metamodelURI = uri;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.getMetaModelURI() != null) {
            sb.append(this.getMetaModelURI());
            sb.append(":");
        }
        sb.append(this.getMetaClassName());
        sb.append("=");
        sb.append(this.getName());
        return sb.toString();
    }

    public String getID() {
        return this.entityID;
    }

    public void setID(String xmiID) {
        this.entityID = xmiID;
    }

    public String getUUID() {
        return this.entityUUID;
    }

    public void setUUID(String uuid) {
        this.entityUUID = uuid;
    }

    public String getHref() {
        return this.entityHref;
    }

    public void setHref(String href) {
        this.entityHref = href;
    }

    public String getLabel() {
        return this.entityLabel;
    }

    public void setLabel(String label) {
        this.entityLabel = label;
    }

    public String getIDRef() {
        return this.entityIDRef;
    }

    public void setIDRef(String entityIDRef) {
        this.entityIDRef = entityIDRef;
    }

    public FeatureInfo getOwnerFeatureInfo() {
        return this.ownerFeature;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Attributes attributes) {
        this.attributes = attributes;
    }
}

