/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.actions;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.actions.ActionDefinition;
import com.metamatrix.common.actions.ModificationActionQueue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

public class BasicModificationActionQueue
implements ModificationActionQueue,
Serializable {
    private LinkedList actions = new LinkedList();

    @Override
    public synchronized List popActions() {
        List result = null;
        if (!this.actions.isEmpty()) {
            result = this.actions;
            this.actions = new LinkedList();
        } else {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    @Override
    public synchronized List popActions(int count) {
        int stop;
        int n = stop = count < this.actions.size() ? count : this.actions.size();
        if (stop == 0) {
            return Collections.EMPTY_LIST;
        }
        LinkedList result = new LinkedList(this.actions);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActionDefinition getLast() throws NoSuchElementException {
        ActionDefinition lastAction = null;
        LinkedList linkedList = this.actions;
        synchronized (linkedList) {
            lastAction = (ActionDefinition)this.actions.getLast();
        }
        return (ActionDefinition)lastAction.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActionDefinition removeLast() throws NoSuchElementException {
        Object result = null;
        LinkedList linkedList = this.actions;
        synchronized (linkedList) {
            result = this.actions.removeLast();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAction(ActionDefinition newAction) {
        if (newAction == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.004.0006"));
        }
        LinkedList linkedList = this.actions;
        synchronized (linkedList) {
            this.actions.add(newAction);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addActions(List newActions) {
        if (newActions == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.004.0007"));
        }
        LinkedList linkedList = this.actions;
        synchronized (linkedList) {
            this.actions.addAll(newActions);
        }
        return newActions.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addActions(ModificationActionQueue queue) {
        if (queue == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.004.0008"));
        }
        List newActions = queue.popActions();
        LinkedList linkedList = this.actions;
        synchronized (linkedList) {
            this.actions.addAll(newActions);
        }
        return newActions.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getActions() {
        ArrayList result = null;
        LinkedList linkedList = this.actions;
        synchronized (linkedList) {
            result = new ArrayList(this.actions);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public synchronized int getActionCount() {
        return this.actions.size();
    }

    @Override
    public synchronized boolean hasActions() {
        return !this.actions.isEmpty();
    }

    @Override
    public synchronized void clear() {
        this.actions.clear();
    }

    public synchronized String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("BasicModificationActionQueue contents\n");
        sb.append("  Action count      : ");
        sb.append(this.actions.size());
        sb.append('\n');
        Iterator iter = this.actions.iterator();
        ActionDefinition action = null;
        int i = 0;
        while (iter.hasNext()) {
            action = (ActionDefinition)iter.next();
            sb.append("  Action #");
            sb.append(i);
            sb.append(": ");
            sb.append(action.toString());
            sb.append('\n');
            ++i;
        }
        return sb.toString();
    }
}

