/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.actions;

import com.metamatrix.common.actions.ActionDefinition;
import com.metamatrix.common.actions.AttributeDefinition;
import com.metamatrix.common.actions.ExchangePrimitive;

public class ExchangeDouble
extends ExchangePrimitive {
    private double previousValue;
    private double newValue;

    public ExchangeDouble(Object target, AttributeDefinition attribute, double previousValue, double newValue) {
        super(target, attribute);
        this.previousValue = previousValue;
        this.newValue = newValue;
    }

    private ExchangeDouble(Object target, Integer attributeCode, double previousValue, double newValue) {
        super(target, attributeCode);
        this.previousValue = previousValue;
        this.newValue = newValue;
    }

    private ExchangeDouble(ExchangeDouble rhs) {
        super(rhs);
        this.previousValue = rhs.previousValue;
        this.newValue = rhs.newValue;
    }

    public synchronized double getPreviousValue() {
        return this.previousValue;
    }

    public synchronized double getNewValue() {
        return this.newValue;
    }

    @Override
    public String toString() {
        return this.getActionDescription() + "; new value = " + this.newValue + ", previous value = " + this.previousValue;
    }

    @Override
    public synchronized Object clone() {
        return new ExchangeDouble(this);
    }

    public synchronized boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ExchangeDouble) {
            ExchangeDouble that = (ExchangeDouble)obj;
            return this.getNewValue() == that.getNewValue() && this.getPreviousValue() == that.getPreviousValue();
        }
        return false;
    }

    @Override
    public synchronized ActionDefinition getUndoActionDefinition() {
        return new ExchangeDouble(this.getTarget(), this.getAttributeCode(), this.newValue, this.previousValue);
    }
}

