/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.actions;

import com.metamatrix.common.actions.ActionDefinition;
import com.metamatrix.common.actions.AttributeDefinition;
import com.metamatrix.common.actions.ExchangePrimitive;

public class ExchangeFloat
extends ExchangePrimitive {
    private float previousValue;
    private float newValue;

    public ExchangeFloat(Object target, AttributeDefinition attribute, float previousValue, float newValue) {
        super(target, attribute);
        this.previousValue = previousValue;
        this.newValue = newValue;
    }

    private ExchangeFloat(Object target, Integer attributeCode, float previousValue, float newValue) {
        super(target, attributeCode);
        this.previousValue = previousValue;
        this.newValue = newValue;
    }

    private ExchangeFloat(ExchangeFloat rhs) {
        super(rhs);
        this.previousValue = rhs.previousValue;
        this.newValue = rhs.newValue;
    }

    public synchronized float getPreviousValue() {
        return this.previousValue;
    }

    public synchronized float getNewValue() {
        return this.newValue;
    }

    @Override
    public String toString() {
        return this.getActionDescription() + "; new value = " + this.newValue + ", previous value = " + this.previousValue;
    }

    @Override
    public synchronized Object clone() {
        return new ExchangeFloat(this);
    }

    public synchronized boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ExchangeFloat) {
            ExchangeFloat that = (ExchangeFloat)obj;
            return this.getNewValue() == that.getNewValue() && this.getPreviousValue() == that.getPreviousValue();
        }
        return false;
    }

    @Override
    public synchronized ActionDefinition getUndoActionDefinition() {
        return new ExchangeFloat(this.getTarget(), this.getAttributeCode(), this.newValue, this.previousValue);
    }
}

