/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.actions;

import com.metamatrix.common.actions.ActionDefinition;
import com.metamatrix.common.actions.AttributeDefinition;
import com.metamatrix.common.actions.ExchangePrimitive;

public class ExchangeLong
extends ExchangePrimitive {
    private long previousValue;
    private long newValue;

    public ExchangeLong(Object target, AttributeDefinition attribute, long previousValue, long newValue) {
        super(target, attribute);
        this.previousValue = previousValue;
        this.newValue = newValue;
    }

    private ExchangeLong(Object target, Integer attributeCode, long previousValue, long newValue) {
        super(target, attributeCode);
        this.previousValue = previousValue;
        this.newValue = newValue;
    }

    private ExchangeLong(ExchangeLong rhs) {
        super(rhs);
        this.previousValue = rhs.previousValue;
        this.newValue = rhs.newValue;
    }

    public synchronized long getPreviousValue() {
        return this.previousValue;
    }

    public synchronized long getNewValue() {
        return this.newValue;
    }

    @Override
    public String toString() {
        return this.getActionDescription() + "; new value = " + this.newValue + ", previous value = " + this.previousValue;
    }

    @Override
    public synchronized Object clone() {
        return new ExchangeLong(this);
    }

    public synchronized boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ExchangeLong) {
            ExchangeLong that = (ExchangeLong)obj;
            return this.getNewValue() == that.getNewValue() && this.getPreviousValue() == that.getPreviousValue();
        }
        return false;
    }

    @Override
    public synchronized ActionDefinition getUndoActionDefinition() {
        return new ExchangeLong(this.getTarget(), this.getAttributeCode(), this.newValue, this.previousValue);
    }
}

