/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.config;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.config.StartupStateException;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.Host;
import com.metamatrix.common.config.api.HostID;
import com.metamatrix.common.config.api.ResourceModel;
import com.metamatrix.common.config.api.SharedResource;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.config.model.BasicHost;
import com.metamatrix.common.config.reader.CurrentConfigurationReader;
import com.metamatrix.common.config.reader.PropertiesConfigurationReader;
import com.metamatrix.common.properties.UnmodifiableProperties;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.core.MetaMatrixRuntimeException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;

public final class CurrentConfiguration {
    public static final String BOOTSTRAP_FILE_NAME = "metamatrix.properties";
    public static final String CONFIGURATION_READER_CLASS_PROPERTY_NAME = "metamatrix.config.reader";
    public static final String CLUSTER_NAME = "metamatrix.cluster.name";
    public static final String CONFIGURATION_NAME = "configuration.name";
    private CurrentConfigurationReader reader;
    private Properties bootstrapProperties;
    private Properties systemBootstrapProperties;
    private static CurrentConfiguration INSTANCE = new CurrentConfiguration();

    public static CurrentConfiguration getInstance() {
        return INSTANCE;
    }

    private CurrentConfiguration() {
    }

    public String getClusterName() throws ConfigurationException {
        Properties props = this.getResourceProperties("JGroups");
        return props.getProperty(CLUSTER_NAME, "Teiid-Cluster");
    }

    public Properties getProperties() {
        try {
            Properties result = this.getReader().getConfigurationModel().getConfiguration().getProperties();
            Properties copyResult = PropertiesUtils.clone((Properties)result, (Properties)this.getBootStrapProperties(), (boolean)false, (boolean)true);
            if (!(copyResult instanceof UnmodifiableProperties)) {
                copyResult = new UnmodifiableProperties(copyResult);
            }
            return copyResult;
        }
        catch (ConfigurationException e) {
            throw new MetaMatrixRuntimeException((Throwable)((Object)e));
        }
    }

    public Properties getResourceProperties(String resourceName) throws ConfigurationException {
        Properties props;
        SharedResource sr = this.getReader().getConfigurationModel().getResource(resourceName);
        if (sr != null) {
            props = ResourceModel.getDefaultProperties(resourceName);
            props.putAll((Map<?, ?>)sr.getProperties());
        } else {
            props = new Properties();
        }
        PropertiesUtils.setOverrideProperies((Properties)props, (Properties)this.getSystemBootStrapProperties());
        UnmodifiableProperties result = new UnmodifiableProperties(props);
        return result;
    }

    public Configuration getConfiguration() throws ConfigurationException {
        Configuration config = this.getReader().getConfigurationModel().getConfiguration();
        if (config == null) {
            throw new ConfigurationException("ERR.003.001.0021", CommonPlugin.Util.getString("ERR.003.001.0021"));
        }
        return config;
    }

    public ConfigurationModelContainer getConfigurationModel() throws ConfigurationException {
        ConfigurationModelContainer config = null;
        try {
            config = this.getReader().getConfigurationModel();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        if (config == null) {
            throw new ConfigurationException("ERR.003.001.0022", CommonPlugin.Util.getString("ERR.003.001.0022"));
        }
        return config;
    }

    public Collection getComponentTypes(boolean includeDeprecated) throws ConfigurationException {
        return this.getReader().getConfigurationModel().getComponentTypes().values();
    }

    public Collection getProductTypes() throws ConfigurationException {
        return this.getReader().getConfigurationModel().getProductTypes();
    }

    public Host getDefaultHost() throws ConfigurationException {
        String name = this.getBootStrapProperties().getProperty(CONFIGURATION_NAME);
        BasicHost host = new BasicHost(new ConfigurationID(name), new HostID(name), Host.HOST_COMPONENT_TYPE_ID);
        Properties props = new Properties();
        props.setProperty("metamatrix.installationDir", this.getBootStrapProperties().getProperty("metamatrix.installationDir", System.getProperty("user.dir")));
        props.setProperty("metamatrix.host.dir", this.getBootStrapProperties().getProperty("metamatrix.host.dir", System.getProperty("user.dir")));
        props.setProperty("metamatrix.log.dir", this.getBootStrapProperties().getProperty("metamatrix.log.dir", System.getProperty("user.dir")));
        props.setProperty("metamatrix.host.bind.address", this.getBootStrapProperties().getProperty("metamatrix.host.bind.address", ""));
        props.setProperty("metamatrix.host.physical.address", this.getBootStrapProperties().getProperty("metamatrix.host.physical.address", ""));
        host.setProperties(props);
        return host;
    }

    public final synchronized void reset() throws ConfigurationException {
        this.reader = null;
        this.bootstrapProperties = null;
        this.systemBootstrapProperties = null;
    }

    public final void performSystemInitialization(boolean forceInitialization) throws StartupStateException, ConfigurationException {
        this.getReader().performSystemInitialization(forceInitialization);
        this.reset();
    }

    public final void indicateSystemShutdown() throws ConfigurationException {
        this.getReader().indicateSystemShutdown();
    }

    public synchronized Properties getBootStrapProperties() throws ConfigurationException {
        if (this.bootstrapProperties == null) {
            Properties systemBootStrapProps = this.getSystemBootStrapProperties();
            Properties bootstrapProps = new Properties(systemBootStrapProps);
            InputStream bootstrapPropStream = null;
            try {
                bootstrapPropStream = this.getClass().getClassLoader().getResourceAsStream(BOOTSTRAP_FILE_NAME);
                if (bootstrapPropStream != null) {
                    bootstrapProps.load(bootstrapPropStream);
                }
            }
            catch (IOException e) {
                throw new ConfigurationException("ERR.003.001.0069", CommonPlugin.Util.getString("ERR.003.001.0069", new Object[]{BOOTSTRAP_FILE_NAME}));
            }
            finally {
                try {
                    if (bootstrapPropStream != null) {
                        bootstrapPropStream.close();
                    }
                }
                catch (IOException e) {}
            }
            this.bootstrapProperties = new UnmodifiableProperties(bootstrapProps);
        }
        return this.bootstrapProperties;
    }

    public final synchronized Properties getSystemBootStrapProperties() {
        if (this.systemBootstrapProperties == null) {
            this.systemBootstrapProperties = new UnmodifiableProperties(System.getProperties());
        }
        return this.systemBootstrapProperties;
    }

    public final void verifyBootstrapProperties() throws ConfigurationException {
        this.getReader();
    }

    synchronized CurrentConfigurationReader getReader() throws ConfigurationException {
        if (this.reader == null) {
            CurrentConfigurationReader tempReader;
            Properties bootstrap = this.getBootStrapProperties();
            String readerClassName = bootstrap.getProperty(CONFIGURATION_READER_CLASS_PROPERTY_NAME, PropertiesConfigurationReader.class.getName());
            try {
                Class<?> readerClass = Class.forName(readerClassName);
                tempReader = (CurrentConfigurationReader)readerClass.newInstance();
            }
            catch (Exception e) {
                throw new ConfigurationException(e);
            }
            tempReader.connect(bootstrap);
            this.reader = tempReader;
        }
        return this.reader;
    }
}

