/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.config;

import com.metamatrix.api.exception.MetaMatrixException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class StartupStateException
extends MetaMatrixException {
    private int startupState;
    private static final String DEFAULT_MESSAGE_BEGIN = "Current startup state ";
    private static final String DEFAULT_MESSAGE_MIDDLE = " could not be changed to ";

    public StartupStateException() {
    }

    public StartupStateException(String message, int startupState) {
        super(message);
        this.startupState = startupState;
    }

    public StartupStateException(int desiredStartupState, int startupState) {
        super(StartupStateException.generateDefaultMessage(desiredStartupState, startupState));
        this.startupState = startupState;
    }

    public int getStartupState() {
        return this.startupState;
    }

    private static final String generateDefaultMessage(int desiredStartupState, int startupState) {
        StringBuffer s = new StringBuffer(DEFAULT_MESSAGE_BEGIN);
        switch (startupState) {
            case 0: {
                s.append("STOPPED");
                break;
            }
            case 1: {
                s.append("STARTING");
                break;
            }
            case 2: {
                s.append("STARTED");
            }
        }
        s.append(DEFAULT_MESSAGE_MIDDLE);
        switch (desiredStartupState) {
            case 0: {
                s.append("STOPPED");
                break;
            }
            case 1: {
                s.append("STARTING");
                break;
            }
            case 2: {
                s.append("STARTED");
            }
        }
        s.append(".");
        return s.toString();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.startupState = in.readInt();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.startupState);
    }
}

