/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.config.api;

import com.metamatrix.common.config.api.ConfigurationID;
import java.util.Date;

public class LockedConfigurationID
extends ConfigurationID {
    private ConfigurationID originalID;
    private String version;
    private String lockHolder;
    private long lockAcquiredAt;

    public LockedConfigurationID(ConfigurationID id, String versionName, String lockHolder, long lockAcquiredAt) {
        super(id != null ? id.getFullName() : "");
        if (id == null || versionName == null || lockHolder == null) {
            throw new IllegalArgumentException("A null parameter has been passed when identifying a locked configuration");
        }
        this.originalID = id;
        this.version = versionName;
        this.lockHolder = lockHolder;
        this.lockAcquiredAt = lockAcquiredAt;
    }

    public ConfigurationID getOriginalID() {
        return this.originalID;
    }

    public String getVersion() {
        return this.version;
    }

    public String getLockHolder() {
        return this.lockHolder;
    }

    public long getTimeOfAcquisitionAsLong() {
        return this.lockAcquiredAt;
    }

    public Date getTimeOfAcquisition() {
        return new Date(this.lockAcquiredAt);
    }

    @Override
    public int compareTo(Object obj) {
        return this.originalID.compareTo(obj);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return this.originalID.equals(obj);
    }

    @Override
    public synchronized Object clone() throws CloneNotSupportedException {
        LockedConfigurationID result = null;
        try {
            result = new LockedConfigurationID(this.originalID, this.version, this.lockHolder, this.lockAcquiredAt);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

