/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.config.api;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ConfigurationObjectEditor;
import com.metamatrix.common.config.model.BasicConfigurationObjectEditor;
import com.metamatrix.common.config.xml.XMLConfigurationImportExportUtility;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public final class ResourceModel {
    private static Map resourceDefns = new HashMap(20);
    private static final String RESOURCE_MODEL_FILE = "com/metamatrix/common/config/api/resourcetypemodel.xml";

    public static ComponentType getComponentType(String resourceName) {
        if (resourceDefns.containsKey(resourceName)) {
            return (ComponentType)resourceDefns.get(resourceName);
        }
        return null;
    }

    public static Properties getDefaultProperties(String resourceName) {
        ComponentType ct = null;
        if (resourceDefns.containsKey(resourceName)) {
            ct = (ComponentType)resourceDefns.get(resourceName);
            return ct.getDefaultPropertyValues();
        }
        return new Properties();
    }

    static {
        try {
            InputStream input = ClassLoader.getSystemResourceAsStream(RESOURCE_MODEL_FILE);
            if (input == null) {
                throw new RuntimeException(CommonPlugin.Util.getString("ResourceModel.Resource_model_file_not_found", new Object[]{RESOURCE_MODEL_FILE}));
            }
            XMLConfigurationImportExportUtility importutil = new XMLConfigurationImportExportUtility();
            Collection componentTypes = importutil.importComponentTypes(input, (ConfigurationObjectEditor)new BasicConfigurationObjectEditor(false));
            for (ComponentType ct : componentTypes) {
                resourceDefns.put(ct.getFullName(), ct);
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e.getMessage());
        }
    }
}

