/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.config.model;

import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ComponentTypeDefn;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.model.ConfigurationVisitor;
import com.metamatrix.common.namedobject.BaseID;
import com.metamatrix.common.namedobject.BasicObject;
import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.core.util.DateUtil;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class BasicComponentType
extends BasicObject
implements ComponentType,
Serializable {
    public static final long serialVersionUID = 5972706380742168742L;
    private HashMap typeDefinitions;
    private HashMap typeDefnsByName;
    private ComponentTypeID parentTypeID;
    private ComponentTypeID superTypeID;
    private boolean isDeployable;
    private boolean isDeprecated;
    private boolean isMonitored;
    private int componentTypeCode = -1;
    private String description = null;
    private String createdBy;
    private String createdDate;
    private Date createdDDate;
    private String lastChangedBy;
    private String lastChangedDate;
    private Date lastChangedDDate;

    BasicComponentType(ComponentTypeID id, ComponentTypeID parentID, ComponentTypeID superID, boolean deployable, boolean deprecated, boolean monitored) {
        super(id);
        this.parentTypeID = parentID;
        this.superTypeID = superID;
        this.isDeployable = deployable;
        this.isDeprecated = deprecated;
        this.isMonitored = monitored;
    }

    protected BasicComponentType(BasicComponentType type) {
        super(type.getID());
        this.setIsDeployable(type.isDeployable());
        this.setIsDeprecated(type.isDeprecated());
        this.setIsMonitored(type.isMonitored());
        this.setComponentTypeCode(type.getComponentTypeCode());
        if (type.getParentComponentTypeID() != null) {
            this.setParentComponentTypeID(type.getParentComponentTypeID());
        }
        if (type.getSuperComponentTypeID() != null) {
            this.setSuperComponentTypeID(type.getSuperComponentTypeID());
        }
        this.setCreatedBy(type.getCreatedBy());
        this.setCreatedDate(type.getCreatedDateString());
        this.setLastChangedBy(type.getLastChangedBy());
        this.setLastChangedDate(type.getLastChangedDateString());
    }

    @Override
    public Collection getComponentTypeDefinitions() {
        if (this.typeDefinitions == null) {
            this.typeDefinitions = new HashMap(10);
            this.typeDefnsByName = new HashMap(10);
        }
        ArrayList tds = new ArrayList(this.typeDefinitions.size());
        tds.addAll(this.typeDefinitions.values());
        return tds;
    }

    @Override
    public ComponentTypeDefn getComponentTypeDefinition(String name) {
        if (this.typeDefnsByName != null) {
            return (ComponentTypeDefn)this.typeDefnsByName.get(name);
        }
        return null;
    }

    @Override
    public String getDefaultValue(String propertyName) {
        Object value;
        ComponentTypeDefn ctd = this.getComponentTypeDefinition(propertyName);
        if (ctd != null && (value = ctd.getPropertyDefinition().getDefaultValue()) != null) {
            if (value instanceof String) {
                String v = (String)value;
                return v;
            }
            return value.toString();
        }
        return null;
    }

    @Override
    public Properties getDefaultPropertyValues() {
        Properties result = new Properties();
        Collection defns = this.getComponentTypeDefinitions();
        for (ComponentTypeDefn ctd : defns) {
            Object value = ctd.getPropertyDefinition().getDefaultValue();
            if (value == null) continue;
            if (value instanceof String) {
                String v = (String)value;
                if (v.trim().length() <= 0) continue;
                result.put(ctd.getPropertyDefinition().getName(), v);
                continue;
            }
            result.put(ctd.getPropertyDefinition().getName(), value.toString());
        }
        return result;
    }

    @Override
    public Collection getMaskedPropertyNames() {
        ArrayList<String> maskedPropNames = new ArrayList<String>();
        Collection defns = this.getComponentTypeDefinitions();
        for (ComponentTypeDefn ctd : defns) {
            PropertyDefinition propertyDefinition = ctd.getPropertyDefinition();
            String name = propertyDefinition.getName();
            if (!propertyDefinition.isMasked()) continue;
            maskedPropNames.add(name);
        }
        return maskedPropNames;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public ComponentTypeID getParentComponentTypeID() {
        return this.parentTypeID;
    }

    @Override
    public ComponentTypeID getSuperComponentTypeID() {
        return this.superTypeID;
    }

    @Override
    public int getComponentTypeCode() {
        return this.componentTypeCode;
    }

    @Override
    public boolean isDeployable() {
        return this.isDeployable;
    }

    @Override
    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    @Override
    public boolean isMonitored() {
        return this.isMonitored;
    }

    @Override
    public boolean isOfTypeConnector() {
        return false;
    }

    @Override
    public boolean isOfConnectorProductType() {
        return false;
    }

    @Override
    public boolean isOfTypeXAConnector() {
        return false;
    }

    @Override
    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @Override
    public Date getCreatedDate() {
        return this.createdDDate;
    }

    public String getCreatedDateString() {
        return this.createdDate;
    }

    public void setCreatedDate(String createdDate) {
        this.createdDate = createdDate;
        this.createdDDate = BasicComponentType.convertDate(createdDate);
    }

    @Override
    public String getLastChangedBy() {
        return this.lastChangedBy;
    }

    public void setLastChangedBy(String lastChangedBy) {
        this.lastChangedBy = lastChangedBy;
    }

    @Override
    public Date getLastChangedDate() {
        return this.lastChangedDDate;
    }

    public String getLastChangedDateString() {
        return this.lastChangedDate;
    }

    public void setLastChangedDate(String lastChangedDate) {
        this.lastChangedDate = lastChangedDate;
        this.lastChangedDDate = BasicComponentType.convertDate(lastChangedDate);
    }

    public void setComponentTypeDefinitions(Collection newDefinitions) {
        if (newDefinitions == null) {
            return;
        }
        this.typeDefinitions = new HashMap(newDefinitions.size());
        this.typeDefnsByName = new HashMap(newDefinitions.size());
        Collections.synchronizedMap(this.typeDefinitions);
        for (ComponentTypeDefn defn : newDefinitions) {
            this.typeDefinitions.put(defn.getID(), defn);
            this.typeDefnsByName.put(defn.getID().getFullName(), defn);
        }
    }

    public void setParentComponentTypeID(ComponentTypeID typeID) {
        this.parentTypeID = typeID;
    }

    public void setSuperComponentTypeID(ComponentTypeID typeID) {
        this.superTypeID = typeID;
    }

    void setIsDeployable(boolean deployable) {
        this.isDeployable = deployable;
    }

    public void setIsDeprecated(boolean deprecate) {
        this.isDeprecated = deprecate;
    }

    void setIsMonitored(boolean monitored) {
        this.isMonitored = monitored;
    }

    public void setComponentTypeCode(int code) {
        this.componentTypeCode = code;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public void addComponentTypeDefinition(ComponentTypeDefn defn) {
        if (this.typeDefinitions == null) {
            this.typeDefinitions = new HashMap();
            this.typeDefnsByName = new HashMap(10);
        }
        Map<BaseID, ComponentTypeDefn> defns = Collections.synchronizedMap(this.typeDefinitions);
        defns.put(defn.getID(), defn);
        this.typeDefnsByName.put(defn.getID().getName(), defn);
    }

    public void removeComponentTypeDefinition(ComponentTypeDefn defn) {
        if (this.typeDefinitions != null && this.typeDefinitions.containsKey(defn.getID())) {
            Map defns = Collections.synchronizedMap(this.typeDefinitions);
            defns.remove(defn.getID());
            this.typeDefnsByName.remove(defn.getID().getName());
        }
    }

    @Override
    public synchronized Object clone() {
        BasicComponentType result = null;
        result = new BasicComponentType(this);
        Collection defns = this.getComponentTypeDefinitions();
        result.setComponentTypeDefinitions(defns);
        return result;
    }

    private static Date convertDate(String date) {
        Date cd = null;
        if (date == null) {
            return new Date();
        }
        try {
            cd = DateUtil.convertStringToDate((String)date);
        }
        catch (ParseException e) {
            try {
                cd = DateFormat.getInstance().parse(date);
            }
            catch (ParseException iae) {
                cd = new Date();
            }
        }
        return cd;
    }

    @Override
    public void accept(ConfigurationVisitor visitor) {
        visitor.visitComponent(this);
    }
}

