/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.config.model;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.config.api.AuthenticationProvider;
import com.metamatrix.common.config.api.AuthenticationProviderID;
import com.metamatrix.common.config.api.ComponentDefn;
import com.metamatrix.common.config.api.ComponentDefnID;
import com.metamatrix.common.config.api.ComponentObject;
import com.metamatrix.common.config.api.ComponentObjectID;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationInfo;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.ConnectorBindingID;
import com.metamatrix.common.config.api.DeployedComponent;
import com.metamatrix.common.config.api.DeployedComponentID;
import com.metamatrix.common.config.api.Host;
import com.metamatrix.common.config.api.HostID;
import com.metamatrix.common.config.api.ProductServiceConfig;
import com.metamatrix.common.config.api.ProductServiceConfigID;
import com.metamatrix.common.config.api.ProductTypeID;
import com.metamatrix.common.config.api.ResourceDescriptor;
import com.metamatrix.common.config.api.ServiceComponentDefn;
import com.metamatrix.common.config.api.ServiceComponentDefnID;
import com.metamatrix.common.config.api.VMComponentDefn;
import com.metamatrix.common.config.api.VMComponentDefnID;
import com.metamatrix.common.config.model.BasicComponentDefn;
import com.metamatrix.common.config.model.BasicComponentObject;
import com.metamatrix.common.config.model.BasicConfigurationInfo;
import com.metamatrix.common.config.model.BasicDeployedComponent;
import com.metamatrix.common.config.model.BasicProductServiceConfig;
import com.metamatrix.common.config.model.BasicUtil;
import com.metamatrix.common.log.LogConfiguration;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.log.config.BasicLogConfiguration;
import com.metamatrix.common.log.config.LogConfigurationException;
import com.metamatrix.common.namedobject.BaseID;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.core.util.Assertion;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class BasicConfiguration
extends BasicComponentObject
implements Configuration,
Serializable {
    private BasicConfigurationInfo info;
    private Map pscs = new HashMap();
    private Map svcComponents = new HashMap();
    private Map connectors = new HashMap();
    private Map authProviders = new HashMap();
    private Map conRoutingToIDMap = new HashMap();
    private Map vms = new HashMap();
    private Map pools = new HashMap();
    private Map deployedComponents = new HashMap();
    private Map hosts = new HashMap();

    public BasicConfiguration(ConfigurationInfo configInfo, ComponentTypeID typeID) {
        super(configInfo.getID(), typeID);
        this.info = (BasicConfigurationInfo)configInfo;
    }

    BasicConfiguration(BasicConfiguration config) {
        super(config);
    }

    @Override
    public BaseID getID() {
        return this.info.getID();
    }

    @Override
    public String getName() {
        return this.info.getID().getName();
    }

    public boolean isNextStartUp() {
        return this.info.getID().equals(NEXT_STARTUP_ID);
    }

    public boolean isStartUp() {
        return this.info.getID().equals(STARTUP_ID);
    }

    @Override
    public ConfigurationInfo getInfo() {
        return this.info;
    }

    @Override
    public Map getComponentDefns() {
        int s = 1;
        if (this.pscs != null) {
            s += this.pscs.size();
        }
        if (this.svcComponents != null) {
            s += this.svcComponents.size();
        }
        if (this.vms != null) {
            s += this.vms.size();
        }
        if (this.hosts != null) {
            s += this.hosts.size();
        }
        if (this.pools != null) {
            s += this.pools.size();
        }
        if (this.authProviders != null) {
            s += this.authProviders.size();
        }
        if (this.connectors != null) {
            s += this.connectors.size();
        }
        HashMap comps = new HashMap(s);
        comps.putAll(this.pscs);
        comps.putAll(this.pools);
        comps.putAll(this.svcComponents);
        comps.putAll(this.vms);
        comps.putAll(this.authProviders);
        comps.putAll(this.connectors);
        comps.putAll(this.hosts);
        return comps;
    }

    public boolean doesExist(ComponentDefnID componentID) {
        switch (BasicUtil.getComponentType(componentID)) {
            case 5: {
                return this.getVMDefn(componentID) != null;
            }
            case 6: {
                return this.getPSC(componentID) != null;
            }
            case 1: {
                return this.getServiceComponentDefn(componentID) != null;
            }
            case 4: {
                return this.getConnectionPool(componentID) != null;
            }
            case 2: {
                return this.getConnectorBinding(componentID) != null;
            }
            case 11: {
                return this.getAuthenticationProvider(componentID) != null;
            }
            case 7: {
                return this.getHost(componentID) != null;
            }
        }
        Assertion.assertTrue((boolean)false, (String)("Process Error: component defn of type " + componentID.getClass().getName() + " not accounted for."));
        return false;
    }

    @Override
    public ComponentDefn getComponentDefn(ComponentDefnID componentID) {
        switch (BasicUtil.getComponentType(componentID)) {
            case 5: {
                return this.getVMDefn(componentID);
            }
            case 6: {
                return this.getPSC(componentID);
            }
            case 1: {
                return this.getServiceComponentDefn(componentID);
            }
            case 4: {
                return this.getConnectionPool(componentID);
            }
            case 2: {
                return this.getConnectorBinding(componentID);
            }
            case 7: {
                return this.getHost(componentID);
            }
            case 11: {
                return this.getAuthenticationProvider(componentID);
            }
        }
        Assertion.assertTrue((boolean)false, (String)("Process Error: component defn of type " + componentID.getClass().getName() + " not accounted for."));
        return null;
    }

    @Override
    public VMComponentDefn getVMComponentDefn(ComponentDefnID componentID) {
        return this.getVMDefn(componentID);
    }

    public VMComponentDefn getVMDefn(ComponentDefnID componentID) {
        if (this.vms.containsKey(componentID)) {
            return (VMComponentDefn)this.vms.get(componentID);
        }
        return null;
    }

    @Override
    public AuthenticationProvider getAuthenticationProvider(String name) {
        for (ComponentDefnID id : this.authProviders.keySet()) {
            if (!id.getFullName().equalsIgnoreCase(name)) continue;
            return (AuthenticationProvider)this.authProviders.get(id);
        }
        return null;
    }

    @Override
    public AuthenticationProvider getAuthenticationProvider(ComponentDefnID componentID) {
        if (this.authProviders.containsKey(componentID)) {
            return (AuthenticationProvider)this.authProviders.get(componentID);
        }
        return null;
    }

    @Override
    public ProductServiceConfig getPSC(ComponentDefnID componentID) {
        if (this.pscs.containsKey(componentID)) {
            return (ProductServiceConfig)this.pscs.get(componentID);
        }
        return null;
    }

    public ResourceDescriptor getConnectionPool(ComponentDefnID componentID) {
        if (this.pools.containsKey(componentID)) {
            return (ResourceDescriptor)this.pools.get(componentID);
        }
        return null;
    }

    @Override
    public ConnectorBinding getConnectorBinding(ComponentDefnID componentID) {
        if (this.connectors.containsKey(componentID)) {
            return (ConnectorBinding)this.connectors.get(componentID);
        }
        return null;
    }

    @Override
    public ConnectorBinding getConnectorBinding(String name) {
        for (ComponentDefnID id : this.connectors.keySet()) {
            if (!id.getFullName().equalsIgnoreCase(name)) continue;
            return (ConnectorBinding)this.connectors.get(id);
        }
        return null;
    }

    @Override
    public ConnectorBinding getConnectorBindingByRoutingID(String routingID) {
        ConnectorBinding conn = (ConnectorBinding)this.conRoutingToIDMap.get(routingID);
        if (conn != null) {
            return conn;
        }
        return null;
    }

    @Override
    public ServiceComponentDefn getServiceComponentDefn(ComponentDefnID componentID) {
        if (this.svcComponents.containsKey(componentID)) {
            return (ServiceComponentDefn)this.svcComponents.get(componentID);
        }
        return null;
    }

    @Override
    public ServiceComponentDefn getServiceComponentDefn(String name) {
        for (ComponentDefnID id : this.svcComponents.keySet()) {
            if (!id.getName().equalsIgnoreCase(name)) continue;
            return (ServiceComponentDefn)this.svcComponents.get(id);
        }
        return null;
    }

    @Override
    public Collection getComponentDefnIDs(ComponentTypeID componentTypeID) {
        Collection ids = new ArrayList();
        Iterator allDefnsIDs = null;
        allDefnsIDs = this.svcComponents.values().iterator();
        ids = this.getIDs(allDefnsIDs, componentTypeID);
        if (ids.size() > 0) {
            return ids;
        }
        allDefnsIDs = this.connectors.values().iterator();
        ids = this.getIDs(allDefnsIDs, componentTypeID);
        if (ids.size() > 0) {
            return ids;
        }
        allDefnsIDs = this.vms.values().iterator();
        ids = this.getIDs(allDefnsIDs, componentTypeID);
        if (ids.size() > 0) {
            return ids;
        }
        allDefnsIDs = this.pscs.values().iterator();
        ids = this.getIDs(allDefnsIDs, componentTypeID);
        if (ids.size() > 0) {
            return ids;
        }
        allDefnsIDs = this.pools.values().iterator();
        ids = this.getIDs(allDefnsIDs, componentTypeID);
        if (ids.size() > 0) {
            return ids;
        }
        allDefnsIDs = this.hosts.values().iterator();
        ids = this.getIDs(allDefnsIDs, componentTypeID);
        if (ids.size() > 0) {
            return ids;
        }
        allDefnsIDs = this.authProviders.values().iterator();
        ids = this.getIDs(allDefnsIDs, componentTypeID);
        if (ids.size() > 0) {
            return ids;
        }
        return Collections.EMPTY_LIST;
    }

    private Collection getIDs(Iterator allDefnsIDs, ComponentTypeID componentTypeID) {
        ArrayList<BaseID> ids = new ArrayList<BaseID>();
        ComponentDefn aDefn = null;
        while (allDefnsIDs.hasNext()) {
            aDefn = (ComponentDefn)allDefnsIDs.next();
            if (!componentTypeID.equals(aDefn.getComponentTypeID())) continue;
            ids.add(aDefn.getID());
        }
        return ids;
    }

    public Collection getProductServiceConfigIDs(ProductTypeID productTypeID) {
        ArrayList<BaseID> ids = new ArrayList<BaseID>();
        Iterator allDefns = this.pscs.values().iterator();
        ProductServiceConfig aDefn = null;
        while (allDefns.hasNext()) {
            aDefn = (ProductServiceConfig)allDefns.next();
            if (!aDefn.getComponentTypeID().equals(productTypeID)) continue;
            ids.add(aDefn.getID());
        }
        return ids;
    }

    @Override
    public Properties getDependentPropsForComponent(BaseID componentObjectID) {
        if (componentObjectID == null) {
            return new Properties();
        }
        if (componentObjectID instanceof DeployedComponentID) {
            return this.getDependentPropsForDeployedComp((DeployedComponentID)componentObjectID);
        }
        if (componentObjectID instanceof ComponentDefnID) {
            if (!this.doesExist((ComponentDefnID)componentObjectID)) {
                return new Properties();
            }
            return PropertiesUtils.clone((Properties)this.getEditableProperties());
        }
        return new Properties();
    }

    private Properties getDependentPropsForDeployedComp(DeployedComponentID componentID) {
        if (componentID == null) {
            return new Properties();
        }
        if (!this.deployedComponents.containsKey(componentID)) {
            return new Properties();
        }
        BasicDeployedComponent bsc = (BasicDeployedComponent)this.deployedComponents.get(componentID);
        Properties newProps = this.getDependentPropsForComponent(bsc.getDeployedComponentDefnID());
        BasicComponentDefn bcd = (BasicComponentDefn)bsc.getDeployedComponentDefn(this);
        newProps.putAll((Map<?, ?>)PropertiesUtils.clone((Properties)bcd.getEditableProperties()));
        return newProps;
    }

    @Override
    public Properties getAllPropertiesForComponent(BaseID componentObjectID) {
        if (componentObjectID == null) {
            return new Properties();
        }
        Properties newProps = this.getDependentPropsForComponent(componentObjectID);
        if (componentObjectID instanceof DeployedComponentID) {
            BasicDeployedComponent bsc = (BasicDeployedComponent)this.deployedComponents.get(componentObjectID);
            newProps.putAll((Map<?, ?>)PropertiesUtils.clone((Properties)bsc.getEditableProperties()));
        } else if (componentObjectID instanceof ComponentDefnID) {
            ComponentDefn defn = this.getComponentDefn((ComponentDefnID)componentObjectID);
            BasicComponentDefn bcd = (BasicComponentDefn)defn;
            newProps.putAll((Map<?, ?>)PropertiesUtils.clone((Properties)bcd.getEditableProperties()));
        }
        return newProps;
    }

    @Override
    public Collection getDeployedComponents() {
        if (this.deployedComponents == null) {
            this.deployedComponents = new HashMap();
            return new ArrayList(1);
        }
        ArrayList comps = new ArrayList(this.deployedComponents.size());
        comps.addAll(this.deployedComponents.values());
        return comps;
    }

    @Override
    public DeployedComponent getDeployedComponent(DeployedComponentID deployedComponentID) {
        if (!this.deployedComponents.containsKey(deployedComponentID)) {
            return null;
        }
        BasicDeployedComponent bsc = (BasicDeployedComponent)this.deployedComponents.get(deployedComponentID);
        return bsc;
    }

    @Override
    public Collection getDeployedComponents(ComponentDefnID componentID) {
        ArrayList<DeployedComponent> comps = new ArrayList<DeployedComponent>(this.deployedComponents.size());
        if (this.doesExist(componentID)) {
            for (DeployedComponent dc : this.getDeployedComponents()) {
                if (!dc.getDeployedComponentDefnID().equals(componentID)) continue;
                comps.add(dc);
            }
        }
        return comps;
    }

    @Override
    public boolean isPSCDeployed(ProductServiceConfigID pscID) {
        ProductServiceConfig psc = this.getPSC(pscID);
        if (psc == null) {
            return false;
        }
        for (ServiceComponentDefnID svcID : psc.getServiceComponentDefnIDs()) {
            Collection dcs = this.getDeployedComponents(svcID);
            for (DeployedComponent dc : dcs) {
                if (!dc.getProductServiceConfigID().equals(pscID)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Collection getDeployedComponents(ComponentDefnID componentDefnID, ProductServiceConfigID pscID) {
        ArrayList<DeployedComponent> comps = new ArrayList<DeployedComponent>(this.deployedComponents.size());
        if (this.doesExist(componentDefnID)) {
            for (DeployedComponent dc : this.getDeployedComponents()) {
                if (!dc.getDeployedComponentDefnID().equals(componentDefnID) || !dc.getProductServiceConfigID().equals(pscID)) continue;
                comps.add(dc);
            }
        }
        return comps;
    }

    @Override
    public VMComponentDefn getVMForHost(VMComponentDefnID vmID, HostID hostID) {
        Collection dcs = this.getVMsForHost(hostID);
        VMComponentDefn dc2 = null;
        for (VMComponentDefn dc2 : dcs) {
            if (!dc2.getID().equals(vmID)) continue;
            return dc2;
        }
        return null;
    }

    @Override
    public DeployedComponent getDeployedServiceForVM(ServiceComponentDefnID serviceID, VMComponentDefn vmComponent) {
        for (DeployedComponent dc : this.getDeployedComponents()) {
            if (!dc.getDeployedComponentDefnID().equals(serviceID) || !dc.getVMComponentDefnID().equals(vmComponent.getID())) continue;
            return dc;
        }
        return null;
    }

    @Override
    public DeployedComponent getDeployedServiceForVM(ServiceComponentDefnID serviceID, VMComponentDefnID vmID, HostID hostID) {
        for (DeployedComponent dc : this.getDeployedComponents()) {
            if (!dc.getDeployedComponentDefnID().equals(serviceID) || !dc.getVMComponentDefnID().equals(vmID) || !dc.getHostID().equals(hostID)) continue;
            return dc;
        }
        return null;
    }

    @Override
    public Collection getVMsForHost(String name) {
        HostID id = new HostID(name);
        return this.getVMsForHost(id);
    }

    @Override
    public VMComponentDefn getVMForHost(String hostname, String processName) {
        Collection dcs = this.getVMsForHost(hostname);
        VMComponentDefn dc2 = null;
        for (VMComponentDefn dc2 : dcs) {
            if (!dc2.getID().getName().equalsIgnoreCase(processName)) continue;
            return dc2;
        }
        return null;
    }

    @Override
    public Collection getVMsForHost(HostID id) {
        if (id == null) {
            return Collections.EMPTY_LIST;
        }
        Collection dcs = this.getVMComponentDefns();
        HashSet<VMComponentDefn> vms = new HashSet<VMComponentDefn>(dcs.size());
        VMComponentDefn dc2 = null;
        for (VMComponentDefn dc2 : dcs) {
            if (!dc2.getHostID().equals(id)) continue;
            vms.add(dc2);
        }
        return vms;
    }

    @Override
    public Collection getHostIDs() {
        ArrayList hostIDs = new ArrayList(this.hosts.size());
        for (Object o : this.hosts.keySet()) {
            hostIDs.add(o);
        }
        return hostIDs;
    }

    @Override
    public Collection getConnectorBindings() {
        ArrayList results = new ArrayList(this.connectors.size());
        for (ConnectorBindingID cID : this.connectors.keySet()) {
            results.add(this.connectors.get(cID));
        }
        return results;
    }

    @Override
    public Collection getAuthenticationProviders() {
        ArrayList results = new ArrayList(this.authProviders.size());
        for (AuthenticationProviderID aID : this.authProviders.keySet()) {
            results.add(this.authProviders.get(aID));
        }
        return results;
    }

    @Override
    public Collection getHosts() {
        ArrayList results = new ArrayList(this.hosts.size());
        for (HostID hID : this.hosts.keySet()) {
            results.add(this.hosts.get(hID));
        }
        return results;
    }

    public Host getHost(ComponentDefnID hostID) {
        return this.getHost(hostID.getFullName());
    }

    @Override
    public Host getHost(String hostName) {
        if (hostName == null) {
            return null;
        }
        for (HostID hID : this.hosts.keySet()) {
            if (!hID.getFullName().equalsIgnoreCase(hostName)) continue;
            return (Host)this.hosts.get(hID);
        }
        return null;
    }

    @Override
    public Collection getDeployedServicesForVM(VMComponentDefnID vmComponentID) {
        if (vmComponentID == null) {
            return Collections.EMPTY_LIST;
        }
        VMComponentDefn vm = this.getVMComponentDefn(vmComponentID);
        return this.getDeployedServicesForVM(vm);
    }

    @Override
    public Collection getDeployedServicesForVM(VMComponentDefn vm) {
        if (vm == null) {
            return Collections.EMPTY_LIST;
        }
        VMComponentDefnID vmComponentID = (VMComponentDefnID)vm.getID();
        HostID hostID = vm.getHostID();
        Collection dcs = this.getDeployedComponents();
        ArrayList<DeployedComponent> comps = new ArrayList<DeployedComponent>(dcs.size());
        for (DeployedComponent dc : dcs) {
            if (!dc.isDeployedConnector() && !dc.isDeployedService() || !dc.getVMComponentDefnID().equals(vmComponentID) || !dc.getHostID().equals(hostID)) continue;
            comps.add(dc);
        }
        return comps;
    }

    @Override
    public Collection getDeployedServices(VMComponentDefn vm, ProductServiceConfig psc) {
        if (vm == null || psc == null) {
            return Collections.EMPTY_LIST;
        }
        VMComponentDefnID vmComponentID = (VMComponentDefnID)vm.getID();
        HostID hostID = vm.getHostID();
        ProductServiceConfigID pscID = (ProductServiceConfigID)psc.getID();
        Collection dcs = this.getDeployedComponents();
        ArrayList<DeployedComponent> comps = new ArrayList<DeployedComponent>(dcs.size());
        for (DeployedComponent dc : dcs) {
            if (!dc.getVMComponentDefnID().equals(vmComponentID) || !dc.getHostID().equals(hostID) || dc.getProductServiceConfigID() == null || !dc.getProductServiceConfigID().equals(pscID)) continue;
            comps.add(dc);
        }
        return comps;
    }

    @Override
    public Collection getPSCsForVM(VMComponentDefn vm) {
        Iterator deployedServices = this.getDeployedServicesForVM(vm).iterator();
        HashSet<ProductServiceConfig> result = new HashSet<ProductServiceConfig>();
        DeployedComponent dc = null;
        while (deployedServices.hasNext()) {
            dc = (DeployedComponent)deployedServices.next();
            result.add(this.getPSC(dc.getProductServiceConfigID()));
        }
        return result;
    }

    @Override
    public Collection getPSCsForServiceDefn(ServiceComponentDefnID serviceDefnID) {
        ArrayList<ProductServiceConfig> result = new ArrayList<ProductServiceConfig>(this.pscs.size());
        if (serviceDefnID == null) {
            return Collections.EMPTY_LIST;
        }
        ProductServiceConfig psc = null;
        for (Object obj : this.pscs.values()) {
            psc = (ProductServiceConfig)obj;
            if (!psc.getServiceComponentDefnIDs().contains(serviceDefnID)) continue;
            result.add(psc);
        }
        return result;
    }

    @Override
    public Collection getComponentObjectDependencies(BaseID componentObjectID) {
        if (componentObjectID == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ComponentObject> deps = new ArrayList<ComponentObject>();
        Collection dcs = this.getDeployedComponents();
        for (ComponentObject co : dcs) {
            if (!co.isDependentUpon(componentObjectID)) continue;
            deps.add(co);
        }
        if (componentObjectID instanceof ProductServiceConfigID) {
            ProductServiceConfigID pscID = (ProductServiceConfigID)componentObjectID;
            ProductServiceConfig psc = (ProductServiceConfig)this.pscs.get(pscID);
            Collection serviceComponentDefns = psc.getServiceComponentDefnIDs();
            for (ComponentDefnID id : serviceComponentDefns) {
                deps.add(this.getComponentDefn(id));
            }
        } else {
            Map cd = this.getComponentDefns();
            for (ComponentObject co : cd.values()) {
                if (!co.isDependentUpon(componentObjectID)) continue;
                deps.add(co);
            }
        }
        return deps;
    }

    public Collection getResourcePools() {
        if (this.pools == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ComponentDefn> rd = new ArrayList<ComponentDefn>(this.pools.size());
        Iterator compDefns = this.pools.values().iterator();
        ComponentDefn aDefn = null;
        while (compDefns.hasNext()) {
            aDefn = (ComponentDefn)compDefns.next();
            rd.add(aDefn);
        }
        return rd;
    }

    @Override
    public Collection getPSCs() {
        if (this.pscs == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ComponentDefn> rd = new ArrayList<ComponentDefn>(this.pscs.size());
        Iterator compDefns = this.pscs.values().iterator();
        ComponentDefn aDefn = null;
        while (compDefns.hasNext()) {
            aDefn = (ComponentDefn)compDefns.next();
            rd.add(aDefn);
        }
        return rd;
    }

    @Override
    public Collection getServiceComponentDefns() {
        if (this.svcComponents == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ComponentDefn> rd = new ArrayList<ComponentDefn>(this.svcComponents.size());
        Iterator compDefns = this.svcComponents.values().iterator();
        ComponentDefn aDefn = null;
        while (compDefns.hasNext()) {
            aDefn = (ComponentDefn)compDefns.next();
            rd.add(aDefn);
        }
        return rd;
    }

    @Override
    public Collection getVMComponentDefns() {
        if (this.vms == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ComponentDefn> rd = new ArrayList<ComponentDefn>(this.vms.size());
        Iterator compDefns = this.vms.values().iterator();
        ComponentDefn aDefn = null;
        while (compDefns.hasNext()) {
            aDefn = (ComponentDefn)compDefns.next();
            rd.add(aDefn);
        }
        return rd;
    }

    public ResourceDescriptor getResourcePool(String poolName) {
        if (poolName == null) {
            return null;
        }
        Iterator compDefns = this.pools.values().iterator();
        ResourceDescriptor aDefn = null;
        while (compDefns.hasNext()) {
            aDefn = (ResourceDescriptor)compDefns.next();
            if (!aDefn.getName().equalsIgnoreCase(poolName)) continue;
            return aDefn;
        }
        return null;
    }

    @Override
    public LogConfiguration getLogConfiguration() {
        LogConfiguration result = null;
        try {
            result = BasicLogConfiguration.createLogConfiguration(this.getProperties());
        }
        catch (LogConfigurationException e) {
            LogManager.logWarning("CONFIG", CommonPlugin.Util.getString("MSG.003.001.0001"));
            result = new BasicLogConfiguration();
        }
        return result;
    }

    @Override
    public boolean isDeployed() {
        return this.info.isDeployed();
    }

    @Override
    public boolean isLocked() {
        return this.info.isLocked();
    }

    @Override
    public boolean isReleased() {
        return this.info.isReleased();
    }

    void setInfo(ConfigurationInfo configInfo) {
        this.info = (BasicConfigurationInfo)configInfo;
    }

    void setIsRelease(boolean release) {
        this.info.setIsReleased(release);
    }

    void setIsDeployed(boolean deploy) {
        this.info.setIsDeployed(deploy);
    }

    void setIsLocked(boolean lock) {
        this.info.setIsLocked(lock);
    }

    public void addComponentDefn(ComponentDefn component) {
        switch (BasicUtil.getComponentType(component)) {
            case 5: {
                this.vms.put(component.getID(), component);
                return;
            }
            case 2: {
                this.addConnectorBinding(component);
                return;
            }
            case 6: {
                this.pscs.put(component.getID(), component);
                return;
            }
            case 4: {
                this.pools.put(component.getID(), component);
                return;
            }
            case 1: {
                this.svcComponents.put(component.getID(), component);
                return;
            }
            case 11: {
                this.authProviders.put(component.getID(), component);
                return;
            }
            case 7: {
                this.addHost((Host)component);
                return;
            }
        }
    }

    public void addDeployedComponent(DeployedComponent component) {
        this.deployedComponents.put(component.getID(), component);
    }

    public void addHost(Host component) {
        this.hosts.put(component.getID(), component);
    }

    private void addConnectorBinding(ComponentDefn defn) {
        ConnectorBinding cb = (ConnectorBinding)defn;
        this.connectors.put(defn.getID(), defn);
        this.conRoutingToIDMap.put(cb.getRoutingUUID(), defn);
    }

    public void removeComponentObject(ComponentObjectID componentID) {
        if (componentID instanceof ComponentDefnID) {
            ComponentDefnID defnID = (ComponentDefnID)componentID;
            Collection comps = this.getDeployedComponents((ComponentDefnID)componentID);
            DeployedComponent dc2 = null;
            for (DeployedComponent dc2 : comps) {
                this.deployedComponents.remove(dc2.getID());
            }
            switch (BasicUtil.getComponentType(defnID)) {
                case 5: {
                    VMComponentDefn vm = this.getVMComponentDefn((VMComponentDefnID)componentID);
                    this.removeDeployedVM(vm);
                    break;
                }
                case 6: {
                    this.removeDeployedServicesFromPSC((ProductServiceConfigID)componentID);
                    this.pscs.remove(defnID);
                    break;
                }
                case 2: {
                    this.removeServiceFromPSCs((ConnectorBindingID)defnID);
                    this.removeConnectorBinding(defnID);
                    break;
                }
                case 1: {
                    this.removeServiceFromPSCs((ServiceComponentDefnID)defnID);
                    this.svcComponents.remove(defnID);
                    break;
                }
                case 4: {
                    this.pools.remove(defnID);
                    break;
                }
                case 11: {
                    this.authProviders.remove(defnID);
                    break;
                }
                case 7: {
                    this.removeHost((HostID)componentID);
                    break;
                }
                default: {
                    Assertion.assertTrue((boolean)false, (String)("Process Error: component defn of type " + componentID.getClass().getName() + " not accounted for."));
                    break;
                }
            }
        } else if (componentID instanceof DeployedComponentID) {
            this.deployedComponents.remove(componentID);
        }
    }

    private void removeServiceFromPSCs(ServiceComponentDefnID defnID) {
        if (defnID == null) {
            return;
        }
        Collection pscs = null;
        pscs = this.getPSCsForServiceDefn(defnID);
        for (ProductServiceConfig psc : pscs) {
            if (!psc.containsService(defnID)) continue;
            BasicProductServiceConfig basicPSC = (BasicProductServiceConfig)psc;
            basicPSC.removeServiceComponentDefnID(defnID);
        }
    }

    private void removeDeployedServicesFromPSC(ProductServiceConfigID pscID) {
        ProductServiceConfig psc = this.getPSC(pscID);
        if (psc == null) {
            return;
        }
        Iterator serviceDefnIDs = psc.getServiceComponentDefnIDs().iterator();
        ServiceComponentDefnID serviceID = null;
        while (serviceDefnIDs.hasNext()) {
            serviceID = (ServiceComponentDefnID)serviceDefnIDs.next();
            Collection dcs = this.getDeployedComponents(serviceID, (ProductServiceConfigID)psc.getID());
            if (dcs == null) continue;
            for (DeployedComponent comp : dcs) {
                this.removeComponentObject((ComponentObjectID)comp.getID());
            }
        }
    }

    private void removeVMsFromHost(HostID hostID) {
        Collection vms = this.getVMComponentDefns();
        if (vms != null && vms.size() > 0) {
            for (VMComponentDefn vmd : vms) {
                if (!vmd.getHostID().equals(hostID)) continue;
                this.removeDeployedVM(vmd);
            }
        }
    }

    private void removeHost(HostID hostID) {
        this.removeVMsFromHost(hostID);
        this.hosts.remove(hostID);
    }

    private void removeConnectorBinding(ComponentDefnID id) {
        ConnectorBinding cb = this.getConnectorBinding(id);
        if (cb != null) {
            this.connectors.remove(id);
            this.conRoutingToIDMap.remove(cb.getRoutingUUID());
        }
    }

    private void removeDeployedVM(VMComponentDefn vm) {
        if (vm == null) {
            return;
        }
        this.removeDeployedServicesForVM(vm);
        this.vms.remove(vm.getID());
    }

    private void removeDeployedServicesForVM(VMComponentDefn vm) {
        Collection dsvcs = this.getDeployedServicesForVM(vm);
        if (dsvcs != null && dsvcs.size() > 0) {
            for (DeployedComponent smd : dsvcs) {
                this.deployedComponents.remove(smd.getID());
            }
        }
    }

    public void setDeployedComponents(Map components) {
        this.deployedComponents = new HashMap(components.size());
        for (DeployedComponent dc : components.values()) {
            this.deployedComponents.put(dc.getID(), dc);
        }
    }

    public void setConnectors(Map components) {
        this.connectors = new HashMap(components.size());
        for (ComponentDefn dc : components.values()) {
            this.addConnectorBinding(dc);
        }
    }

    public void setComponentDefns(Map components) {
        this.pscs = new HashMap();
        this.svcComponents = new HashMap();
        this.vms = new HashMap();
        this.pools = new HashMap();
        this.connectors = new HashMap();
        for (ComponentDefn cd : components.values()) {
            this.addComponentDefn(cd);
        }
    }

    public void setHosts(Map newHosts) {
        this.hosts = new HashMap(newHosts.size());
        for (Host h : newHosts.values()) {
            this.hosts.put(h.getID(), h);
        }
    }

    @Override
    public synchronized Object clone() {
        BasicConfiguration result = null;
        result = new BasicConfiguration(this);
        BasicConfigurationInfo info = (BasicConfigurationInfo)this.getInfo().clone();
        result.setInfo(info);
        Collection dcs = this.getDeployedComponents();
        for (DeployedComponent dc : dcs) {
            result.addDeployedComponent((DeployedComponent)dc.clone());
        }
        Map cds = this.getComponentDefns();
        for (ComponentDefn cd : cds.values()) {
            result.addComponentDefn((ComponentDefn)cd.clone());
        }
        return result;
    }
}

